-- create table for storing password history
CREATE TABLE password_history (
    userid integer not null REFERENCES _objs(obj),
    password varchar not null,
    changed timestamp without time zone not null DEFAULT (now() at time zone 'UTC'),
    expired integer not null DEFAULT 0
);

-- copy passwords from _obj_attr to password_history
INSERT INTO password_history(userid, password)
  SELECT _objs.obj, '{"sha1":"' || _obj_attr.val || '"}'
    FROM _objs, _obj_attr
    WHERE
      _objs.otype = 'U'
      AND _objs.deleted = 0
      AND _objs.obj = _obj_attr.obj
      AND _obj_attr.attr = 'PASSWORD';
