-- Set UDID=null on delete, Set UDID=null if UDID=''
CREATE OR REPLACE FUNCTION SET_UDID_ON_DELETE_UPDATE() RETURNS TRIGGER AS $$
BEGIN
	if NEW.deleted = 1 then
		NEW.udid := null;
    end if;
    if NEW.udid = '' then 
		NEW.udid := null;
    end if;	
    return NEW;
END;
$$ LANGUAGE plpgsql;

DROP TRIGGER IF EXISTS objs_TBU ON _objs;
CREATE TRIGGER objs_TBU BEFORE update
    ON _objs FOR EACH ROW
    EXECUTE PROCEDURE SET_UDID_ON_DELETE_UPDATE();	
	

-- write udid to _objs
CREATE OR REPLACE FUNCTION updateUDID() RETURNS TRIGGER AS $$
BEGIN
    -- do not write udid for nodes
    if NOT (NEW.otype = 'D' AND NEW.subtype = 'N') then
		if COALESCE(NEW.udid,'') = '' then
			NEW.udid = upper(NEW.otype || NEW.subtype || NEW.obj);
		end if;
    end if;
    return NEW;
END;
$$ LANGUAGE plpgsql;	