-- Set UDID=null on delete
CREATE OR REPLACE FUNCTION SET_UDID_ON_DELETE() RETURNS TRIGGER AS $$
BEGIN
    if NEW.deleted = 1 then
        NEW.udid := null;
    end if;
    return NEW;
END;
$$ LANGUAGE plpgsql;

CREATE TRIGGER objs_TBU BEFORE update
    ON _objs FOR EACH ROW
    EXECUTE PROCEDURE SET_UDID_ON_DELETE();

-- write attr from _obj_attr to _objs on update
CREATE OR REPLACE FUNCTION updateAttributes() RETURNS TRIGGER AS $$
BEGIN
    if NEW.attr = 'NAME' then
        UPDATE _objs
            SET name = NEW.val
            WHERE obj = NEW.obj;
    end if;
    if NEW.attr = 'LOCATION' then
        UPDATE _objs
            SET location = NEW.val
            WHERE obj = NEW.obj;
    end if;
    if NEW.attr = 'DESCRIPTION' then
        UPDATE _objs
            SET description = NEW.val
            WHERE obj = NEW.obj;
    end if;
    if NEW.attr = 'UDID' then
        NEW.val = upper(NEW.val);
        if NEW.val = '' then
            NEW.val = null;
        end if;
        UPDATE _objs
            SET udid = NEW.val
            WHERE obj = NEW.obj;
    end if;
    NEW.val = COALESCE(NEW.val,'');
    return NEW;
END;
$$ LANGUAGE plpgsql;

UPDATE _objs SET udid = null WHERE deleted = 1;
