-- Fix problem with name/description inconsistence for external objects

-- Add missing 'NAME' attributes for external objects
INSERT INTO _obj_attr (obj, attr, val)
    SELECT obj, 'NAME', name FROM _objs o
    WHERE otype='X' and deleted=0 
    and (select val from _obj_attr a where a.obj=o.obj and a.attr='NAME') IS NULL;
    
-- Add missing 'DESC' attribute for external objects
INSERT INTO _obj_attr (obj, attr, val)
    SELECT obj, 'DESC', description FROM _objs o
    WHERE otype='X' and deleted=0 
    and (select val from _obj_attr a where a.obj=o.obj and a.attr='DESC') IS NULL;
