
-- CIRRUS_REMOVE_BEGIN

--
-- Simple informational (single state) workflow with merge
--

INSERT INTO workflow (workflow, protected, name,description,context)
VALUES (6, true, 'Simple Info + merge' ,'Single state workflow with event merge' ,
'<?xml version="1.0" encoding="us-ascii"?>
<scxml version="1.0" xmlns="http://www.w3.org/2005/SCXML" xmlns:skm="http://skm.videonext.com/elog/workflow"> 
  <state id="empty">
    <transition event="create">
      <target next="new"/>
    </transition>
  </state>

  <state id="new">
    <datamodel>
      <data name="statedesc">
        <skm:statedesc desc="New" tags="4,5,8"/>
      </data>
    </datamodel>
    <onentry>
      <send target="elog_actions" targettype="x-runtime" event="db_append"/>
    </onentry>

    <transition event="update">
      <target next="new"/>
    </transition>
  </state>
</scxml>');

INSERT INTO eventsourceworkflow (workflow, eventsource)
SELECT 6, s.eventsource FROM eventsource s;

INSERT INTO eventstate (eventstate, workflow, name, description, actions) VALUES (16, 6, 'new', 'New', null);
INSERT INTO eventstatetag (eventstate, eventtag) VALUES (16, 4), (16,5), (16,8);

--
--
--

UPDATE eventpolicycontent SET infworkflow=6 WHERE eventpolicy=1 AND eventsource IN (1,2,3);
UPDATE eventpolicycontent SET infworkflow=6 WHERE eventpolicy=2 AND eventsource IN (1,2,3,4);
UPDATE eventpolicycontent SET parameters='priority=2|eventtype=0|preevent=5|postevent=15' WHERE eventpolicy=2 AND eventsource=4;

-- CIRRUS_REMOVE_END
