
INSERT INTO eventtype (eventtype, name, description) VALUES (2, 'Suppress', 'Do not create event');



CREATE OR REPLACE FUNCTION el_get_workflow(integer, integer, integer) RETURNS setof EL_Workflow AS
$$
DECLARE 
   obj_id     ALIAS FOR $1;
   source_id  ALIAS FOR $2;
   event_type ALIAS FOR $3;
   result EL_Workflow;
BEGIN
    --
    -- Return:
    --  -1 - do not create event policy, 0 - workflow is not found, 1+ - workflow
    --

    FOR result in
        SELECT CASE q.workflow WHEN -1 THEN -1 ELSE COALESCE(w.workflow, 0) END as workflow, q.parameters
          FROM (SELECT p.parameters,
                       CASE event_type
                           WHEN -1 THEN
                               CASE substring(p.parameters from 'eventtype=([[:digit:]])')
                                   WHEN '2' THEN -1
                                   WHEN '0' THEN p.infworkflow
                                   ELSE p.workflow
                               END 
                           WHEN 2 THEN -1
                           WHEN 0 THEN p.infworkflow
                           ELSE p.workflow
                       END as workflow
                  FROM _obj_attr a, eventpolicycontent p
                 WHERE a.obj=obj_id AND a.attr='EVENT_POLICY'
                   AND p.eventsource=source_id AND CAST(p.eventpolicy AS TEXT)=a.val) q
        LEFT JOIN workflow w ON w.workflow = q.workflow
  LOOP
     RETURN NEXT result;
  END LOOP;
 
RETURN;

END;
$$ LANGUAGE 'plpgsql';
