-- drop outdated tables
DROP TABLE processes;

-- types and subtypes for schedule objects
INSERT INTO _obj_otypes VALUES ('T', 'Schedule');
INSERT INTO _obj_otype_subtype(otype, subtype, name, template, defaultsetobj) VALUES ('T', 'P', 'Posture', 'posture', null);
INSERT INTO _obj_otype_subtype(otype, subtype, name, template, defaultsetobj) VALUES ('T', 'T', 'Timecard', 'timecard', null);
INSERT INTO _obj_otype_subtype(otype, subtype, name, template, defaultsetobj) VALUES ('T', 'S', 'Schedule', 'schedule', null);

-- link between schedule, timecard and posture
CREATE TABLE schedulelink (
   scheduleid integer NOT NULL REFERENCES _objs(obj) ON DELETE CASCADE,
   timecardid integer NOT NULL REFERENCES _objs(obj) ON DELETE CASCADE,
   postureid integer NOT NULL REFERENCES _objs(obj) ON DELETE CASCADE,
   PRIMARY KEY (scheduleid, postureid, timecardid)
);

--
CREATE TABLE schedulehist (
    scheduleid  integer NOT NULL REFERENCES _objs(obj) ON DELETE CASCADE,
    subjectid   integer NOT NULL REFERENCES _objs(obj) ON DELETE CASCADE,
    propname    varchar, -- posture property name
    data        varchar, -- stored property state (simple value or serialized data)
    PRIMARY KEY (scheduleid, subjectid, propname)
);

-- information about current DB version see #960
CREATE TABLE version_confdb (
    VERSION     varchar not null,    -- value like '3.3.0'
    ITERATION   integer not null     -- value like 12
);


-- errlevel renamed into auditlevel
DROP TABLE errlevel;

-- not longer in use (replaced by audit)
DROP TABLE category;
DROP TABLE app_log;
DROP TABLE sys_log;
DROP SEQUENCE log_common_seq;
DROP SEQUENCE log_sys_seq;


-- update system sets Name
UPDATE _obj_attr SET val = 'vMX Monitors' WHERE obj = 4 AND attr = 'NAME';
UPDATE _obj_attr SET val = 'All vMX Monitors' WHERE obj = 4 AND attr = 'DESCRIPTION';

UPDATE _obj_attr SET val = 'vMX Walls' WHERE obj = 5 AND attr = 'NAME';
UPDATE _obj_attr SET val = 'All vMX Walls' WHERE obj = 5 AND attr = 'DESCRIPTION';

UPDATE _obj_attr SET val = 'vAC Sensors' WHERE obj = 8 AND attr = 'NAME';
UPDATE _obj_attr SET val = 'All vAC Sensors' WHERE obj = 8 AND attr = 'DESCRIPTION';

UPDATE _obj_attr SET val = 'vAC Doors' WHERE obj = 9 AND attr = 'NAME';
UPDATE _obj_attr SET val = 'All vAC Doors' WHERE obj = 9 AND attr = 'DESCRIPTION';

UPDATE _obj_attr SET val = 'vAC Perimeters' WHERE obj = 10 AND attr = 'NAME';
UPDATE _obj_attr SET val = 'All vAC Perimeters' WHERE obj = 10 AND attr = 'DESCRIPTION';

UPDATE _obj_attr SET val = 'vAC Areas' WHERE obj = 11 AND attr = 'NAME';
UPDATE _obj_attr SET val = 'All vAC Areas' WHERE obj = 11 AND attr = 'DESCRIPTION';
