
--
-- ACSG 5 states workflow with announcement, timeout and acknowledgement (merge events)
--

INSERT INTO workflow (workflow, protected, name,description,context) 
SELECT COALESCE(max(workflow),0) + 1, true, 'ACSG + merge' ,'' ,
'<?xml version="1.0" encoding="us-ascii"?>
<scxml version="1.0" xmlns="http://www.w3.org/2005/SCXML" xmlns:skm="http://skm.videonext.com/elog/workflow"> 
  <state id="empty">
    <transition event="create">
      <target next="new-updated"/>
    </transition>
  </state>

  <state id="new-updated">
    <datamodel>
      <data name="statedesc">
        <skm:statedesc desc="Event is new or recently updated" tags="3,5,6,7,10,11"/>
      </data>
    </datamodel>

    <onentry>
      <send target="elog_actions" targettype="x-runtime" event="db_append"/>
    </onentry>     
    <onexit>         
      <send target="elog_actions" targettype="x-runtime" event="can_cleared"/>
    </onexit>
    <transition event="sys-ontimer">
      <target next="timeout"/>
    </transition>
    <transition event="announce">
      <target next="announced"/>
    </transition>
    <transition event="ack">
      <target next="assessed"/>
    </transition>
    <transition event="update">
      <target next="assessed"/>
    </transition>
    <transition event="eada">
      <target next="assessed"/>
    </transition>
    <transition event="clear">
      <target next="cleared"/>
    </transition>
  </state>

  <state id="timeout">
    <datamodel>
      <data name="statedesc">
        <skm:statedesc desc="Event did not get acknowledged within required period of time" tags="2,3,5,6,7,11"/>
      </data>
    </datamodel>

    <onentry>
      <send target="elog_actions" targettype="x-runtime" event="db_update"/>
    </onentry>
    <onexit>         
      <send target="elog_actions" targettype="x-runtime" event="can_cleared"/>
    </onexit>     

    <transition event="ack">
      <target next="assessed"/>
    </transition>
    <transition event="update">
      <target next="assessed"/>
    </transition>
    <transition event="clear">
      <target next="cleared"/>
    </transition>
  </state>

  <state id="announced">
    <datamodel>
      <data name="statedesc">
        <skm:statedesc desc="Event notification delivered to operator" tags="3,5,6,7,11"/>
      </data>
    </datamodel>

    <onentry>
      <send target="elog_actions" targettype="x-runtime" event="db_update"/>
    </onentry>
    <onexit>         
      <send target="elog_actions" targettype="x-runtime" event="can_cleared"/>
    </onexit>     

    <transition event="raise-priority">
      <target next="new-updated"/>
    </transition>
    <transition event="ontimer">
      <target next="timeout"/>
    </transition>
    <transition event="ack">
      <target next="assessed"/>
    </transition>
    <transition event="eada">
      <target next="assessed"/>
    </transition>
    <transition event="update">
      <target next="assessed"/>
    </transition>
    <transition event="clear">
      <target next="cleared"/>
    </transition>
  </state>

  <state id="assessed">
    <datamodel>
      <data name="statedesc">
        <skm:statedesc desc="Event is assessed (acknowledgement received)" tags="4,5,6,7"/>
      </data>
    </datamodel>

    <onentry>
      <send target="elog_actions" targettype="x-runtime" event="db_update"/>
      <send target="elog_actions" targettype="x-runtime" event="eada"/>
    </onentry>
    <onexit>         
      <send target="elog_actions" targettype="x-runtime" event="can_cleared"/>
    </onexit>     

    <transition event="raise-priority">
      <target next="new-updated"/>
    </transition>
    <transition event="eada">
      <target next="assessed"/>
    </transition>
    <transition event="update">
      <target next="assessed"/>
    </transition>
    <transition event="clear">
      <target next="cleared"/>
    </transition>
  </state>

  <state id="cleared">
    <datamodel>
      <data name="statedesc">
        <skm:statedesc desc="Cleared" tags="4,8,9"/>
      </data>
    </datamodel>
    <onentry>
      <send target="elog_actions" targettype="x-runtime" event="db_update"/>
    </onentry>

    <transition event="update">
      <target next="cleared"/>
    </transition>
  </state>
</scxml>'
FROM workflow;

INSERT INTO eventsourceworkflow (workflow, eventsource)
SELECT w.workflowid, s.eventsource
  FROM (SELECT max(workflow) as workflowid FROM workflow) w,
       (SELECT eventsource FROM eventsource) s;


-- New-Updated state

INSERT INTO eventstate (eventstate, workflow, name, description, actions)
SELECT COALESCE(s.eventstateid, 0) + 1, w.workflowid, 'new-updated', 'New/Updated', null
  FROM (SELECT max(eventstate) as eventstateid FROM eventstate) s,
       (SELECT max(workflow) as workflowid FROM workflow) w;

INSERT INTO eventstatetag (eventstate, eventtag)
SELECT s.eventstateid, t.eventtagid
  FROM (SELECT max(eventstate) as eventstateid FROM eventstate) s,
       (SELECT 3 as eventtagid
            UNION ALL
        SELECT 5
            UNION ALL
        SELECT 6
            UNION ALL
        SELECT 7
            UNION ALL
        SELECT 10
            UNION ALL
        SELECT 11) t;


-- Timeout state

INSERT INTO eventstate (eventstate, workflow, name, description, actions)
SELECT s.eventstateid + 1, w.workflowid, 'timeout', 'Event did not get acknowledged within required period of time', null
  FROM (SELECT max(eventstate) as eventstateid FROM eventstate) s,
       (SELECT max(workflow) as workflowid FROM workflow) w;

INSERT INTO eventstatetag (eventstate, eventtag)
SELECT s.eventstateid, t.eventtagid
  FROM (SELECT max(eventstate) as eventstateid FROM eventstate) s,
       (SELECT 2 as eventtagid
            UNION ALL
        SELECT 3
            UNION ALL
        SELECT 5
            UNION ALL
        SELECT 6
            UNION ALL
        SELECT 7
            UNION ALL
        SELECT 11) t;


-- Announced state

INSERT INTO eventstate (eventstate, workflow, name, description, actions)
SELECT s.eventstateid + 1, w.workflowid, 'announced', 'Event notification delivered to operator', null
  FROM (SELECT max(eventstate) as eventstateid FROM eventstate) s,
       (SELECT max(workflow) as workflowid FROM workflow) w;

INSERT INTO eventstatetag (eventstate, eventtag)
SELECT s.eventstateid, t.eventtagid
  FROM (SELECT max(eventstate) as eventstateid FROM eventstate) s,
       (SELECT 3 as eventtagid
            UNION ALL
        SELECT 5
            UNION ALL
        SELECT 6
            UNION ALL
        SELECT 7
            UNION ALL
        SELECT 11) t;


-- Assessed state

INSERT INTO eventstate (eventstate, workflow, name, description, actions)
SELECT s.eventstateid + 1, w.workflowid, 'assessed', 'Event is assessed (acknowledgement received)', null
  FROM (SELECT max(eventstate) as eventstateid FROM eventstate) s,
       (SELECT max(workflow) as workflowid FROM workflow) w;

INSERT INTO eventstatetag (eventstate, eventtag)
SELECT s.eventstateid, t.eventtagid
  FROM (SELECT max(eventstate) as eventstateid FROM eventstate) s,
       (SELECT 4 as eventtagid
            UNION ALL
        SELECT 5
            UNION ALL
        SELECT 6
            UNION ALL
        SELECT 7) t;


-- Cleared state

INSERT INTO eventstate (eventstate, workflow, name, description, actions)
SELECT s.eventstateid + 1, w.workflowid, 'cleared', 'Cleared', null
  FROM (SELECT max(eventstate) as eventstateid FROM eventstate) s,
       (SELECT max(workflow) as workflowid FROM workflow) w;

INSERT INTO eventstatetag (eventstate, eventtag)
SELECT s.eventstateid, t.eventtagid
  FROM (SELECT max(eventstate) as eventstateid FROM eventstate) s,
       (SELECT 4 as eventtagid
            UNION ALL
        SELECT 8
            UNION ALL
        SELECT 9) t;



--
-- 5 states workflow with announcement, timeout and acknowledgement (no event merge)
--

INSERT INTO workflow (workflow, protected, name,description,context) 
SELECT max(workflow) + 1, true, 'ACSG / no merge' ,'' ,
'<?xml version="1.0" encoding="us-ascii"?>
<scxml version="1.0" xmlns="http://www.w3.org/2005/SCXML" xmlns:skm="http://skm.videonext.com/elog/workflow"> 
  <state id="empty">
    <transition event="create">
      <target next="new-updated"/>
    </transition>
  </state>

  <state id="new-updated">
    <datamodel>
      <data name="statedesc">
        <skm:statedesc desc="Event is new or recently updated" tags="3,5,6,7,10,11"/>
      </data>
    </datamodel>

    <onentry>
      <send target="elog_actions" targettype="x-runtime" event="db_update"/>
    </onentry>     
    <onexit>         
      <send target="elog_actions" targettype="x-runtime" event="can_cleared"/>
    </onexit>
    <transition event="sys-ontimer">
      <target next="timeout"/>
    </transition>
    <transition event="announce">
      <target next="announced"/>
    </transition>
    <transition event="ack">
      <target next="assessed"/>
    </transition>
    <transition event="update">
      <target next="assessed"/>
    </transition>
    <transition event="eada">
      <target next="assessed"/>
    </transition>
    <transition event="clear">
      <target next="cleared"/>
    </transition>
  </state>

  <state id="timeout">
    <datamodel>
      <data name="statedesc">
        <skm:statedesc desc="Event did not get acknowledged within required period of time" tags="2,3,5,6,7,11"/>
      </data>
    </datamodel>

    <onentry>
      <send target="elog_actions" targettype="x-runtime" event="db_update"/>
    </onentry>
    <onexit>         
      <send target="elog_actions" targettype="x-runtime" event="can_cleared"/>
    </onexit>     

    <transition event="ack">
      <target next="assessed"/>
    </transition>
    <transition event="update">
      <target next="assessed"/>
    </transition>
    <transition event="clear">
      <target next="cleared"/>
    </transition>
  </state>

  <state id="announced">
    <datamodel>
      <data name="statedesc">
        <skm:statedesc desc="Event notification delivered to operator" tags="3,5,6,7,11"/>
      </data>
    </datamodel>

    <onentry>
      <send target="elog_actions" targettype="x-runtime" event="db_update"/>
    </onentry>
    <onexit>         
      <send target="elog_actions" targettype="x-runtime" event="can_cleared"/>
    </onexit>     

    <transition event="raise-priority">
      <target next="new-updated"/>
    </transition>
    <transition event="ontimer">
      <target next="timeout"/>
    </transition>
    <transition event="ack">
      <target next="assessed"/>
    </transition>
    <transition event="eada">
      <target next="assessed"/>
    </transition>
    <transition event="update">
      <target next="assessed"/>
    </transition>
    <transition event="clear">
      <target next="cleared"/>
    </transition>
  </state>

  <state id="assessed">
    <datamodel>
      <data name="statedesc">
        <skm:statedesc desc="Event is assessed (acknowledgement received)" tags="4,5,6,7"/>
      </data>
    </datamodel>

    <onentry>
      <send target="elog_actions" targettype="x-runtime" event="db_update"/>
      <send target="elog_actions" targettype="x-runtime" event="eada"/>
    </onentry>
    <onexit>         
      <send target="elog_actions" targettype="x-runtime" event="can_cleared"/>
    </onexit>     

    <transition event="raise-priority">
      <target next="new-updated"/>
    </transition>
    <transition event="eada">
      <target next="assessed"/>
    </transition>
    <transition event="update">
      <target next="assessed"/>
    </transition>
    <transition event="clear">
      <target next="cleared"/>
    </transition>
  </state>

  <state id="cleared">
    <datamodel>
      <data name="statedesc">
        <skm:statedesc desc="Cleared" tags="4,8,9"/>
      </data>
    </datamodel>
    <onentry>
      <send target="elog_actions" targettype="x-runtime" event="db_update"/>
    </onentry>

    <transition event="update">
      <target next="cleared"/>
    </transition>
  </state>
</scxml>'
FROM workflow;

INSERT INTO eventsourceworkflow (workflow, eventsource)
SELECT w.workflowid, s.eventsource
  FROM (SELECT max(workflow) as workflowid FROM workflow) w,
       (SELECT 1 as eventsource
        UNION ALL
        SELECT 2
        UNION ALL
        SELECT 3
        UNION ALL
        SELECT 4
        UNION ALL
        SELECT 5
        UNION ALL
        SELECT 6) s;


-- New-Updated state

INSERT INTO eventstate (eventstate, workflow, name, description, actions)
SELECT s.eventstateid + 1, w.workflowid, 'new-updated', 'New/Updated', null
  FROM (SELECT max(eventstate) as eventstateid FROM eventstate) s,
       (SELECT max(workflow) as workflowid FROM workflow) w;

INSERT INTO eventstatetag (eventstate, eventtag)
SELECT s.eventstateid, t.eventtagid
  FROM (SELECT max(eventstate) as eventstateid FROM eventstate) s,
       (SELECT 3 as eventtagid
            UNION ALL
        SELECT 5
            UNION ALL
        SELECT 6
            UNION ALL
        SELECT 7
            UNION ALL
        SELECT 10
            UNION ALL
        SELECT 11) t;


-- Announced state

INSERT INTO eventstate (eventstate, workflow, name, description, actions)
SELECT s.eventstateid + 1, w.workflowid, 'announced', 'Event notification delivered to operator', null
  FROM (SELECT max(eventstate) as eventstateid FROM eventstate) s,
       (SELECT max(workflow) as workflowid FROM workflow) w;

INSERT INTO eventstatetag (eventstate, eventtag)
SELECT s.eventstateid, t.eventtagid
  FROM (SELECT max(eventstate) as eventstateid FROM eventstate) s,
       (SELECT 3 as eventtagid
            UNION ALL
        SELECT 5
            UNION ALL
        SELECT 6
            UNION ALL
        SELECT 7
            UNION ALL
        SELECT 11) t;

-- Timeout state

INSERT INTO eventstate (eventstate, workflow, name, description, actions)
SELECT s.eventstateid + 1, w.workflowid, 'timeout', 'Event did not get acknowledged within required period of time', null
  FROM (SELECT max(eventstate) as eventstateid FROM eventstate) s,
       (SELECT max(workflow) as workflowid FROM workflow) w;

INSERT INTO eventstatetag (eventstate, eventtag)
SELECT s.eventstateid, t.eventtagid
  FROM (SELECT max(eventstate) as eventstateid FROM eventstate) s,
       (SELECT 2 as eventtagid
            UNION ALL
        SELECT 3
            UNION ALL
        SELECT 5
            UNION ALL
        SELECT 6
            UNION ALL
        SELECT 7
            UNION ALL
        SELECT 11) t;


-- Assessed state

INSERT INTO eventstate (eventstate, workflow, name, description, actions)
SELECT s.eventstateid + 1, w.workflowid, 'assessed', 'Event is assessed (acknowledgement received)', null
  FROM (SELECT max(eventstate) as eventstateid FROM eventstate) s,
       (SELECT max(workflow) as workflowid FROM workflow) w;

INSERT INTO eventstatetag (eventstate, eventtag)
SELECT s.eventstateid, t.eventtagid
  FROM (SELECT max(eventstate) as eventstateid FROM eventstate) s,
       (SELECT 4 as eventtagid
            UNION ALL
        SELECT 5
            UNION ALL
        SELECT 6
            UNION ALL
        SELECT 7) t;


-- Cleared state

INSERT INTO eventstate (eventstate, workflow, name, description, actions)
SELECT s.eventstateid + 1, w.workflowid, 'cleared', 'Cleared', null
  FROM (SELECT max(eventstate) as eventstateid FROM eventstate) s,
       (SELECT max(workflow) as workflowid FROM workflow) w;

INSERT INTO eventstatetag (eventstate, eventtag)
SELECT s.eventstateid, t.eventtagid
  FROM (SELECT max(eventstate) as eventstateid FROM eventstate) s,
       (SELECT 4 as eventtagid
            UNION ALL
        SELECT 8
            UNION ALL
        SELECT 9) t;




--
-- Alerts workflow (no event merge)
--

INSERT INTO workflow (workflow, protected, name,description,context) 
SELECT COALESCE(max(workflow),0) + 1, true, 'Simple Alert / no merge' ,'Two state (new/cleared) workflow' ,
'<?xml version="1.0" encoding="us-ascii"?>
<scxml version="1.0" xmlns="http://www.w3.org/2005/SCXML" xmlns:skm="http://skm.videonext.com/elog/workflow"> 
  <state id="empty">
    <transition event="create">
      <target next="new"/>
    </transition>
  </state>

  <state id="new">
    <datamodel>
      <data name="statedesc">
        <skm:statedesc desc="Event is new" tags="3,5,10,11"/>
      </data>
    </datamodel>

    <onentry>
      <send target="elog_actions" targettype="x-runtime" event="db_update"/>
    </onentry>     
    <transition event="update">
      <target next="cleared"/>
    </transition>
    <transition event="ack">
      <target next="cleared"/>
    </transition>
  </state>

  <state id="cleared">
    <datamodel>
      <data name="statedesc">
        <skm:statedesc desc="Cleared" tags="4,5,8,9"/>
      </data>
    </datamodel>
    <onentry>
      <send target="elog_actions" targettype="x-runtime" event="db_update"/>
    </onentry>

    <transition event="update">
      <target next="cleared"/>
    </transition>
  </state>
</scxml>'
FROM workflow;

INSERT INTO eventsourceworkflow (workflow, eventsource)
SELECT w.workflowid, s.eventsource
  FROM (SELECT max(workflow) as workflowid FROM workflow) w,
       (SELECT eventsource FROM eventsource) s;


-- New state

INSERT INTO eventstate (eventstate, workflow, name, description, actions)
SELECT COALESCE(s.eventstateid, 0) + 1, w.workflowid, 'new', 'New', null
  FROM (SELECT max(eventstate) as eventstateid FROM eventstate) s,
       (SELECT max(workflow) as workflowid FROM workflow) w;

INSERT INTO eventstatetag (eventstate, eventtag)
SELECT s.eventstateid, t.eventtagid
  FROM (SELECT max(eventstate) as eventstateid FROM eventstate) s,
       (SELECT 3 as eventtagid
            UNION ALL
        SELECT 5
            UNION ALL
        SELECT 10
            UNION ALL
        SELECT 11) t;


-- Cleared state

INSERT INTO eventstate (eventstate, workflow, name, description, actions)
SELECT s.eventstateid + 1, w.workflowid, 'cleared', 'Cleared', null
  FROM (SELECT max(eventstate) as eventstateid FROM eventstate) s,
       (SELECT max(workflow) as workflowid FROM workflow) w;

INSERT INTO eventstatetag (eventstate, eventtag)
SELECT s.eventstateid, t.eventtagid
  FROM (SELECT max(eventstate) as eventstateid FROM eventstate) s,
       (SELECT 4 as eventtagid
            UNION ALL
        SELECT 5
            UNION ALL
        SELECT 8
            UNION ALL
        SELECT 9) t;



--
-- Create default eventpolicy
--  Alert workflow - workflow with ID 1
--  Info workflow - workflow with ID 2
-- 

INSERT INTO eventpolicy (eventpolicy, name, description, protected) VALUES (1 ,'Default policy' ,'', true);

INSERT INTO eventpolicycontent (eventpolicy, eventsource, workflow, infworkflow, parameters) VALUES (1, 1, 1, 2, 'priority=2|eventtype=0|preevent=5|postevent=15');
INSERT INTO eventpolicycontent (eventpolicy, eventsource, workflow, infworkflow, parameters) VALUES (1, 2, 1, 2, 'priority=2|eventtype=0|preevent=5|postevent=15');
INSERT INTO eventpolicycontent (eventpolicy, eventsource, workflow, infworkflow, parameters) VALUES (1, 3, 5, 2, 'priority=2|eventtype=0|preevent=5|postevent=15');
INSERT INTO eventpolicycontent (eventpolicy, eventsource, workflow, infworkflow, parameters) VALUES (1, 4, 5, 2, 'priority=2|eventtype=0|preevent=5|postevent=15');
INSERT INTO eventpolicycontent (eventpolicy, eventsource, workflow, infworkflow, parameters) VALUES (1, 5, 4, 2, 'priority=2|eventtype=1|preevent=5|postevent=15');
INSERT INTO eventpolicycontent (eventpolicy, eventsource, workflow, infworkflow, parameters) VALUES (1, 6, 5, 2, 'priority=2|eventtype=1|preevent=5|postevent=15');

INSERT INTO eventpolicystorage (eventpolicy, eventpriority, preserverhours) VALUES(1, 1, 2);
INSERT INTO eventpolicystorage (eventpolicy, eventpriority, preserverhours) VALUES(1, 2, -1);
INSERT INTO eventpolicystorage (eventpolicy, eventpriority, preserverhours) VALUES(1, 3, 720);
INSERT INTO eventpolicystorage (eventpolicy, eventpriority, preserverhours) VALUES(1, 4, 1440);



INSERT INTO eventpolicy (eventpolicy, name, description, protected) VALUES (2 ,'Default policy for mobile devices' ,'', true);

INSERT INTO eventpolicycontent (eventpolicy, eventsource, workflow, infworkflow, parameters) VALUES (2, 1, 1, 2, 'priority=2|eventtype=0|preevent=5|postevent=15');
INSERT INTO eventpolicycontent (eventpolicy, eventsource, workflow, infworkflow, parameters) VALUES (2, 2, 1, 2, 'priority=2|eventtype=0|preevent=5|postevent=15');
INSERT INTO eventpolicycontent (eventpolicy, eventsource, workflow, infworkflow, parameters) VALUES (2, 3, 5, 2, 'priority=2|eventtype=0|preevent=5|postevent=15');
INSERT INTO eventpolicycontent (eventpolicy, eventsource, workflow, infworkflow, parameters) VALUES (2, 4, 1, 2, 'priority=2|eventtype=0|preevent=5|postevent=15');
INSERT INTO eventpolicycontent (eventpolicy, eventsource, workflow, infworkflow, parameters) VALUES (2, 5, 4, 2, 'priority=2|eventtype=1|preevent=5|postevent=15');
INSERT INTO eventpolicycontent (eventpolicy, eventsource, workflow, infworkflow, parameters) VALUES (2, 6, 5, 2, 'priority=2|eventtype=1|preevent=5|postevent=15');

INSERT INTO eventpolicystorage (eventpolicy, eventpriority, preserverhours) VALUES(2, 1, 2);
INSERT INTO eventpolicystorage (eventpolicy, eventpriority, preserverhours) VALUES(2, 2, -1);
INSERT INTO eventpolicystorage (eventpolicy, eventpriority, preserverhours) VALUES(2, 3, 720);
INSERT INTO eventpolicystorage (eventpolicy, eventpriority, preserverhours) VALUES(2, 4, 1440);


--
-- Assign default eventpolicy to sensors, cameras and audio devices
--
INSERT INTO _obj_attr
SELECT o.obj, 'EVENT_POLICY', CASE t.val WHEN 'iStream' THEN 2 ELSE 1 END
  FROM _objs o
  LEFT JOIN _obj_attr t ON t.obj=o.obj AND t.attr='CAMERAMODEL'
 WHERE otype = 'D' AND subtype in ('A', 'C', 'S')
   AND NOT EXISTS (SELECT val FROM _obj_attr a WHERE a.obj = o.obj AND attr='EVENT_POLICY');
