--  $Id$
-------------------------------------------------------------------------------
--  This module creates tables for SM (storage manager)
-------------------------------------------------------------------------------
--  Author: Alex Teetov
--  Edited by: 
--  QA by:  Christopher C Gettings
--  Copyright: videoNEXT Network Solution Inc
-------------------------------------------------------------------------------
--  Rally S623: Storage Manager with FRD capabilities TA1112: SM:dbsynch
--
--  Note: Postgres SQL required

-- drop table if exists SM_CST     cascade;
-- drop table if exists SM_OST     cascade;
-- drop table if exists SM_STAT    cascade;
-- drop table if exists SM_WHEELS  cascade;
-- drop table if exists SM_UNUSED  cascade;
-- drop table if exists SM_NODES   cascade;
-- drop table if exists SM_DBLOG   cascade;
-- drop table if exists SM_SPACE   cascade;
-- drop sequence if exists SM_DBLOG_RID;

create table SM_NODES (
  NODEID   varchar   constraint PK_SM_NODES  primary key, -- unique nodeid22
  NAME     varchar,           -- screen node name (no unique check)
  CMD      varchar not null default '', --  GUI managed:  SCAN | ADOPT 
                              -- backup/restore managed:  FREEZE | UNFREEZE | RESTORE 
  TARGET   varchar,           -- target identification streeng (NFS,etc)
  STIME    timestamp without time zone not null default (now() at time zone 'UTC'),-- time when CMD is sent
  CMD_END  timestamp without time zone not null default (now() at time zone 'UTC'),-- time when CMD is complete
  ALIVE    timestamp without time zone not null default (now() at time zone 'UTC') -- indicate alive node
);

create table SM_UNUSED (
  NODEID   varchar,
  ID       char(36),
  ------------------------ volume atributes-----------------
  NAME     varchar,     -- non unique name for presentation only, ~ 10 chars
  LIMIT_WRITE integer,  -- write limit in MB/sec 
  TARGET   varchar,     -- target identification streeng (NFS,iSCSI, very long ~60 characters
  MOUNT_OPTIONS varchar,-- special option for mount command
  ------------------------ statistics-----------------------
  SIZE     integer,     -- space in MB
  FREE     integer, 
  ------------------------ actions -------------------------
  CMD      varchar not null default '', -- command: ASSIGN | REMOVE    
  STIME    timestamp without time zone default (now() at time zone 'UTC')
);

create table SM_WHEELS (
  ID       char(36)      constraint PK_SM_WHEELS primary key,
  NODEID   varchar,
           constraint FK_SM_VOLUMES_NODEID_SM_NODES foreign key (NODEID) references  SM_NODES on delete cascade,
  ------------------------ volume atributes-----------------
  NAME     varchar,     -- non unique name for presentation only, ~ 10 chars
  LIMIT_WRITE integer,  -- write limit in MB/sec
  TARGET   varchar,     -- target identification streeng (NFS,iSCSI, very long ~60 characters
  MOUNT_OPTIONS varchar -- special option for mount command
  -- additional attributes -   TBD
  ----------------------------------------------------------
); 
  
create table SM_CST (       -- configurable state (what we want), writable for GUI
  ID       char(36),
           constraint FK_SM_CST_ID_SM_WHEELS foreign key (ID) references  SM_WHEELS on delete cascade,
  CST      varchar default 'OFFLINE',       -- OFFLINE | ONLINE | SUSPEND | DEMOTE
  STIME    timestamp without time zone default (now() at time zone 'UTC')
); 

create table SM_OST (       -- operation status (what we get), readonly for GUI
  ID       char(36),
           constraint FK_SM_CST_ID_SM_WHEELS foreign key (ID) references  SM_WHEELS on delete cascade,
  OST      varchar default 'Offline',         -- Offline|Online|Start|Stop|Mount|
                                              -- Failed|Degraded|Unmarked|Alien|Broken
  STIME    timestamp without time zone default (now() at time zone 'UTC')
);

create table SM_STAT (      -- realtime statistics, readonly for GUI
  ID       char(36),
           constraint FK_SM_CST_ID_SM_WHEELS foreign key (ID) references SM_WHEELS on delete cascade,
  SIZE             integer, -- space in MB
  FREE             integer,
  USED             integer,
  LIMIT_WRITE      integer, -- write limit in MB/sec
  WRITE            integer, -- current write in MB/sec 
  STIME            timestamp without time zone default (now() at time zone 'UTC')
);

create sequence SM_DBLOG_RID;
create table SM_DBLOG (      -- last 10 records about every volume
  RID     integer not null default nextval('SM_DBLOG_RID') constraint PK_SM_DBLOG primary key,
  NODEID  varchar not null,
  LEVEL   char(5),         -- ERROR,INFO,WARN
  ID      char(36),        -- eather UNUSED volume or WHEEL
  MODULE  varchar,         -- name of reporter/module/program
  LINE    integer,         -- reference line in reporter
  STIME   timestamp without time zone default (now() at time zone 'UTC'),
  NOTE    varchar
);
create index SM_DBLOG_I_NODEID_ID on SM_DBLOG (NODEID,ID);

create table SM_SPACE (    -- space-pie info
  NODEID   varchar,
           constraint FK_SM_SPACE_NODEID_SM_NODES foreign key (NODEID) references  SM_NODES on delete cascade,
  OBJID    integer,        -- space consumer (no foreign key please)
  STIME    timestamp without time zone default (now() at time zone 'UTC'),
  SPACE    integer         -- space in KB
);

create table SM_SPACE_SPREAD ( -- space info for every day on every volume (when delete?)
  NODEID   varchar,
           constraint FK_SM_SPACE_SPREAD_NODEID_SM_NODES foreign key (NODEID) references  SM_NODES on delete cascade,
  ID       char(36),    -- no reference
           constraint FK_SM_SPACE_SPREAD_ID_SM_WHEELS foreign key (ID) references  SM_WHEELS on delete cascade,
  OBJID    integer,     -- space consumer (no foreign key please) 
  DAY      integer,     -- like 110124
  SPACE    integer      -- space in KB
);

create table SM_CACHE ( -- node cache info
  NODEID   varchar,
           constraint FK_SM_CACHE_NODEID_SM_NODES foreign key (NODEID) references  SM_NODES on delete cascade,
  SIZE     	integer,     -- current size of cache on particular node in MB
  USAGE    	integer,     -- current [momentary] space usage at time of measure
  STIME    	timestamp without time zone default (now() at time zone 'UTC'),
  CHUNK_LOSS_TS timestamp without time zone default null   -- timestamp of last detected archive chunk loss on node
);

create or replace function SET_STIME() returns "trigger" AS 
'begin  NEW.stime=now(); return NEW; end;' language 'plpgsql' volatile;
create trigger SM_OST_TBU  before update on SM_OST  for each row execute procedure SET_STIME();
create trigger SM_CST_TBU  before update on SM_CST  for each row execute procedure SET_STIME();
create trigger SM_STAT_TBU before update on SM_STAT for each row execute procedure SET_STIME();
create trigger SM_CACHE_TBU before update on SM_CACHE for each row execute procedure SET_STIME();

create or replace function SET_CMD_STIME() returns "trigger" AS
'begin 
  if NEW.CMD!=OLD.CMD and length(NEW.CMD)!=0 then 
   NEW.stime=now(); 
  end if; 
  return NEW; 
end;' language 'plpgsql' volatile;

create trigger SM_NODES_TBU  before update on SM_NODES for each row execute procedure  SET_CMD_STIME();
