#!/usr/bin/perl
#  $Id: reset_psw.pl 32659 2015-06-25 14:45:58Z afomenko $
# -----------------------------------------------------------------------------
#  Reset password for admin user
# -----------------------------------------------------------------------------
#  Author: Kostadin Kanchev
#  Edited by: Alexey Tsibulnik
#  QA by:  Christopher C Gettings
#  Copyright: videoNEXT LLC
# -----------------------------------------------------------------------------

use SKM::DB;
use JSON;

my $USER = $ENV{TARGET_MOD} eq 'ClareVision' ? "clarevision" : "admin";
my $SHA1 = $ENV{TARGET_MOD} eq 'ClareVision' ? "d033e22ae348aeb5660fc2140aec35850c4da997" : "9cde3f9c7f7012d817a4a54f41ded3e151af6b66";
my $SHA512 = $ENV{TARGET_MOD} eq 'ClareVision' ? "c7ad44cbad762a5da0a452f9e854fdc1e0e7a52a38015f23f3eab1d80b931dd472634dfac71cd34ebc35d16ab7fb8a90c81f975113d6c7538dc69dd8de9077ec" : "734c883fb55e212cfe7a48ba6e2a33ff2f7ed275be04aeff6ea228ee6a2ac885ac4dd962a7bafe3514cd0f7cda7163d467b5652e7e1de7fd74a1a12b74b2ee64";

# Encode and update
my $dbh = DBMaster({PrintError => 1}) || die("ERROR!$DBI::errstr\n");
my $passwordInfo = {'sha512' => $SHA512};
if (-e "$ENV{APL}/conf/etc/user/etc/password-legacy.cfg")
{
	$passwordInfo->{'sha1'} = $SHA1;
}
my $passwordInfoJSON = encode_json($passwordInfo);
$dbh->do("INSERT INTO password_history(userid, password, expired, changed) VALUES((select obj from _objs where otype='U' and name='$USER' limit 1), '$passwordInfoJSON', 0, now() at time zone 'UTC' - interval '24 hrs');");
$dbh->do("UPDATE _obj_attr SET val = 0 WHERE obj = (select obj from _objs where otype='U' and name='$USER' limit 1) AND attr = 'LOGON_FAILURE_ATTEMPTS';");
exit $DBI::err ? 1 : 0;

END {
    $dbh->disconnect;
}
#--------------------------------------------------------------

# ----------===== Changes log =====----------
# $Log$
# Revision 1.3  2004/07/02 19:57:46  afomenko
# Added standard comments
#
