#!/usr/bin/perl
# -----------------------------------------------------------------------------
#  $Id: editparam.pl 22889 2011-06-07 15:02:13Z teetov $
#  This script is executed each time system parameters are changed 
#  in "_obj_attr (obj=53)" DB table. 
# -----------------------------------------------------------------------------
#  Author: Serg Pososhenko
#  Edited by: Andrey Fomenko
#  QA by:  Christopher C Gettings
#  Copyright: (c) videoNEXT LLC, 2004-2005
# -----------------------------------------------------------------------------

#use strict;
use SKM::DB;
use SKM::PM;
use Log::Log4perl "get_logger";

my $APL=$ENV{APL}?$ENV{APL}:'/opt/sarch';
require "$APL/common/bin/logger.engine";

my $log=get_logger('NEXTCAM::DB::EDITPARAM');
$log->info('SYSTEM PARAMETERS changed, run "editparam" script');

system("kill `ps ax|grep L3_001/bin/server.pl|cut -c 1-6`"); # let it reread parameters by itself

#--------------open box_param ---------------------------------------------------------
$log->debug('box_param changes checking ');
$dbhmaster = DBMaster({PrintError=>1, AutoCommit=>1})
			or $log->logdie("Failed to connect to master DB: $DBI::errstr");
$log->debug('connected to database _obj_attr (obj=53)'); 
$sth = $dbhmaster->prepare("select attr, val from _obj_attr where obj=53");
$sth->execute() ;
my %res=();
while ( @row = $sth->fetchrow_array ){
    $res{$row[0]}=$row[1];
}
$dbhmaster->disconnect();
$log->debug('The parameters are taken');


# Automatic periodic configurations backup feature #############################
eval {
	if ($res{"BACKUP_AUTO"} == 0) {
		toggleProcess(0, 'backup_auto');
		$log->info("BACKUP_AUTO set to OFF");
	} else {
	    my $check_time = 60*60; #*24*$res{"BACKUP_AUTO"}; # days -> SECONDS !!! last modification - every hour doesn't mater is 
		updateProcess({procname => 'backup_auto', startup => 1, check_time => $check_time });
		$log->info("BACKUP_AUTO set to ON, timeout=$check_time");
	}
};
$log->logdie("Failed to update process 'backup_auto' configuraiton: $@") if ($@);

eval {
	if ($res{MOVE_DATA_FROM_SYSTEM} eq 'yes') {
	    my $check_time = 60*$res{"MOVE_DATA_FROM_SYSTEM_DELAY"}; # MINUTES -> SECONDS
		updateProcess({procname => 'vm_sysmover', startup => 1, check_time => $check_time });
	    $log->info("MOVE_DATA_FROM_SYSTEM set to YES, timeout=$check_time");
	} else {
		toggleProcess(0, 'vm_sysmover');
	    $log->info("MOVE_DATA_FROM_SYSTEM set to NO");
	}
};
$log->logdie("Failed to update process 'vm_sysmover' configuraiton: $@") if ($@);

eval {
	my $check_time = $res{"EVENTS_MIGRATION_TIMEOUT"}||0; # days -> SECONDS !!! last modification - every hour doesn't mater is 
	if ($res{"EVENTS_MIGRATION"} == 0) {
		updateProcess({procname => 'ev_migration', startup => 0, check_time => $check_time });
		$log->info("EVENTS_MIGRATION set to OFF");
	} else {
		updateProcess({procname => 'ev_migration', startup => 1, check_time => $check_time });
		$log->info("EVENTS_MIGRATION set to ON, timeout=$check_time");
	}
};
$log->logdie("Failed to update process 'ev_migration' configuraiton: $@") if ($@);


#-----------------------------------------------------

update_asrv_file();

$log->debug('The parameters are writen ');  

sub update_asrv_file{
   my $conf_dir=$ENV{APL_CONF};
   unlink "$conf_dir/asrv.conf.tmp";
   open (CONF, ">$conf_dir/asrv.conf.tmp") || die "Can't open $conf_dir/asrv.conf\n";
   foreach (keys(%res))
   {
        print CONF "$_=$res{$_}\n";
   }
   close(CONF);
   rename "$conf_dir/asrv.conf.tmp", "$conf_dir/conf/asrv.conf";
}
