package Node::Conf;

use 5.008008;
use strict;
use warnings;

require Exporter;

our @ISA = qw(Exporter);

# Items to export into callers namespace by default. Note: do not export
# names by default without a very good reason. Use EXPORT_OK instead.
# Do not simply export all your public functions/methods/constants.

# This allows declaration	use Node::Conf ':all';
# If you do not need this, moving things directly into @EXPORT or @EXPORT_OK
# will save memory.
our %EXPORT_TAGS = ( 'all' => [ qw(
 UNI RTSP_PORT NodeConf Set_RTSP_PORT Set_OBJID Set_Conf Count_Cores DB_Version am_I_master ActivationInfo
) ] );

our @EXPORT_OK = ( @{ $EXPORT_TAGS{'all'} } );

our @EXPORT = qw(
 UNI NodeConf	
);

our $VERSION = '0.01';


# Preloaded methods go here.
 my $APL       =$ENV{APL};
 my $NODECONF  ="$APL/var/conf/node/conf";
 my $PIDPATH   ="$APL/var/pids";
 my $DBVERSION ="$APL/db/etc/version";
 my $ACT_INFO  ="$APL/var/vctl/activated";
 my $ACT_RES   ="$APL/var/vctl/result";

 sub NodeConf {
     if (open(CONF,$NODECONF)) {
       my %conf=map{/(^\w+)=(.+)/} grep {/^\w+=.+/} <CONF>;
       close CONF;
       return \%conf;
     }
     return undef;
 }
 
 sub am_I_master {
    return -f "$APL/var/conf/master/s_master"
 }

 sub write_conf {
   my $conf=shift;
   my $tmp="$NODECONF.tmp";
   eval {
      open(CONF,">$tmp")                                  || die "ERROR:Cannot open file >$tmp";
      foreach(sort keys %$conf) {
        print(CONF "$_=$conf->{$_}\n")                    || die "ERROR: Cannot write to $tmp";
      }
      close CONF;
      unlink $NODECONF if -f $NODECONF;
      rename($tmp,$NODECONF)                              || die "ERROR: Cannot rename $tmp,$NODECONF";
      # TP435: Override default permissions
      # Chgrp node conf to apache
      my $uid=(getpwnam $ENV{APL_USR})[2];
      my $gid=(getpwnam $ENV{APL_HTTPD_GRP})[2];
      chown($uid,$gid,$NODECONF)			  || die "ERROR: Cannot chown $NODECONF";
      chmod(0640,$NODECONF)				  || die "ERROR: Cannot chmod $NODECONF";
    };
    return $@ if $@;
    return 'SUCCESS';
 }
 sub UNI {
    my $conf=NodeConf();
    return undef if ! $conf;
    return $conf->{'UNI'};
 }
 sub RTSP_PORT {
    my $conf=NodeConf();
    return undef if ! $conf;
    return $conf->{'RTSP_PORT'};
 }
 sub Set_RTSP_PORT {
    my $port=shift;
    my $conf=NodeConf();
    return 0 if exists $conf->{RTSP_PORT} and $port==$conf->{RTSP_PORT}; # port alredy set
    $conf->{RTSP_PORT}=$port;
    return write_conf($conf);
 }
 sub Set_OBJID {
    my $objid=shift;
    my $conf=NodeConf();
    return 0 if exists $conf->{OBJID} and $objid==$conf->{OBJID}; # OBJID alredy set
    $conf->{OBJID}=$objid;
    return write_conf($conf);
 }
 sub Set_Conf {
    my $new_conf=shift;
    my $conf=NodeConf();
    foreach my $attr (keys %$new_conf) {
        $conf->{$attr} = $new_conf->{$attr};
    }
    return write_conf($conf);
 }

 sub Count_Cores
 {
    my $cnt = 0;
    if ($^O=~/darwin/i) {
    	$cnt = `/usr/sbin/ioreg |grep -e "CPU[0-9]@"|wc -l`;
    	$cnt =~ s/^\s+//; $cnt =~ s/\s+$//;
    }
    else {
	# Try to count physical cores for all CPUs
	$cnt = `egrep "core id|physical id" /proc/cpuinfo | tr -d "\\n" | sed s/physical/\\\\nphysical/g | grep -v ^\$ | sort | uniq | wc -l`;
	chomp $cnt;
	if ($cnt == 0) {
	    # Fallback algorythm for old CPUs (e.g. Pentium 3)
	    $cnt = `grep ^processor /proc/cpuinfo | wc -l`;
	}
    }
    chomp $cnt;
    return $cnt;
 }
 
 sub DB_Version {
    my %DBVerBld = ();
    # Read Local Build version
    if (open(FH, $DBVERSION)) {
	while(<FH>) {
	    if (/^VERSION_(\w+)=(.+)-(\d+)$/) {
		my ($db,$ver,$iter) = (lc($1),$2,int($3));
		$DBVerBld{$db}{ver} = $ver;
		$DBVerBld{$db}{iter} = $iter;
	    }
	}
	close FH;
    }
    return \%DBVerBld;
 }
 
 sub ActivationInfo {
    my (%info, %result);
    if (open INFO, $ACT_INFO) {
        %info=map{/(^\w+)=(.+)/} grep {/^\w+=.+/} <INFO>;
        close INFO;
    }
    if (open RESULT, $ACT_RES) {
        %result=map{/(^\w+)=(.+)/} grep {/^\w+=.+/} <RESULT>;
        close RESULT;
    }
    %info = (%info, %result);
    return \%info;
 }

1;
__END__
# Below is stub documentation for your module. You'd better edit it!

=head1 NAME

Node::Conf - Perl extension for access to node conf

(only one method is initially defined UNI)

=head1 SYNOPSIS

  use Node::Conf;
  
  my $node_unique_identificator=UNI;

=head1 DESCRIPTION

  Node::Conf is intended to offer easy access to node conf

=head2 EXPORT

None by default.



=head1 SEE ALSO

Mention other useful documentation such as the documentation of
related modules or operating system documentation (such as man pages
in UNIX), or any relevant external documentation such as RFCs or
standards.

If you have a mailing list set up for your module, mention it here.

If you have a web site set up for your module, mention it here.

=head1 AUTHOR

A.Teetov, E<lt>teetov@videonext.com<gt>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2008 by videoNEXT

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself, either Perl version 5.8.8 or,
at your option, any later version of Perl 5 you may have available.


=cut
