package Master::Conf;

use 5.008008;
use strict;
use warnings;
use Node::Conf "UNI";

require Exporter;

our @ISA = qw(Exporter);

# Items to export into callers namespace by default. Note: do not export
# names by default without a very good reason. Use EXPORT_OK instead.
# Do not simply export all your public functions/methods/constants.

# This allows declaration	use Master::Conf ':all';
# If you do not need this, moving things directly into @EXPORT or @EXPORT_OK
# will save memory.
our %EXPORT_TAGS = ( 'all' => [ qw(
  NodeList NodeIP NodeFQDN NodeVERID MasterIP NodeCmd NodeCopy
) ] );

our @EXPORT_OK = ( @{ $EXPORT_TAGS{'all'} } );

our @EXPORT = qw(
  NodeList NodeIP NodeFQDN NodeVERID MasterIP NodeCmd NodeCopy
);

our $VERSION = '0.01';


# Preloaded methods go here.

 my $APL       =$ENV{APL};
 my $MASTERCONF  ="$APL/var/conf/master";
 my $DEADAFTER   =60; # consider node is dead if not alive for 60 seconds
 
 my $MasterIP;

 sub NodeList {
  my %nodelist; #placeholder for result
  if(opendir(DIR,"$MASTERCONF/nodes")) {
    my @dir=grep{/^\w{22}$/} readdir (DIR);
    close DIR;
    foreach my $id (@dir) {  # reading actual conf files
      my $confname="$MASTERCONF/nodes/$id";
      next if not -f $confname;
      my $mtime = (stat($confname))[9];
      my ($alive,$dead)=(time-$mtime>$DEADAFTER)?(0,$mtime):($mtime,0);
      if (open(CONF,$confname)) {
        my %conf=map{/(^\w+)=(.+)/} grep {/^\w+=.+/} <CONF>;
        close CONF;
        $conf{DEAD}=$dead; $conf{ALIVE}=$alive;
        $nodelist{$id}=\%conf;
      }
    }
  } #else { print "Cannot open $MASTERCONF/nodes" }
  return \%nodelist;
 }

 sub NodeAttibute {
     my ($uni,$attr)=@_;
     my $nlist=NodeList;
     return '' if not exists $nlist->{$uni};
     return '' if not exists $nlist->{$uni}->{$attr};
     $nlist->{$uni}->{$attr};
 }
 
 sub NodeIP   { NodeAttibute (shift,'IP')   }
 sub NodeFQDN { NodeAttibute (shift,'FQDN') }
 sub NodeVERID{ NodeAttibute (shift,'VERID')}
 
 sub MasterIP {
    unless (defined $MasterIP) {
	if (open FH,"$MASTERCONF/s_master") {
	    $MasterIP=<FH>;
	    close FH;
	    chomp $MasterIP if defined $MasterIP;
	}
    }
    $MasterIP;
 }
 
 sub NodeCmd {
    my ($node,$cmd)=@_;
    if (not ref $node or ref $node ne 'HASH') {
	my $nlist=NodeList;
	$node = $nlist->{$node};
    }
    my $out;
    if ($node->{UNI} eq UNI) {
	 $out=`$cmd 2>&1`;
    } else {
	$out=`/usr/bin/ssh $node->{IP} '. $APL/base/etc/env.conf && $cmd' 2>&1`;
    }
    $out;
 }
 
 sub NodeCopy {
    my ($node,$src,$dst)=@_;
    if (not ref $node or ref $node ne 'HASH') {
	my $nlist=NodeList;
	$node = $nlist->{$node};
    }
    if ($node->{UNI} eq UNI) {
	`/bin/cp $src $dst &>/dev/null`;
    } else {
	`/usr/bin/scp $node->{IP}:$src $dst &>/dev/null`;
    }
    $??0:1;
 }

1;
__END__
# Below is stub documentation for your module. You'd better edit it!

=head1 NAME

Master::Conf - Perl extension for access to master conf
(only one method is initially defined NodeList)

=head1 SYNOPSIS

  use Master::Conf;
  my $node_list=NodeList();

=head1 DESCRIPTION

 Master::Conf is intended to offer easy access to node conf

=head2 EXPORT

None by default.

=head1 SEE ALSO

Mention other useful documentation such as the documentation of
related modules or operating system documentation (such as man pages
in UNIX), or any relevant external documentation such as RFCs or
standards.

If you have a mailing list set up for your module, mention it here.

If you have a web site set up for your module, mention it here.

=head1 AUTHOR

A.Teetov, E<lt>teetov@videonext.com<gt>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2008 by videoNEXT

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself, either Perl version 5.8.8 or,
at your option, any later version of Perl 5 you may have available.


=cut
