/*
# $Id: validate.js 19106 2010-07-19 13:57:56Z tsibulskiy $
#------------------------------------------------------------------------------
# Validation functions
# Used for validate camera attributes. Function names defined in the template.
#------------------------------------------------------------------------------
# Author: Serg Tsybulsky
# Edited by: Andrey Starostin
# QA by:
# Copyright: videoNEXT Network Solutions LLC 2006
#-----------------------------------------------------------------------------
*/
window.Validate = window.Validate || {};
Validate.DEFAULT = Validate.DEFAULT || {};
Validate.vmx = Validate.vmx || {};

Validate.DEFAULT.SCHEDULE_LINK = function()
{
	var value = $(Validate.getObj("SCHEDULEID", this)).val();
	if (value === ''){
		Validate.hideAttribute("SCHEDULE_LINK", this);
	} else{
		Validate.showAttribute("SCHEDULE_LINK", this);

		/*Correctly show attribute
		it must be links to necessary devices
		AE_LIST has list of OBJ_ID with delimer ","
		Parse list, create link?
		Create correct Label Name
		 */

		if (value !== ""){
			var element = $(Validate.getObj("SCHEDULE_LINK", this));
			var options = value.split(',');
			Validate.vmx.getObjectNameList({id: element, objList: options, type: 'schedule'},
				function(objParamList){
					element.empty();
					var content = [];
					var hash = window.location.hash;
					for (var j = 0; j < options.length; j++)
					{
						var objID = options[j].replace(/"/g, '&quot;');
						if (objParamList[objID]){
							var objName = "[" + objParamList[objID]['udid'] + "] " + objParamList[objID]["name"];
							content.push('<div><a href="' + hash + '/' + 'schedule_manager_' + objID + '">' + objName +'</a></div>');
						}
					}
					element.html(content.join(''));
				}
			);
		}
	}
};
Validate.DEFAULT.LAYOUT = function()
{
	var LAYOUT_LIST = $(Validate.getObj("SCHEDULE_LAYOUT_LIST", this)).val();
	LAYOUT_LIST = LAYOUT_LIST.split(',');
	for (var i=0; i < LAYOUT_LIST.length; i++ ){
		var select = $(Validate.getObj("LAYOUT" + LAYOUT_LIST[i] , this));
		var wall = select.val();
		if (typeof(wall) != 'undefined'){
			wall = wall + "";
			if(wall.indexOf(',') + 1){
				select.find("option[value='"+wall+"']").remove();
			}
			select.attr("multiple","multiple");
			select.val(wall.split(','));
		}else{
			select.attr("multiple","multiple");
		}

		select.jaoselect({placeholder: 'Please select postures',width: '90%'});
	}
};

