/*
# $Id: validate.js 19106 2010-07-19 13:57:56Z tsibulskiy $
#------------------------------------------------------------------------------
# Validation functions
# Used for validate camera attributes. Function names defined in the template.
#------------------------------------------------------------------------------
# Author: Serg Tsybulsky
# Edited by: Andrey Starostin
# QA by:
# Copyright: videoNEXT Network Solutions LLC 2006
#-----------------------------------------------------------------------------
*/
window.Validate = window.Validate || {};
Validate.isMassObjectEditor = Validate.isMassObjectEditor || false;
Validate.vmx = Validate.vmx || {};

Validate.vmx.getObjectNameList = function(params, callback)
{
	var id = params.id || null;
	var objList = params.objList || null;
	var type = params.type || null;
	var data = {};
	if (objList){
		data.objList = JSON.stringify(objList);
	}
	if (type){
		data.type = type;
	}
	if (!id)
		return;

	id.mask();

	var iAdmin = require("iadmin");

	var api = new API();
	api.getObjectList(data)
		.fail(function(code, message){
			Log.error(message);
		})
		.done(function(response){
			var objectList = response.list;
			var objParamList = [];
			if (objectList)
			{
				for (var num in objectList)
				{
					if (!objectList.hasOwnProperty(num))
						continue;

					var obj = objectList[num]["obj"];
					objParamList[obj] = [];
					objParamList[obj]['name'] = objectList[num]["name"];
					objParamList[obj]['udid'] = objectList[num]["udid"];

					var otype = objectList[num]["otype"];
					var subtype = objectList[num]["subtype"];
					objParamList[obj]['type'] = iAdmin.objectTypes[otype][subtype]["name"];
					objParamList[obj]['template'] = iAdmin.objectTypes[otype][subtype]["template"];
					objParamList[obj]['location'] = objectList[num]["location"];
					objParamList[obj]['fullname'] = objParamList[obj]['type'] + " [" + objParamList[obj]["udid"] + "] "  + objParamList[obj]["name"];
					if (objParamList[obj]['location']) objParamList[obj]['fullname'] += " / " + objParamList[obj]['location'];
				}
			}
			callback(objParamList);
		})
		.always(function(){
			id.unmask();
		});
};
