/**
 * @version $Id: validate.js 28267 2013-04-01 21:27:12Z astarostin $
 * ------------------------------------------------------------------------------
 * Validation functions
 * Used for validate user attributes. Function names defined in the template.
 * ------------------------------------------------------------------------------
 * @author Andrey Starostin
 * @QA
 * @copyright videoNEXT Network Solutions, Inc, 2012
 * ------------------------------------------------------------------------------
 */

window.Validate = window.Validate || {};
Validate.isMassObjectEditor = Validate.isMassObjectEditor || false;

Validate.PASSWORD_TEMPFIELD = function()
{
	Validate.hideAttribute("PASSWORD_TEMPFIELD", this);

	if ($(this).data("obj") != "")
	{
		Validate.hideAttribute("PASSWORD", this);
		Validate.hideAttribute("CONFIRM_PASSWORD", this);
	} else {
		Validate.hideAttribute("UNBLOCK", this);
	}
};

Validate.PASSWORD = function()
{
	if ($(this).data("obj") == "")
	{
		var PASSWORD = $(Validate.getObj("PASSWORD", this)).val();
		var CONFIRM_PASSWORD = $(Validate.getObj("CONFIRM_PASSWORD", this)).val();

		if (PASSWORD != CONFIRM_PASSWORD)
		{
			$(this).data("error", __("Passwords in 'Password' and 'Confirm password' fields not equals"));
		} else {
			$(this).data("error", "");
		}
	}
};

Validate.UNBLOCK = function()
{
	var api = new API();
	api.setAttributes({
		obj: $(this).data("obj"),
		attributes: JSON.stringify({LOGON_FAILURE_ATTEMPTS: 0})
	})
	.fail(function(code, message){
		Log.error(message);
	})
	.done(function(response){
		Log.info(__("User unblocked"));
	});
};
