/**
 * @version $id:$
 * ------------------------------------------------------------------------------
 * validate functions for identity
 * ------------------------------------------------------------------------------
 * @author Andrey Starostin
 * @QA
 * @copyright videoNEXT Network Solutions, Inc, 2013
 * ------------------------------------------------------------------------------
 */

(function(window){
	"use strict";

	window.Validate = window.Validate || {};
	Validate.isMassObjectEditor = Validate.isMassObjectEditor || false;

	Validate.CLOUD_STORAGE_TEST_BUTTON = function()
	{
		var provider = $(Validate.getObj("CLOUD_STORAGE", this)).val();

		var testButton = $(Validate.getObj("CLOUD_STORAGE_TEST_BUTTON", this));
		testButton.mask();

		var api = new API();
		api.getCloudStorageStatus({
			provider: provider
		})
			.fail(function(code, message){
				Log.error(message);
			})
			.done(function(response){
				testButton
					.val(__("Status: ") + __(response.status));
			})
			.always(function(){
				testButton.unmask();
			});
	};

	Validate.CLOUD_PROVIDER_CHANGE = function()
	{
		var provider = $(Validate.getObj("CLOUD_STORAGE", this)).val();
		if (provider == "none") {
			Validate.hideAttribute("CLOUD_STORAGE_ENABLED", this);
			Validate.hideAttribute("CLOUD_KEY_ID", this);
			Validate.hideAttribute("CLOUD_SECRET_KEY", this);
			Validate.hideAttribute("CLOUD_STORAGE_TEST_BUTTON", this);
			Validate.hideAttribute("CLOUD_BUCKET", this);
		}
		else {
			Validate.showAttribute("CLOUD_STORAGE_ENABLED", this);
			Validate.showAttribute("CLOUD_KEY_ID", this);
			Validate.showAttribute("CLOUD_SECRET_KEY", this);
			Validate.showAttribute("CLOUD_STORAGE_TEST_BUTTON", this);
			Validate.showAttribute("CLOUD_BUCKET", this);
		}
	};

	Validate.CLOUD_STORAGE_ENABLED_CHANGE = function()
	{
		if ( $(this).val() == "no") {
			return;
		}

		var provider = $(Validate.getObj("CLOUD_STORAGE", this)).val();

		var self = this;
		var api = new API();
		api.getCloudStorageStatus({
			provider: provider
		})
			.fail(function(code, message){
				Log.error(message);
				$(self).val("no");
			})
			.done(function(response){
				if (response.status != "online") {
					Log.error("Cloud storage is offline");
					$(self).val("no");
				}
			});
	};

	Validate.LDAP_AUTHENTICATION = function()
	{
		var obj = $(this).data("obj");
		var LDAP_AUTHENTICATION = $(this).val();

		if (LDAP_AUTHENTICATION == "yes")
		{
			$("#tab_content_LDAP").find("select[data-attr!=LDAP_AUTHENTICATION][data-obj=" + obj + "], input[data-attr][data-obj=" + obj + "]").each(function(){
				var attribute = $(this).data("attr");
				if (attribute.match(/^LDAP_(.+)/))
				{
					Validate.showAttribute(attribute, this);
					$(this).trigger("change");
				}
			});
		} else
		if (LDAP_AUTHENTICATION == "no")
		{
			$("#tab_content_LDAP").find("select[data-attr!=LDAP_AUTHENTICATION][data-obj=" + obj + "], input[data-attr][data-obj=" + obj + "]").each(function(){
				var attribute = $(this).data("attr");
				if (attribute.match(/^LDAP_(.+)/))
				{
					Validate.hideAttribute(attribute, this);
				}
			});
		}
	};

	Validate.LDAP_AUTHENTICATION_TYPE = function()
	{
		var LDAP_AUTHENTICATION_TYPE = $(this).val();
		var LDAP_AUTHENTICATION =  $(Validate.getObj("LDAP_AUTHENTICATION", this)).val();

		var attributeList = ["LDAP_USER", "LDAP_PASSWORD"];
		if (LDAP_AUTHENTICATION == "no" || LDAP_AUTHENTICATION_TYPE == "anonymous")
		{
			Validate.hideAttribute(attributeList, this);
		} else {
			Validate.showAttribute(attributeList, this);
		}
	};

	Validate.LDAP_TEST = function()
	{
		var api = new API();
		api.testLDAP()
			.done(function(response){
				Log.info(__("Connection is successful"));
				var groupList = response.groupList;
				var groupListText = "Group list for 'Group search base' and 'Group search filter':<br/>";
				for (var i = 0; i < groupList.length; i++)
				{
					groupListText += groupList[i].cn + "<br/>";
				}
				Log.info(groupListText);
			})
			.fail(function(code, message){
				Log.error(__(message));
			});

	};

	Validate.TARGET_ZONE_CONFIGURATOR_BUTTON = function()
	{
		var obj = $(this).data("obj");

		if (obj)
		{
			window.location.href = "/sdi/map/geozoneconfigurator.php?obj=" + obj;
		}
	};

	Validate.GEO_SERVER = function()
	{
		var GEO_SERVER = $(this).val();

		var attributeList = ["GEO_SERVER_WMS_URL", "GEO_SERVER_LAYER_LIST"];
		if (GEO_SERVER == "no")
		{
			Validate.hideAttribute(attributeList, this);
		} else {
			Validate.showAttribute(attributeList, this);
		}
	};

})(window);
