/*
# $Id: validate.js 30490 2014-04-15 14:49:05Z astarostin $
#------------------------------------------------------------------------------
# Validation functions
# Used for validate camera attributes. Function names defined in the template.
#------------------------------------------------------------------------------
# Author: Serg Tsybulsky
# Edited by: Andrey Starostin
# QA by:
# Copyright: videoNEXT Network Solutions LLC 2006
#-----------------------------------------------------------------------------
*/
window.Validate = window.Validate || {};
Validate.Gateway = Validate.Gateway || {};

Validate.Gateway.isInit = true;

Array.prototype.find = function(callback)
{
	for (var i in this)
	{
		if (/^0$|^[1-9]\d*$/.test(i) && i <= 4294967294)
		{
			if (callback(this[i]))
			{
				return this[i];
			}
		}
	}
};

Validate.Gateway.DUMMY = function ()
{
	var commands = $("input[data-attr=COMMANDS]").val();
	commands = commands.split(',');
	$.each(commands, function (i, v) {
		if (v)
		{
			$("#CMDS_DUMMY_row input:checkbox[value=" + v + "]").prop("checked", true);
		}
	});
	$("#CMDS_DUMMY_row input:checkbox").on("click", function ()
	{
		$("input[data-attr=COMMANDS]").val('');
		$("#CMDS_DUMMY_row input:checkbox:checked").each(function (k, checkbox) {
			$("input[data-attr=COMMANDS]").val($("input[data-attr=COMMANDS]").val() + "," + $(checkbox).val());
			if ($("input[data-attr=COMMANDS]").val().indexOf(',') == 0)
			{
				$("input[data-attr=COMMANDS]").val($("input[data-attr=COMMANDS]").val().substring(1));
			}
		});
		$("#saveObject").attr("disabled", false);
	});

	/*	$("#CMDS_DUMMY_row select").attr('multiple', 'multiple');
	 $("#CMDS_DUMMY_row select").jaoselect();*/
};

/**
 * device:
 *	id: device id in gateway
 *	objid: device objid in stratus
 *	name: device name
 *  changed: is device options changed
 *	enabled: is device enabled
 *	---
 *  devices UDID: XX<gateway id>:<parent id>-<id>
*/
Validate.Gateway.devices = [];
Validate.Gateway.DevCreate = function(device, parent, visible)
{
	var dev = $('<div class="device-div" id="' + device.objid + '"/>').css({
		display: (
			visible ? 'block' : 'none'
		),
		margin: (
			parent == null ? '0' : '0 0 0 25px'
		)
	});
	var button = null;
	var children = [];
	if (device.hasOwnProperty('children') && device.children.length > 0)
	{
		button = $('<a class="append-a">+</a>', {
			href: '#'
		}).css({
			cursor: "pointer",
			'text-decoration': "none",
			display: 'inline-block',
			width: '5px'
		});
		dev.append(button);
		for (var v in device.children)
		{
			children.push(Validate.Gateway.DevCreate(device.children[v], device, false));
		}
	}
	var checkbox = $('<input class="device-checkbox" ' + (device.enabled ? 'checked' : '') + ' type="checkbox" />')
		.css({margin: '0 3px 0 5px'});
	var name = $('<div>' + device.name + '</div>').css({
		display: 'inline'
	});
	dev.append(checkbox).append(name);
	for (var v in children)
	{
		dev.append(children[v]);
	}
	return dev;
};

Validate.Gateway.DeepFind = function(array, prop, val)
{
	for (var i in array)
	{
		if (/^0$|^[1-9]\d*$/.test(i) && i <= 4294967294)
		{
			if (array[i][prop] == val)
			{
				return array[i];
			}
		}
	}
	for (var i in array)
	{
		if (/^0$|^[1-9]\d*$/.test(i) && i <= 4294967294)
		{
			var res = Validate.Gateway.DeepFind(array[i].children, prop, val);
			if (res !== false)
			{
				return res;
			}
		}
	}
	return false;
};

Validate.Gateway.DeepSort = function(arr)
{
	arr.sort(function (dev1, dev2) {
		return dev1.name.localeCompare(dev2.name);
	});

	for (var i in arr)
	{
		if (/^0$|^[1-9]\d*$/.test(i) && i <= 4294967294)
		{
			Validate.Gateway.DeepSort(arr[i].children);
		}
	}
};

Validate.Gateway.createDevices = function()
{
	var res = [];
	var udids = $("select[data-attr=DEVICE_UDIDS]").children();
	var last_iteration = 1;
	while (last_iteration > 0)
	{
		last_iteration = 0;
		for (var i in udids)
		{
			if (/^0$|^[1-9]\d*$/.test(i) && i <= 4294967294)
			{
				var udid = $(udids[i]);
				var device = Validate.Gateway.DeepFind(res, "objid", udid.prop('value'));
				if (device !== false)
				{
					continue;
				}
				var slices = udid.html().split(':');
				if (slices.length < 2)
				{
					continue;
				}
				slices[1] = slices[1].split('-');
				if (slices[1][0] == 0)
				{
					res.push({
						id: slices[1][1],
						objid: udid.val(),
						changed: false,
						children: []
					});
					++last_iteration;
				}
				var parent = Validate.Gateway.DeepFind(res, "id", slices[1][0]);
				if (parent !== false)
				{
					parent.children.push({
						id: slices[1][1],
						objid: udid.val(),
						changed: false,
						children: []
					});
					++last_iteration;
				}
			}
		}
	}
	var names = $("select[data-attr=DEVICE_NAMES]").children();
	for (var i in names)
	{
		if (/^0$|^[1-9]\d*$/.test(i) && i <= 4294967294)
		{
			var name = $(names[i]);
			var device = Validate.Gateway.DeepFind(res, "objid", name.prop('value'));
			if (device === false)
			{
				continue;
			}
			device.name = name.html();
		}
	}
	var enableds = $("select[data-attr=DEVICE_ENABLED]").children();
	for (var i in enableds)
	{
		if (/^0$|^[1-9]\d*$/.test(i) && i <= 4294967294)
		{
			var enabled = $(enableds[i]);
			var device = Validate.Gateway.DeepFind(res, "objid", enabled.prop('value'));
			if (device === false)
			{
				continue;
			}
			device.enabled = (
			enabled.html() == 'Y'
			);
		}
	}
	return res;
};

Validate.Gateway.updateDevice = function(devices, objid, enabled)
{
	var device = Validate.Gateway.DeepFind(devices, "objid", objid);
	device.enabled = enabled;
	device.changed = true;
	for (var i in device.children)
	{
		if (/^0$|^[1-9]\d*$/.test(i) && i <= 4294967294)
		{
			var child = device.children[i];
			child.enabled = enabled;
			child.changed = true;
		}
	}
};

Validate.Gateway._DEVS_DUMMY = function()
{
	Validate.hideAttribute("DEVICE_NAMES");
	Validate.hideAttribute("DEVICE_UDIDS");
	Validate.hideAttribute("DEVICE_ENABLED");
	if (Validate.isMassObjectEditor)
	{
		return;
	}
	try
	{
		Validate.Gateway.devices = Validate.Gateway.createDevices();
		Validate.Gateway.DeepSort(Validate.Gateway.devices);
		var devices = Validate.Gateway.devices;
	}
	catch (e)
	{
		return;
	}
	var _parent_td = $("input[data-attr=DEVS_DUMMY]").parent();
	var div_id = $("input[data-attr=DEVS_DUMMY]").attr('id');
	_parent_td.empty();
	var parent_td = $("<div id='" + div_id + "'></div>");
	_parent_td.append(parent_td);
	$.each(devices, function (i, v) {
		parent_td.append(Validate.Gateway.DevCreate(v, null, true));
	});
	$('.append-a').on('click', function (e) {
		var a = $(e.target);
		var div = a.parent();
		if (a.html() == '+')
		{
			div.children('div.device-div').show();
			a.html('-');
		} else {
			div.children('div.device-div').hide();
			a.html('+');
		}
		return false;
	});
	$('.device-checkbox').on('change', function (e) {
		var checkbox = $(e.target);
		var div = checkbox.parent();
		var checkboxes = div.find('.device-checkbox');
		checkboxes.prop('checked', checkbox.is(':checked'));
		Validate.Gateway.updateDevice(Validate.Gateway.devices, div.prop('id'), checkbox.is(':checked'));
		$("input[data-attr=UPD_DEVICES]").prop("disabled", false);
	});
	$("input[data-attr=UPD_DEVICES]").prop("disabled", true);
};

Validate.Gateway.DEVS_DUMMY = function()
{
	setTimeout(Validate.Gateway._DEVS_DUMMY, 1000);
};

Validate.Gateway.deviceUpd = function(device)
{
	if (device.changed)
	{
		var api = new API();
		api.setAttributes({
			obj: device.objid,
			attributes: JSON.stringify({"ENABLED": device.enabled ? 'Y' : 'N'})
		});
	}
	$.each(device.children, function (i, v) {Validate.Gateway.deviceUpd(v)});
};

Validate.Gateway.UPD_DEVICES = function()
{
	$.each(Validate.Gateway.devices, function (i, v) {Validate.Gateway.deviceUpd(v);});
};

/**
 * event:
 *	id - event id (string)
 *	name - event name (string)
 *	options - bit field of options:
 *		accept (0/1) | event type (0-2) << 1 | event priority (0-5) << 3
*/
Validate.Gateway.typesArray = [
	{"id" : 0, "name" : "Default"},
	{"id" : 1, "name" : "Info"},
	{"id" : 2, "name" : "Alert"}
];

/**
 * priority
 * id - priority id (int)
 * name - priority name (string)
*/
Validate.Gateway.priorArray = [];

Validate.Gateway.EventType = function()
{
	var res = {
		id: 0,
		name: "",
		accept: 0,
		type: 0,
		priority: 0,
		nameOption: $("<td />"),
		typeOption: $("<td>Default</td>").css({cursor: "pointer"}),
		acceptOption: $("<td>No</td>").css({cursor: "pointer"}),
		priorOption: $("<td>Default</td>").css({cursor: "pointer"}),
		typeChange: 0,
		priorChange: 0,
		setName: function (Name)
		{
			this.name = Name;
			this.nameOption.html(Name);
			return this;
		},
		setId: function (Id)
		{
			this.id = Id;
			this.nameOption.attr("id", Id);
			this.typeOption.attr("id", Id);
			this.acceptOption.attr("id", Id);
			this.priorOption.attr("id", Id);
			return this;
		},
		updateOptsField: function ()
		{
			$("input[data-type=EVENT_OPTS]").val("");
			var res = "";
			$.each(Validate.Gateway.allEvents, function (i, v) {
				res += v.serialize();
			});
			$("input[data-attr=EVENT_OPTS]").val(res);
			$("#saveObject").removeAttr("disabled");
		},
		setAccept: function (Accept)
		{
			var updated = this.accept != Accept;
			this.accept = Accept;
			this.acceptOption.html(Accept ? "Yes" : "No");
			if (updated)
			{
				this.updateOptsField();
			}
			return this;
		},
		setType: function (Type)
		{
			try
			{
				var updated = this.type != Type;
				this.type = Type;
				if (updated) this.updateOptsField();
				if (this.typeChange == 1) return;
				this.typeOption.html(Validate.Gateway.typesArray.find(function (v, i, a) {
					return v.id == Type;
				}).name);
			}
			catch (e)
			{
				console.log(e);
			}
			return this;
		},
		setPrior: function (Prior)
		{
			try
			{
				var updated = this.priority != Prior;
				this.priority = Prior;
				if (updated) this.updateOptsField();
				if (this.priorChange == 1) return;
				this.priorOption.html(Validate.Gateway.priorArray.find(function (v, i, a) {
					return v.id == Prior;
				}).name);
			}
			catch (e)
			{
				console.log(e);
			}
			return this;
		},
		setOptions: function (Options)
		{
			this.setAccept(Options & 1);
			this.setType((Options & 6) >> 1);
			this.setPrior(Options >> 3);
			return this;
		},
		getOptions: function ()
		{
			return this.accept | this.type << 1 | this.priority << 3;
		},
		reset: function ()
		{
			if (this.typeChange == 1)
			{
				this.typeChange = 0;
				this.setType(this.type);
			}
			if (this.priorChange == 1)
			{
				this.priorChange = 0;
				this.setPrior(this.priority);
			}
		},
		serialize: function ()
		{
			if (this.accept == 0)
				return "";
			return this.id + ":" + this.getOptions() + ",";
		}
	};
	res.acceptOption.click(function ()
	{
		$.each(Validate.Gateway.allEvents, function (i, v) {
			v.reset();
		});
		var accept = res.accept;
		res.setAccept(1 - accept);
	});
	res.typeOption.click(function ()
	{
		if (res.typeChange == 1) return;
		$.each(Validate.Gateway.allEvents, function (i, v) {
			v.reset();
		});
		res.typeChange = 1;
		var typeSelect = Validate.Gateway.TypeSelectCreate(res.type);
		typeSelect.change(function () {
			res.setType(typeSelect.val());
		});
		res.typeOption.empty().append(typeSelect);
	});
	res.priorOption.click(function ()
	{
		if (res.priorChange == 1) return;
		$.each(Validate.Gateway.allEvents, function (i, v) {
			v.reset();
		});
		res.priorChange = 1;
		var priorSelect = Validate.Gateway.PriorSelectCreate(res.priority);
		priorSelect.change(function () {
			res.setPrior(priorSelect.val());
		});
		res.priorOption.empty().append(priorSelect);
	});
	return res;
};

Validate.Gateway.TypeSelectCreate = function(eventType)
{
	var type_select = $('<select class="evt-type-select" />');
	var types_array = Validate.Gateway.typesArray;
	for (var type_key in types_array)
	{
		if (/^0$|^[1-9]\d*$/.test(type_key) && type_key <= 4294967294)
		{
			var type = types_array[type_key];
			var option = $('<option value="' + type.id + '">' + type.name + '</option>');
			if (type.id == eventType)
			{
				option.prop("selected", true);
			}
			type_select.append(option);
		}
	}
	return type_select;
};

Validate.Gateway.PriorSelectCreate = function(eventPrior)
{
	var prior_select = $("select[data-attr=PRIOR_DUMMY]").clone(false);
	prior_select.removeAttr("id").removeAttr("data-attr").removeAttr("data-obj").removeAttr("data-type").addClass("evt-prior-select");
	prior_select.children().removeAttr("selected");
	prior_select.find("option[value=" + eventPrior + "]").prop("selected", true);
	return prior_select;
};


Validate.Gateway.allEvents = [];

Validate.Gateway.createEvents = function()
{
	var res = [];
	$("select[data-attr=EVENT_NAMES] option[value=\"\"]").remove();
	var names = $("select[data-attr=EVENT_NAMES]").children();
	for (var key in names)
	{
		if (/^0$|^[1-9]\d*$/.test(key) && key <= 4294967294)
		{
			res.push(Validate.Gateway.EventType().setName($(names[key]).html()).setId($(names[key]).attr('value')));
		}
	}
	var options = $("input[data-attr=EVENT_OPTS]").val();
	options = options.split(",");
	for (var key in options)
	{
		if (/^0$|^[1-9]\d*$/.test(key) && key <= 4294967294)
		{
			var option = options[key].split(":");
			if (option.length < 2 || !/^[1-9]+$/.test(option[1]))
			{
				continue;
			}
			var event = res.find(function (val, i, arr) { return val.id == option[0]; });
			event.setOptions(option[1]);
		}
	}
	return res;
};

Validate.Gateway._EVTS_DUMMY = function()
{
	try
	{
		var events = Validate.Gateway.createEvents();
		/*JSON.parse($("input[data-attr=ALL_EVENTS]").val());*/
		$("select[data-attr=PRIOR_DUMMY] option").each(function (i, v) {
			Validate.Gateway.priorArray.push({
				id: $(v).attr('value'),
				name: $(v).html()
			});
		});
		events.sort(function (a, b) {return a.name.localeCompare(b.name);});
	}
	catch (e)
	{
		console.log(e);
		return;
	}

	Validate.Gateway.allEvents = events;
	var div_id = $("input[data-attr=EVTS_DUMMY]").attr('id');
	var _parent_td = $("input[data-attr=EVTS_DUMMY]").parent();
	var parent_td = $('<div id="' + div_id + '"></div>');
	_parent_td.empty();
	_parent_td.append(parent_td);
	var parent_table = $('<table id="evt-conf-table"/>').css({"width": "500px"});
	parent_table.append($('<tr />').
	append($('<td>Event name</td>')
		.css({width: "250px"}))
		.append($('<td>Accept</td>')
		.css({width: "50px"})).
	append($('<td>Type</td>')
		.css({width: "100px"}))
		.append($('<td>Priority</td>')
		.css({width: "100px"})));
	$.each(Validate.Gateway.allEvents, function (i, v) {
		parent_table
			.append($('<tr />')
			.append(v.nameOption)
			.append(v.acceptOption)
			.append(v.typeOption)
			.append(v.priorOption));
	});
	parent_td.append(parent_table);
	$("#evt-conf-table td").css({
		"background-color": "white",
		"border": "1px solid #cacaca"
	});
	$("#evt-conf-table tr:nth-child(1) td,#evt-conf-table tr>td:nth-child(1)").css({"background-color": "#cacaca"});
	$("#evt-conf-table tr>td:nth-child(1)").css({"background-color": "#cacaca"});
	$("tr#EVTS_DUMMY_row>td:nth-child(1)").css({width: "17%"});
	Validate.hideAttribute("PRIOR_DUMMY");
	Validate.hideAttribute("EVENT_NAMES");
};

Validate.Gateway.EVTS_DUMMY = function()
{
	Validate.Gateway._EVTS_DUMMY();
};
