/*
# $Id: validate.js 19106 2010-07-19 13:57:56Z tsibulskiy $
#------------------------------------------------------------------------------
# Validation functions
# Used for validate camera attributes. Function names defined in the template.
#------------------------------------------------------------------------------
# Author: Serg Tsybulsky
# Edited by: Andrey Starostin
# QA by:
# Copyright: videoNEXT Network Solutions LLC 2006
#-----------------------------------------------------------------------------
*/
window.Validate = window.Validate || {};
Validate.isMassObjectEditor = Validate.isMassObjectEditor || false;

/**
 * @param {String|Array} attribute
 * @param {Element} obj
 */
Validate.hideAttribute = function(attribute, obj)
{
	var attributeList = [];
	if (typeof attribute == "string")
	{
		attributeList = [attribute];
	} else
	if (Array.isArray(attribute))
	{
		attributeList = attribute;
	} else {
		return;
	}

	for (var i = 0; i < attributeList.length; i++)
	{
		var selector = "#" + attributeList[i] + "_row";
		var cssProperties = {display: "none"};
		if (Validate.isMassObjectEditor)
		{
			selector = "#" + attributeList[i] + "_" + $(obj).data("obj");
			cssProperties = {visibility: "hidden"};
		}

		$(selector).css(cssProperties);
	}
};

/**
 * @param {String|Array} attribute
 * @param {Element} obj
 */
Validate.showAttribute = function(attribute, obj)
{
	var attributeList = [];
	if (typeof attribute == "string")
	{
		attributeList = [attribute];
	} else
	if (Array.isArray(attribute))
	{
		attributeList = attribute;
	} else {
		return;
	}

	for (var i = 0; i < attributeList.length; i++)
	{
		var selector = "#" + attributeList[i] + "_row";
		var cssProperties = {display: ""};
		if (Validate.isMassObjectEditor)
		{
			selector = "#" + attributeList[i] + "_" + $(obj).data("obj");
			cssProperties = {visibility: "visible"};
		}

		$(selector).css(cssProperties);
	}
};

/**
 * @param {String} attribute
 * @param {Element} obj
 * @returns {Boolean}
 */
Validate.isAttributeVisible = function(attribute, obj)
{
	if (Validate.isMassObjectEditor)
	{
		return ($("#" + attribute + "_" + $(obj).data("obj")).css("visibility") !== "hidden")
	} else {
		return ($("#" + attribute + "_row").css('display') !== 'none');
	}
};

/**
 * @param {String} attribute
 * @param {Element} obj
 * @returns {jQuery|HTMLElement}
 */
Validate.getObj = function(attribute, obj)
{
	return $("#" + attribute + "_" + $(obj).data("obj"));
};

Validate.CAM_GEO_CALIBRATION = function()
{
	var attributeList = [
		"CAM_GEO_LAT",
		"CAM_GEO_LONG",
		"CAM_GEO_ALT",
		"CAM_GEO_RANGE",
		"CAM_GEO_TILT",
		"CAM_GEO_AZIMUTH",
		"CAM_GEO_HFOV",
		"CAM_GEO_HFOV_SHOW",
		"CAM_GEO_VIEW_RANGE",
		"CAM_GEO_NORTH_OFFSET",
		"CAM_GEO_ALT_MODE",
		"CAM_GEO_MODEL",
		"CAM_GEO_LAYER",
		"TARGET_ZONE_MONITORING",
		"TARGET_ZONE_CONFIGURATOR_BUTTON",
		"CAM_GEO_CALIBRATOR_BUTTON"
	];

	var value = $(Validate.getObj("CAM_GEO_CALIBRATION", this)).val();
	if (value === 'yes')
	{
		Validate.showAttribute(attributeList, this);
	} else {
		Validate.hideAttribute(attributeList, this);
	}
};

Validate.CAM_GEO_MODEL = function()
{
	var element = $(Validate.getObj("CAM_GEO_MODEL", this));
	var Layer_element = $(Validate.getObj("CAM_GEO_LAYER", this));
	var Layer_element_val = $(Validate.getObj("CAM_GEO_LAYER", this)).val();
	var parentobj = element.val() || null;
	if (parentobj)
	{
		Layer_element.mask();

		var api = new API();
		api.getObjectList({
			parentObj: parentobj,
			withAttributes: true
		})
			.fail(function(code, message){
				Log.error(message);
			})
			.done(function(response){
				var list = response.list || [];
				Layer_element.empty();
				var options = '';
				// there is Sort by NUMBER of leyer
				for (var j = 1; j <= list.length; j++) {
					for (var i = 0; i < list.length; i++)
					{
						if (list[i]['attributes']['NUMBER'] == j){
							var listItem = list[i];
							var number = listItem['attributes']['NUMBER'];
							if (i == 0 && Layer_element_val == ''){
								options += '<option value=' + listItem.obj + ' selected="selected">' + number + '.'+ listItem.name + '</option>';
							}else{
								if(Layer_element_val !== '' && Layer_element_val == listItem.obj)
									options += '<option value=' + listItem.obj + ' selected="selected">' + number + '.'+ listItem.name + '</option>';
								else
									options += '<option value=' + listItem.obj + '>' + number + '.'+ listItem.name + '</option>';
							}
						}
					}
				}
				if (list.length == 0) options = '<option value=""></option>';
				Layer_element.append($(options));
				Layer_element.trigger("change");
			})
			.always(function(){
				Layer_element.unmask();
			});
	} else {
		Layer_element.empty();
		Layer_element.append($('<option value="" selected="selected"></option>'));
		Layer_element.trigger("change");
	}
};

Validate.PTZ_CALIBRATOR_BUTTON = function()
{
	var obj = $(this).data("obj");

	window.location.hash = window.location.hash + "/ptzCalibrator_" + obj;
};

Validate.TARGET_ZONE_MONITORING = function()
{
	var attributeList = [
		// "TARGET_ZONE_CONFIGURATOR_BUTTON",
		"TARGET_ZONE_MAX_OBJECT_AREA",
		"TARGET_ZONE_MIN_AREA_WIDTH"
	];

	var POSITIONCTL = $(Validate.getObj("POSITIONCTL", this)).val();
	if (POSITIONCTL == "none")
	{
		Validate.hideAttribute("TARGET_ZONE_MONITORING", this);
		Validate.hideAttribute(attributeList, this);
	} else {
		var TARGET_ZONE_MONITORING = $(Validate.getObj("TARGET_ZONE_MONITORING", this)).val();
		if (TARGET_ZONE_MONITORING == "yes")
		{
			Validate.showAttribute(attributeList, this);
		} else {
			Validate.hideAttribute(attributeList, this);
		}
	}
};

Validate.TARGET_ZONE_CONFIGURATOR_BUTTON = function()
{
	var obj = $(this).data("obj");

	if (obj)
	{
		window.location.href = "/sdi/map/geozoneconfigurator.php?obj=" + obj;
	}
};

Validate.CAM_GEO_CALIBRATOR_BUTTON = function()
{
	var obj = $(this).data("obj");

	var POSITIONCTL = $(Validate.getObj("POSITIONCTL", this)).val();

	var url = "/sdi/map/geoCalibrator.php?obj=" + obj;
	if (POSITIONCTL && POSITIONCTL !== "none")
	{
		url = "/sdi/map/geoCalibratorPTZ.php?obj=" + obj;
	}

	if (obj)
	{
		window.location.href = url;
	}
};

Validate.TRIGGERBUTTON = function()
{
	if ($(this).data("type") != "triggerbutton")
	{
		Log.error(__("Only for 'triggerbutton' type attributes", 'template'));
		return;
	}

	// TODO: change checking of button state to check state of editor
	if (!$("#saveObject").is(":disabled"))
	{
		Log.warning(__("Please, apply changes before processing this command", 'template'));
		return;
	}

	var obj = $(this).data("obj");
	var attribute = $(this).data("attr");
	var attributes = {};
	attributes[attribute] = 1;

	var self = this;
	$(this).mask();

	var api = new API();
	api.setAttributes({
		obj: obj,
		attributes: JSON.stringify(attributes)
	})
		.fail(function(code, message){
			Log.error(message);
		})
		.done(function(response){
			Log.info(__("Request sent", 'template'));
			$(self).val(__("Request sent", 'template'));
			$(self).prop("disabled", true);
		})
		.always(function(){
			$(self).unmask();
		});
};
