/*
# $Id: validate.js 29043 2013-07-02 18:39:11Z teetov $
#------------------------------------------------------------------------------
# Validation functions
# Used for validate camera attributes. Function names defined in the template.
#------------------------------------------------------------------------------
# Author: Serg Tsybulsky
# Edited by: Andrey Starostin
# QA by:
# Copyright: videoNEXT Network Solutions LLC 2006
#-----------------------------------------------------------------------------
*/
window.Validate = window.Validate || {};
Validate.qtCam = Validate.qtCam || {};

Validate.qtCam.MEDIAFORMAT = function()
{
	Validate.showAttribute("FRAMERATE", this);
	Validate.showAttribute("ARCFRAMERATE", this);
	Validate.showAttribute("CAMCOMPRESSION", this);

	var value = $(Validate.getObj("PROTO", this)).val();
	if (value === 'mjpg'){
		Validate.hideAttribute("RC_MODE", this);
		Validate.hideAttribute("RC_TARGETBITRATE", this);
		Validate.hideAttribute("RC_MAXBITRATE", this);
	} else
	if (value === 'mpeg4' || value === 'h264'){
		Validate.showAttribute("RC_MODE", this);
		$(Validate.getObj("RC_MODE", this)).trigger('change');
	}
};

Validate.qtCam.PROBE = function()
{
	var obj = $(this).data("obj");
	var modelId = $(Validate.getObj("MODELID", this)).val();
	var QTCAM_UNIQUE_ID = $(Validate.getObj("QTCAM_UNIQUE_ID", this)).val();
	var probeObj = $(Validate.getObj("PROBE", this));

	getqtCamCameraList(function(list){
		var inList = false;
		if (list["CAMERAS"].length > 0)
		{
			for (var i = 0; i < list["CAMERAS"].length; i++)
			{
				if (
					QTCAM_UNIQUE_ID === list["CAMERAS"][i].id
					&& modelId === list["CAMERAS"][i].name
				)
				{
					probeObj
						.prop("disabled", true)
						.val("Confirmed");
					inList = true;
					break;
				} else
				if (
					QTCAM_UNIQUE_ID !== list["CAMERAS"][i].id
					&& modelId === list["CAMERAS"][i].name
				)
				{
					var attributes = {};
					attributes["QTCAM_UNIQUE_ID"] = QTCAM_UNIQUE_ID;
					saveObjectAttributes(obj, attributes, false);

					probeObj
						.prop("disabled", true)
						.val(__("Confirmed (change camera id)"));
					inList = true;
					break;
				}
			}
			if (!inList)
			{
				alert(__("Cannot find camera with current modelid.\nPlease add camera through wizard"));
				$(Validate.getObj("PROBE", this))
					.prop("disabled", true)
					.val(__("Not confirmed"));
			}
		}
	});
};
