/*
# $Id: validate.js 28549 2013-05-07 20:08:36Z teetov $
#------------------------------------------------------------------------------
# Validation functions
# Used for validate camera attributes. Function names defined in the template.
#------------------------------------------------------------------------------
# Author: Serg Tsybulsky
# Edited by: Andrey Starostin
# QA by:
# Copyright: videoNEXT Network Solutions LLC 2006
#-----------------------------------------------------------------------------
*/
window.Validate = window.Validate || {};
Validate.panasonic = Validate.panasonic || {};
Validate.panasonic.PROTO = function()
{
	var value = $(Validate.getObj("PROTO", this)).val();
	var value_old_MEDIA_FORMAT = $(Validate.getObj("MEDIA_FORMAT", this)).val();
	if (value === 'RTSP'){
		Validate.hideAttribute("HTTP_PORT", this);
		Validate.showAttribute("RTSP_PORT", this);
		$(Validate.getObj("MEDIA_FORMAT", this)).val('mpeg4');
	} else
	if (value === 'HTTP'){
		Validate.showAttribute("HTTP_PORT", this);
		Validate.hideAttribute("RTSP_PORT", this);
	}
	if (value_old_MEDIA_FORMAT !== $(Validate.getObj("MEDIA_FORMAT", this)).val())
		$(Validate.getObj("MEDIA_FORMAT", this)).trigger('change');
};

Validate.panasonic.CAMCOMPRESSION_MJPG = function()
{
	if (Validate.isAttributeVisible("CAMCOMPRESSION_MJPG", this))
	{
		var CAMCOMPRESSIONvalue = $(Validate.getObj("CAMCOMPRESSION_MJPG", this)).val();
		$(Validate.getObj("CAMCOMPRESSION", this)).val(CAMCOMPRESSIONvalue);
	}
};

Validate.panasonic.CAMCOMPRESSION_MPEG4 = function()
{
	if (Validate.isAttributeVisible("CAMCOMPRESSION_MPEG4", this))
	{
		var CAMCOMPRESSIONvalue = $(Validate.getObj("CAMCOMPRESSION_MPEG4", this)).val();
		$(Validate.getObj("CAMCOMPRESSION", this)).val(CAMCOMPRESSIONvalue);
	}
};

Validate.panasonic.MEDIAFORMAT = function()
{
	var value = $(Validate.getObj("MEDIA_FORMAT", this)).val();
	if (value === 'mpeg4' || value === 'h264'){
		Validate.hideAttribute("CAMCOMPRESSION_MJPG", this);
		Validate.showAttribute("CAMCOMPRESSION_MPEG4", this);

		Validate.showAttribute("RC_MAXBITRATE", this);
		//Validate.showAttribute("RC_TARGETBITRATE", this);

		Validate.hideAttribute("FRAMERATE", this);
		Validate.hideAttribute("ARCFRAMERATE", this);

		$(Validate.getObj("PROTO", this)).val('RTSP');
		Validate.showAttribute("RTSP_PORT", this);
		Validate.hideAttribute("HTTP_PORT", this);
		
		Validate.showAttribute("RTP_OVER_TCP", this);
		Validate.showAttribute("RTP_TIME", this);
		
	} else
	if (value === 'mjpg'){
		Validate.showAttribute("CAMCOMPRESSION_MJPG", this);
		Validate.hideAttribute("CAMCOMPRESSION_MPEG4", this);

		Validate.hideAttribute("RC_MAXBITRATE", this);
		//Validate.hideAttribute("RC_TARGETBITRATE", this);

		Validate.showAttribute("FRAMERATE", this);
		Validate.showAttribute("ARCFRAMERATE", this);

		$(Validate.getObj("PROTO", this)).val('HTTP');
		Validate.hideAttribute("RTSP_PORT", this);
		Validate.showAttribute("HTTP_PORT", this);

		Validate.hideAttribute("RTP_OVER_TCP", this);
		Validate.hideAttribute("RTP_TIME", this);
		
	}
};

Validate.panasonic.MEDIAFORMAT_WV_NW = function()
{
	var value = $(Validate.getObj("MEDIA_FORMAT", this)).val();
	if (value === 'mpeg4' || value === 'h264'){
		Validate.hideAttribute("CAMCOMPRESSION", this);
		Validate.showAttribute("RC_MAXBITRATE", this);

		Validate.hideAttribute("FRAMERATE_MJPG", this);
		Validate.hideAttribute("ARCFRAMERATE_MJPG", this);
		Validate.showAttribute("FRAMERATE_MPEG4", this);
		Validate.showAttribute("ARCFRAMERATE_MPEG4", this);

		if (value === 'mpeg4'){
			Validate.hideAttribute("IMAGESIZE_MJPG", this);
			Validate.hideAttribute("IMAGESIZE_H264", this);
			Validate.showAttribute("IMAGESIZE_MPEG4", this);
			$(Validate.getObj("IMAGESIZE_MPEG4", this)).trigger('change');


		} else if (value === 'h264'){
			Validate.hideAttribute("IMAGESIZE_MJPG", this);
			Validate.hideAttribute("IMAGESIZE_MPEG4", this);
			Validate.showAttribute("IMAGESIZE_H264", this);
			$(Validate.getObj("IMAGESIZE_H264", this)).trigger('change');
		}
		$(Validate.getObj("PROTO", this)).val('RTSP');
		Validate.hideAttribute("HTTP_PORT", this);
		Validate.showAttribute("RTSP_PORT", this);

		Validate.showAttribute("RTP_OVER_TCP", this);
		Validate.showAttribute("RTP_TIME", this);
		Validate.showAttribute("RTP_FORCE_MULTICAST", this);
		
		
		$(Validate.getObj("FRAMERATE_MPEG4", this)).trigger('change');
		$(Validate.getObj("ARCFRAMERATE_MPEG4", this)).trigger('change');
	} else
	if (value === 'mjpg'){

		Validate.hideAttribute("FRAMERATE_MPEG4", this);
		Validate.hideAttribute("ARCFRAMERATE_MPEG4", this);
		Validate.showAttribute("FRAMERATE_MJPG", this);
		Validate.showAttribute("ARCFRAMERATE_MJPG", this);

		Validate.showAttribute("CAMCOMPRESSION", this);
		Validate.hideAttribute("RC_MAXBITRATE", this);
		Validate.hideAttribute("IMAGESIZE_MPEG4", this);
		Validate.hideAttribute("IMAGESIZE_H264", this);
		Validate.showAttribute("IMAGESIZE_MJPG", this);

		$(Validate.getObj("PROTO", this)).val('HTTP');
		Validate.hideAttribute("RTSP_PORT", this);
		Validate.showAttribute("HTTP_PORT", this);
		Validate.hideAttribute("RTP_OVER_TCP", this);
		Validate.hideAttribute("RTP_TIME", this);
		Validate.hideAttribute("RTP_FORCE_MULTICAST", this);
		
		$(Validate.getObj("IMAGESIZE_MJPG", this)).trigger('change');
		$(Validate.getObj("FRAMERATE_MJPG", this)).trigger('change');
		$(Validate.getObj("ARCFRAMERATE_MJPG", this)).trigger('change');

	}
};

Validate.panasonic.FRAMERATE_MJPG = function()
{
	if (Validate.isAttributeVisible("FRAMERATE_MJPG", this))
	{
		var FRAMERATEvalue = $(Validate.getObj("FRAMERATE_MJPG", this)).val();
		$(Validate.getObj("FRAMERATE", this)).val(FRAMERATEvalue);
	}
};

Validate.panasonic.ARCFRAMERATE_MJPG = function()
{
	if (Validate.isAttributeVisible("ARCFRAMERATE_MJPG", this))
	{
		var ARCFRAMERATEvalue = $(Validate.getObj("ARCFRAMERATE_MJPG", this)).val();
		$(Validate.getObj("ARCFRAMERATE", this)).val(ARCFRAMERATEvalue);
	}
};

Validate.panasonic.FRAMERATE_MPEG4 = function()
{
	if (Validate.isAttributeVisible("FRAMERATE_MPEG4", this))
	{
		var FRAMERATEvalue = $(Validate.getObj("FRAMERATE_MPEG4", this)).val();
		$(Validate.getObj("FRAMERATE", this)).val(FRAMERATEvalue);
	}
};

Validate.panasonic.ARCFRAMERATE_MPEG4 = function()
{
	if (Validate.isAttributeVisible("ARCFRAMERATE_MPEG4", this))
	{
		var ARCFRAMERATEvalue = $(Validate.getObj("ARCFRAMERATE_MPEG4", this)).val();
		$(Validate.getObj("ARCFRAMERATE", this)).val(ARCFRAMERATEvalue);
	}
};

Validate.panasonic.IMAGESIZE_MJPG = function()
{
	if (Validate.isAttributeVisible("IMAGESIZE_MJPG", this))
	{
		var IMAGESIZEvalue = $(Validate.getObj("IMAGESIZE_MJPG", this)).val();
		$(Validate.getObj("IMAGESIZE", this)).val(IMAGESIZEvalue);
	}
};

Validate.panasonic.IMAGESIZE_MPEG4 = function()
{
	if (Validate.isAttributeVisible("IMAGESIZE_MPEG4", this))
	{
		var IMAGESIZEvalue = $(Validate.getObj("IMAGESIZE_MPEG4", this)).val();
		$(Validate.getObj("IMAGESIZE", this)).val(IMAGESIZEvalue);
	}
};

Validate.panasonic.IMAGESIZE_H264 = function()
{
	if (Validate.isAttributeVisible("IMAGESIZE_H264", this))
	{
		var IMAGESIZEvalue = $(Validate.getObj("IMAGESIZE_H264", this)).val();
		$(Validate.getObj("IMAGESIZE", this)).val(IMAGESIZEvalue);
	}
};

Validate.panasonic.MEDIAFORMAT_HCM701A = function()
{
	var value = $(Validate.getObj("MEDIA_FORMAT", this)).val();
	if (value === 'h264'){
		Validate.showAttribute("FRAMERATE_HCM701A", this);
		$(Validate.getObj("FRAMERATE_HCM701A", this)).trigger('change');
		Validate.showAttribute("IMAGESIZE_H264_HCM701", this);
		Validate.hideAttribute("IMAGESIZE_MJPG_HCM701", this);
		$(Validate.getObj("PROTO", this)).val('RTSP');
		Validate.hideAttribute("HTTP_PORT", this);
		Validate.showAttribute("RTSP_PORT", this);
		Validate.showAttribute("RTP_OVER_TCP", this);
		Validate.showAttribute("RTP_TIME", this);
		Validate.showAttribute("RTP_FORCE_MULTICAST", this);
		$(Validate.getObj("IMAGESIZE_H264_HCM701", this)).trigger('change');
	} else
	if (value === 'mpeg4'){
		Validate.showAttribute("FRAMERATE_HCM701A", this);
		$(Validate.getObj("FRAMERATE_HCM701A", this)).trigger('change');
		Validate.hideAttribute("IMAGESIZE_H264_HCM701", this);
		Validate.showAttribute("IMAGESIZE_MJPG_HCM701", this);
		$(Validate.getObj("PROTO", this)).val('RTSP');
		Validate.hideAttribute("HTTP_PORT", this);
		Validate.showAttribute("RTSP_PORT", this);
		Validate.showAttribute("RTP_OVER_TCP", this);
		Validate.showAttribute("RTP_TIME", this);
		Validate.showAttribute("RTP_FORCE_MULTICAST", this);
		
		$(Validate.getObj("IMAGESIZE_MJPG_HCM701", this)).trigger('change');
	} else
	if (value === 'mjpg'){
		Validate.hideAttribute("FRAMERATE_HCM701A", this);
		$(Validate.getObj("FRAMERATE", this)).val('30');
		Validate.hideAttribute("IMAGESIZE_H264_HCM701", this);
		Validate.showAttribute("IMAGESIZE_MJPG_HCM701", this);
		$(Validate.getObj("PROTO", this)).val('HTTP');
		Validate.showAttribute("HTTP_PORT", this);
		Validate.hideAttribute("RTSP_PORT", this);
		Validate.hideAttribute("RTP_OVER_TCP", this);
		Validate.hideAttribute("RTP_TIME", this);
		Validate.hideAttribute("RTP_FORCE_MULTICAST", this);
		
		$(Validate.getObj("IMAGESIZE_MJPG_HCM701", this)).trigger('change');
	}
};

Validate.panasonic.FRAMERATE_HCM701A = function()
{
	if (Validate.isAttributeVisible("FRAMERATE_HCM701A", this))
	{
		var FRAMERATEvalue = $(Validate.getObj("FRAMERATE_HCM701A", this)).val();
		$(Validate.getObj("FRAMERATE", this)).val(FRAMERATEvalue);
	}
};


Validate.panasonic.IMAGESIZE_MJPG_HCM701 = function()
{
	if (Validate.isAttributeVisible("IMAGESIZE_MJPG_HCM701", this))
	{
		var IMAGESIZEvalue = $(Validate.getObj("IMAGESIZE_MJPG_HCM701", this)).val();
		$(Validate.getObj("IMAGESIZE", this)).val(IMAGESIZEvalue);
		$(Validate.getObj("IMAGESIZE", this)).trigger('change');
	}
};

Validate.panasonic.IMAGESIZE_H264_HCM701 = function()
{
	if (Validate.isAttributeVisible("IMAGESIZE_H264_HCM701", this))
	{
		var IMAGESIZEvalue = $(Validate.getObj("IMAGESIZE_H264_HCM701", this)).val();
		$(Validate.getObj("IMAGESIZE", this)).val(IMAGESIZEvalue);
		$(Validate.getObj("IMAGESIZE", this)).trigger('change');
	}
};

Validate.panasonic.IMAGESIZE_HCM701A = function()
{
	var value = $(Validate.getObj("IMAGESIZE", this)).val();
	var MEDIAFORMATvalue = $(Validate.getObj("MEDIA_FORMAT", this)).val();

		var isScheduleTARGETBITRATE = $(Validate.getObj("RC_TARGETBITRATE", this)).data('schedule') || false;
		if (isScheduleTARGETBITRATE){
			var TARGETBITRATEvalue = $(Validate.getObj("RC_TARGETBITRATE", this)).val();
			$(Validate.getObj("RC_TARGETBITRATE_640", this)).prop("disabled", true);
			$(Validate.getObj("RC_TARGETBITRATE_320", this)).prop("disabled", true);
			$(Validate.getObj("RC_TARGETBITRATE_192", this)).prop("disabled", true);
		}
		var isScheduleMAXBITRATE = $(Validate.getObj("RC_MAXBITRATE", this)).data('schedule') || false;
		if (isScheduleMAXBITRATE){
			var MAXBITRATEvalue = $(Validate.getObj("RC_MAXBITRATE", this)).val();
			$(Validate.getObj("RC_MAXBITRATE_640", this)).prop("disabled", true);
			$(Validate.getObj("RC_MAXBITRATE_320", this)).prop("disabled", true);
			$(Validate.getObj("RC_MAXBITRATE_192", this)).prop("disabled", true);
		}

	if (MEDIAFORMATvalue == "mjpg"){
		Validate.hideAttribute("RC_TARGETBITRATE_640", this);
		Validate.hideAttribute("RC_MAXBITRATE_640", this);
		Validate.hideAttribute("RC_TARGETBITRATE_320", this);
		Validate.hideAttribute("RC_MAXBITRATE_320", this);
		Validate.hideAttribute("RC_TARGETBITRATE_192", this);
		Validate.hideAttribute("RC_MAXBITRATE_192", this);
	}
	if (MEDIAFORMATvalue == "h264" || MEDIAFORMATvalue == "mpeg4"){
		if (value === '640x480'){
			Validate.showAttribute("RC_TARGETBITRATE_640", this);
			Validate.showAttribute("RC_MAXBITRATE_640", this);
			Validate.hideAttribute("RC_TARGETBITRATE_320", this);
			Validate.hideAttribute("RC_MAXBITRATE_320", this);
			Validate.hideAttribute("RC_TARGETBITRATE_192", this);
			Validate.hideAttribute("RC_MAXBITRATE_192", this);
			$(Validate.getObj("RC_TARGETBITRATE_640", this)).trigger('change');
			$(Validate.getObj("RC_TARGETBITRATE_640", this)).trigger('change');
		} else
		if (value === '320x240'){
			Validate.hideAttribute("RC_TARGETBITRATE_640", this);
			Validate.hideAttribute("RC_MAXBITRATE_640", this);
			Validate.showAttribute("RC_TARGETBITRATE_320", this);
			Validate.showAttribute("RC_MAXBITRATE_320", this);
			Validate.hideAttribute("RC_TARGETBITRATE_192", this);
			Validate.hideAttribute("RC_MAXBITRATE_192", this);
			$(Validate.getObj("RC_TARGETBITRATE_320", this)).trigger('change');
			$(Validate.getObj("RC_MAXBITRATE_320", this)).trigger('change');
		}
		if (value === '192x144'){
			Validate.hideAttribute("RC_TARGETBITRATE_640", this);
			Validate.hideAttribute("RC_MAXBITRATE_640", this);
			Validate.hideAttribute("RC_TARGETBITRATE_320", this);
			Validate.hideAttribute("RC_MAXBITRATE_320", this);
			Validate.showAttribute("RC_TARGETBITRATE_192", this);
			Validate.showAttribute("RC_MAXBITRATE_192", this);
			$(Validate.getObj("RC_TARGETBITRATE_192", this)).trigger('change');
			$(Validate.getObj("RC_MAXBITRATE_192", this)).trigger('change');
		}
	}
};

Validate.panasonic.RC_TARGETBITRATE_640 = function()
{
	var isScheduleTARGETBITRATE = $(Validate.getObj("RC_TARGETBITRATE", this)).data('schedule') || false;
	var isScheduleMAXBITRATE = $(Validate.getObj("RC_MAXBITRATE", this)).data('schedule') || false;
	if (!isScheduleTARGETBITRATE && !isScheduleMAXBITRATE){
		if (Validate.isAttributeVisible("RC_TARGETBITRATE_640", this))
		{
			var value = $(Validate.getObj("RC_TARGETBITRATE_640", this)).val();
			var maxvalue = $(Validate.getObj("RC_MAXBITRATE_640", this)).val();
			if(parseInt(value) <= parseInt(maxvalue)){
				$(Validate.getObj("RC_TARGETBITRATE", this)).val(value);
				$(Validate.getObj("RC_MAXBITRATE", this)).val(maxvalue);
			}else{
				alert(__("Maximum Bitrate should be not less Minimum Bitrate"));
				$(Validate.getObj("RC_TARGETBITRATE_640", this)).val($(Validate.getObj("RC_TARGETBITRATE", this)).val());
				$(Validate.getObj("RC_MAXBITRATE_640", this)).val($(Validate.getObj("RC_MAXBITRATE", this)).val());
			}
		}
	}
};

Validate.panasonic.RC_MAXBITRATE_640 = function()
{
	var isScheduleTARGETBITRATE = $(Validate.getObj("RC_TARGETBITRATE", this)).data('schedule') || false;
	var isScheduleMAXBITRATE = $(Validate.getObj("RC_MAXBITRATE", this)).data('schedule') || false;
	if (!isScheduleTARGETBITRATE && !isScheduleMAXBITRATE){
		if (Validate.isAttributeVisible("RC_MAXBITRATE_640", this))
		{
			var value = $(Validate.getObj("RC_MAXBITRATE_640", this)).val();
			var minvalue = $(Validate.getObj("RC_TARGETBITRATE_640", this)).val();
			if(parseInt(minvalue) <= parseInt(value)){
				$(Validate.getObj("RC_MAXBITRATE", this)).val(value);
				$(Validate.getObj("RC_TARGETBITRATE", this)).val(minvalue);
			}else{
				alert(__("Maximum Bitrate should be not less Minimum Bitrate"));
				$(Validate.getObj("RC_TARGETBITRATE_640", this)).val($(Validate.getObj("RC_TARGETBITRATE", this)).val());
				$(Validate.getObj("RC_MAXBITRATE_640", this)).val($(Validate.getObj("RC_MAXBITRATE", this)).val());
			}
		}
	}
};

Validate.panasonic.RC_TARGETBITRATE_320 = function()
{
	var isScheduleTARGETBITRATE = $(Validate.getObj("RC_TARGETBITRATE", this)).data('schedule') || false;
	var isScheduleMAXBITRATE = $(Validate.getObj("RC_MAXBITRATE", this)).data('schedule') || false;
	if (!isScheduleTARGETBITRATE && !isScheduleMAXBITRATE){
		if (Validate.isAttributeVisible("RC_TARGETBITRATE_320", this))
		{
			var value = $(Validate.getObj("RC_TARGETBITRATE_320", this)).val();
			var maxvalue = $(Validate.getObj("RC_MAXBITRATE_320", this)).val();
			if(parseInt(value) <= parseInt(maxvalue)){
				$(Validate.getObj("RC_TARGETBITRATE", this)).val(value);
				$(Validate.getObj("RC_MAXBITRATE", this)).val(maxvalue);
			}else{
				alert(__("Maximum Bitrate should be not less Minimum Bitrate"));
				$(Validate.getObj("RC_TARGETBITRATE_320", this)).val($(Validate.getObj("RC_TARGETBITRATE", this)).val());
				$(Validate.getObj("RC_MAXBITRATE_320", this)).val($(Validate.getObj("RC_MAXBITRATE", this)).val());
			}
		}
	}
};

Validate.panasonic.RC_MAXBITRATE_320 = function()
{
	var isScheduleTARGETBITRATE = $(Validate.getObj("RC_TARGETBITRATE", this)).data('schedule') || false;
	var isScheduleMAXBITRATE = $(Validate.getObj("RC_MAXBITRATE", this)).data('schedule') || false;
	if (!isScheduleTARGETBITRATE && !isScheduleMAXBITRATE){
		if (Validate.isAttributeVisible("RC_MAXBITRATE_320", this))
		{
			var value = $(Validate.getObj("RC_MAXBITRATE_320", this)).val();
			var minvalue = $(Validate.getObj("RC_TARGETBITRATE_320", this)).val();
			if(parseInt(minvalue) <= parseInt(value)){
				$(Validate.getObj("RC_MAXBITRATE", this)).val(value);
				$(Validate.getObj("RC_TARGETBITRATE", this)).val(minvalue);
			}else
				alert(__("Maximum Bitrate should be not less Minimum Bitrate"));
				$(Validate.getObj("RC_TARGETBITRATE_320", this)).val($(Validate.getObj("RC_TARGETBITRATE", this)).val());
				$(Validate.getObj("RC_MAXBITRATE_320", this)).val($(Validate.getObj("RC_MAXBITRATE", this)).val());
		}
	}
};

Validate.panasonic.RC_TARGETBITRATE_192 = function()
{
	var isScheduleTARGETBITRATE = $(Validate.getObj("RC_TARGETBITRATE", this)).data('schedule') || false;
	var isScheduleMAXBITRATE = $(Validate.getObj("RC_MAXBITRATE", this)).data('schedule') || false;
	if (!isScheduleTARGETBITRATE && !isScheduleMAXBITRATE){
		if (Validate.isAttributeVisible("RC_TARGETBITRATE_192", this))
		{
			var value = $(Validate.getObj("RC_TARGETBITRATE_192", this)).val();
			var maxvalue = $(Validate.getObj("RC_MAXBITRATE_192", this)).val();
			if(parseInt(value) <= parseInt(maxvalue)){
				$(Validate.getObj("RC_TARGETBITRATE", this)).val(value);
				$(Validate.getObj("RC_MAXBITRATE", this)).val(maxvalue);
			}else{
				alert(__("Maximum Bitrate should be not less Minimum Bitrate"));
				$(Validate.getObj("RC_TARGETBITRATE_192", this)).val($(Validate.getObj("RC_TARGETBITRATE", this)).val());
				$(Validate.getObj("RC_MAXBITRATE_192", this)).val($(Validate.getObj("RC_MAXBITRATE", this)).val());
			}
		}
	}
};

Validate.panasonic.RC_MAXBITRATE_192 = function()
{
	var isScheduleTARGETBITRATE = $(Validate.getObj("RC_TARGETBITRATE", this)).data('schedule') || false;
	var isScheduleMAXBITRATE = $(Validate.getObj("RC_MAXBITRATE", this)).data('schedule') || false;
	if (!isScheduleTARGETBITRATE && !isScheduleMAXBITRATE){
		if (Validate.isAttributeVisible("RC_MAXBITRATE_192", this))
		{
			var value = $(Validate.getObj("RC_MAXBITRATE_192", this)).val();
			var minvalue = $(Validate.getObj("RC_TARGETBITRATE_192", this)).val();
			if(parseInt(minvalue) <= parseInt(value)){
				$(Validate.getObj("RC_MAXBITRATE", this)).val(value);
				$(Validate.getObj("RC_TARGETBITRATE", this)).val(minvalue);
			}else
				alert(__("Maximum Bitrate should be not less Minimum Bitrate"));
				$(Validate.getObj("RC_TARGETBITRATE_192", this)).val($(Validate.getObj("RC_TARGETBITRATE", this)).val());
				$(Validate.getObj("RC_MAXBITRATE_192", this)).val($(Validate.getObj("RC_MAXBITRATE", this)).val());
		}
	}
};
