/*
# $Id: validate.js 33162 2015-10-14 22:31:06Z astarostin $
#------------------------------------------------------------------------------
# Validation functions
# Used for validate camera attributes. Function names defined in the template.
#------------------------------------------------------------------------------
# Author: Serg Tsybulsky
# Edited by: Andrey Starostin
# QA by:
# Copyright: videoNEXT Network Solutions LLC 2006
#-----------------------------------------------------------------------------
*/
window.Validate = window.Validate || {};
Validate.Vivotek = Validate.Vivotek || {};

Validate.Vivotek.MEDIAFORMAT = function()
{
	var value = $(Validate.getObj("MEDIA_FORMAT", this)).val();
	if (value === 'mjpg'){
		Validate.hideAttribute("INTRAFRAME", this);
		Validate.hideAttribute("RC_MODE", this);
		Validate.hideAttribute("RC_TARGETBITRATE", this);
		Validate.hideAttribute("RC_MAXBITRATE", this);
		Validate.showAttribute("CAMCOMPRESSION", this);

		$(Validate.getObj("PROTO", this)).val('HTTP');
		Validate.showAttribute("HTTP_PORT", this);
		Validate.hideAttribute("RTSP_PORT", this);
		Validate.hideAttribute("RTP_OVER_TCP", this);
		Validate.hideAttribute("RTP_TIME", this);

		$(Validate.getObj("AUDIO", this)).val('off');
		$(Validate.getObj("AUDIO", this)).prop("disabled", true);
	} else
	if (value === 'mpeg4' || value === 'h264'){
		Validate.showAttribute("INTRAFRAME", this);
		Validate.showAttribute("RC_MODE", this);
		$(Validate.getObj("RC_MODE", this)).trigger('change');

		$(Validate.getObj("PROTO", this)).val('RTSP');
		Validate.hideAttribute("HTTP_PORT", this);
		Validate.showAttribute("RTSP_PORT", this);
		Validate.showAttribute("RTP_OVER_TCP", this);
		Validate.showAttribute("RTP_TIME", this);

		$(Validate.getObj("AUDIO", this)).prop("disabled", false);
	}
};

Validate.Vivotek.RC_MODE = function()
{
	var value = $(Validate.getObj("RC_MODE", this)).val();
	if (value === 'cbr'){
		Validate.showAttribute("RC_TARGETBITRATE", this);
		Validate.hideAttribute("RC_MAXBITRATE", this);
		Validate.hideAttribute("CAMCOMPRESSION", this);
	} else
	if (value === 'vbr'){
		Validate.hideAttribute("RC_TARGETBITRATE", this);
		Validate.hideAttribute("RC_MAXBITRATE", this);
		Validate.showAttribute("CAMCOMPRESSION", this);
	}
};
