/**
 * @version $Id: validate.js 28549 2013-05-07 20:08:36Z teetov $
 * ------------------------------------------------------------------------------
 * Validation functions
 * Used for validate camera attributes. Function names defined in the template.
 * ------------------------------------------------------------------------------
 * @author Andrey Starostin
 * @QA
 * @copyright videoNEXT Network Solutions LLC 2010
 * ------------------------------------------------------------------------------
 */

window.Validate = window.Validate || {};
Validate.URL = Validate.URL || {};

Validate.URL.MEDIA_FORMAT = function()
{
	var value = $(Validate.getObj("MEDIA_FORMAT", this)).val();
	if (value === 'mjpg'){
		Validate.hideAttribute("RC_MODE", this);
		Validate.hideAttribute("RC_TARGETBITRATE", this);
		Validate.hideAttribute("RC_MAXBITRATE", this);

		Validate.hideAttribute("FRAMERATE", this);
		Validate.hideAttribute("ARCFRAMERATE", this);
		Validate.hideAttribute("CAMCOMPRESSION", this);

		$(Validate.getObj("PROTO", this)).val('HTTP');

		Validate.showAttribute("HTTP_PORT", this);
		Validate.hideAttribute("RTSP_PORT", this);
		Validate.hideAttribute("RTP_OVER_TCP", this);
		Validate.hideAttribute("RTP_TIME", this);
		Validate.hideAttribute("RTP_FORCE_MULTICAST", this);
		
	} else
	if (value === 'mpeg4' || value === 'h264' || value === 'mpeg2'){
		Validate.hideAttribute("RC_MODE", this);
		Validate.hideAttribute("RC_TARGETBITRATE", this);
		Validate.hideAttribute("RC_MAXBITRATE", this);

		Validate.hideAttribute("FRAMERATE", this);
		Validate.hideAttribute("ARCFRAMERATE", this);
		Validate.hideAttribute("CAMCOMPRESSION", this);

		$(Validate.getObj("PROTO", this)).val('RTSP');
		Validate.hideAttribute("HTTP_PORT", this);
		Validate.showAttribute("RTSP_PORT", this);
		Validate.showAttribute("RTP_OVER_TCP", this);
		Validate.showAttribute("RTP_TIME", this);
		Validate.showAttribute("RTP_FORCE_MULTICAST", this);
		
	}
};