/*
# $Id: validate.js 28549 2013-05-07 20:08:36Z teetov $
#------------------------------------------------------------------------------
# Validation functions
# Used for validate camera attributes. Function names defined in the template.
#------------------------------------------------------------------------------
# Author: Serg Tsybulsky
# Edited by: Andrey Starostin
# QA by:
# Copyright: videoNEXT Network Solutions LLC 2006
#-----------------------------------------------------------------------------
*/
window.Validate = window.Validate || {};
Validate.UDP = Validate.UDP || {};

Validate.UDP.MEDIAFORMAT_NVC = function()
{
	var value = $(Validate.getObj("MEDIA_FORMAT", this)).val();
	if (value === 'mjpg'){
		Validate.hideAttribute("RC_MODE", this);
		Validate.hideAttribute("RC_TARGETBITRATE", this);
		Validate.hideAttribute("RC_MAXBITRATE", this);
		Validate.hideAttribute("QVALUE", this);

		Validate.showAttribute("FRAMERATE", this);
		Validate.showAttribute("ARCFRAMERATE", this);
		Validate.showAttribute("CAMCOMPRESSION", this);
		Validate.hideAttribute("GOP", this);
		Validate.showAttribute("PROTO", this);
	} else
	if (value === 'mpeg4' || value === 'h264'){
		Validate.showAttribute("RC_MODE", this);
		$(Validate.getObj("RC_MODE", this)).trigger('change');

		Validate.showAttribute("QVALUE", this);

		Validate.showAttribute("FRAMERATE", this);
		Validate.hideAttribute("ARCFRAMERATE", this);
		Validate.hideAttribute("CAMCOMPRESSION", this);
		Validate.showAttribute("GOP", this);
		Validate.showAttribute("PROTO", this);
	}
};

Validate.UDP.MEDIAFORMAT_NVE = function()
{
	var value = $(Validate.getObj("MEDIA_FORMAT", this)).val();
	if (value === 'mjpg'){
		Validate.hideAttribute("RC_MODE", this);
		Validate.hideAttribute("RC_TARGETBITRATE", this);
		Validate.hideAttribute("RC_MAXBITRATE", this);

		Validate.showAttribute("FRAMERATE", this);
		Validate.showAttribute("ARCFRAMERATE", this);
		Validate.hideAttribute("CAMCOMPRESSION", this);

		$(Validate.getObj("PROTO", this)).val('HTTP');
		
		Validate.hideAttribute("RTP_OVER_TCP", this);
		Validate.hideAttribute("RTP_TIME", this);
		Validate.hideAttribute("RTP_FORCE_MULTICAST", this);
		
	} else
	if (value === 'mpeg4' || value === 'h264'){
		Validate.showAttribute("RC_MODE", this);
		$(Validate.getObj("RC_MODE", this)).trigger('change');

		Validate.hideAttribute("FRAMERATE", this);
		Validate.hideAttribute("ARCFRAMERATE", this);
		Validate.hideAttribute("CAMCOMPRESSION", this);

		$(Validate.getObj("PROTO", this)).val('RTSP');
		
		Validate.showAttribute("RTP_OVER_TCP", this);
		Validate.showAttribute("RTP_TIME", this);
		Validate.showAttribute("RTP_FORCE_MULTICAST", this);
	}
};

Validate.UDP.RC_MODE = function()
{
	var value = $(Validate.getObj("RC_MODE", this)).val();
	if (value === 'cbr'){
		Validate.showAttribute("RC_TARGETBITRATE", this);
		Validate.hideAttribute("RC_MAXBITRATE", this);
		Validate.hideAttribute("QVALUE", this);
	} else
	if (value === 'vbr'){
		Validate.hideAttribute("RC_TARGETBITRATE", this);
		Validate.showAttribute("RC_MAXBITRATE", this);
		Validate.showAttribute("QVALUE", this);
	}
};
