/*
# $Id: validate.js 30461 2014-04-10 12:23:05Z astarostin $
#------------------------------------------------------------------------------
# Validation functions
# Used for validate camera attributes. Function names defined in the template.
#------------------------------------------------------------------------------
# Author: Serg Tsybulsky
# Edited by: Andrey Starostin
# QA by:
# Copyright: videoNEXT Network Solutions LLC 2006
#-----------------------------------------------------------------------------
*/
window.Validate = window.Validate || {};
Validate.SonySNC = Validate.SonySNC || {};

Validate.SonySNC.MEDIAFORMAT = function()
{
	Validate.hideAttribute("ARCFRAMERATE", this);

	var value = $(Validate.getObj("MEDIA_FORMAT", this)).val();
	if (value === 'mjpg'){
		Validate.hideAttribute("RC_MODE", this);
		Validate.hideAttribute("RC_TARGETBITRATE", this);
		Validate.showAttribute("CAMCOMPRESSION", this);
		Validate.showAttribute("ARCFRAMERATE", this);
	} else
	if (value === 'mpeg4' || value === 'h264'){
		Validate.showAttribute("RC_MODE", this);
		Validate.showAttribute("RC_TARGETBITRATE", this);
		Validate.hideAttribute("CAMCOMPRESSION", this);
	}

	var RC_TARGETBITRATE_LIST = {
		mjpg: [64,128,256,384,512,768,1024,1536,2048],
		mpeg4: [64,128,256,384,512,768,1024,1536,2048],
		h264: [64,128,256,384,512,768,1024,1536]
	};

	var self = this;

	var RC_TARGETBITRATE = $(Validate.getObj("RC_TARGETBITRATE", this)).val();
	$(Validate.getObj("RC_TARGETBITRATE", this)).find("option").remove();
	RC_TARGETBITRATE_LIST[value].forEach(function(key)
	{
		$(Validate.getObj("RC_TARGETBITRATE", self)).append('<option value="' + key + '">' + key + '</option>');
	});
	$(Validate.getObj("RC_TARGETBITRATE", this)).val(RC_TARGETBITRATE);

	var FRAMERATE_LIST = [1,2,3,4,5,6,8,10,15,20,25,30];
	var IMAGESIZE = $(Validate.getObj("IMAGESIZE", this)).val();
	if (value == "h264" && (IMAGESIZE == "704,1" || IMAGESIZE == "640,1"))
	{
		FRAMERATE_LIST = [1,2,3,4,5,6,8,10,15];
	}

	var FRAMERATE = $(Validate.getObj("FRAMERATE", this)).val();
	$(Validate.getObj("FRAMERATE", this)).find("option").remove();
	FRAMERATE_LIST.forEach(function(key)
	{
		$(Validate.getObj("FRAMERATE", self)).append('<option value="' + key + '">' + key + '</option>');
	});
	$(Validate.getObj("FRAMERATE", this)).val(FRAMERATE);
};

