/*
# $Id: validate.js 21985 2011-09-28 18:18:15Z jscott $
#------------------------------------------------------------------------------
# Validation functions
# Used for validate camera attributes. Function names defined in the template.
#------------------------------------------------------------------------------
# Author: Serg Tsybulsky
# Edited by: Andrey Starostin
# QA by:
# Copyright: videoNEXT Network Solutions LLC 2006
#-----------------------------------------------------------------------------
*/
window.Validate = window.Validate || {};
Validate.Siqura = Validate.Siqura || {};

Validate.Siqura.MEDIAFORMAT = function()
{
	var value = $(Validate.getObj("MEDIA_FORMAT", this)).val();
	if (value === 'mjpeg'){
		Validate.hideAttribute("RC_TARGETBITRATE", this);
		Validate.showAttribute("QUALITY", this);
	} else {
		Validate.showAttribute("RC_TARGETBITRATE", this);
		Validate.hideAttribute("QUALITY", this);
	}
};

Validate.Siqura.POSITIONCTL = function ()
{
	Validate.hideAttribute("PTZGROUP", this);
	Validate.hideAttribute("PTZ_TCP_IP", this);
	Validate.showAttribute("PTZID", this);
	Validate.showAttribute("PTZ_CAMERATYPE", this);
	Validate.showAttribute("PTZ_TCP_PORT", this);
	Validate.showAttribute("PTZ_TRANSPORT", this);
	Validate.showAttribute("PTZSPEED", this);
	Validate.showAttribute("PTZ_PRESET1TIMEOUT", this);

	Validate.hideAttribute("PTZ_CAMERATYPE_ICD001", this);

	var value = $(Validate.getObj("POSITIONCTL", this)).val();
	switch (value)
	{
		case 'none':
			// hide all ptz tab attributes
			Validate.hideAttribute("PTZID", this);
			Validate.hideAttribute("PTZ_CAMERATYPE", this);
			Validate.hideAttribute("PTZ_TCP_PORT", this);
			Validate.hideAttribute("PTZ_TRANSPORT", this);
			Validate.hideAttribute("PTZGROUP", this);
			Validate.hideAttribute("PTZSPEED", this);
			Validate.hideAttribute("PTZ_PRESET1TIMEOUT", this);
			Validate.hideAttribute("PTZ", this);
			Validate.hideAttribute("PTZ_HFOV", this);
			Validate.hideAttribute("PTZ_HFOV_MIN", this);
			Validate.hideAttribute("PTZ_HFOV_MAX", this);
			break;
		case 'pvpaeo':
			Validate.showAttribute("PTZ_TCP_IP", this);
			break;
		case 'Pelco':
			Validate.showAttribute("PTZ_TCP_IP", this);
			break;
	}
};
