/*
# $Id: validate.js 21343 2010-12-23 17:02:42Z starostin $
#------------------------------------------------------------------------------
# Validation functions
# Used for validate camera attributes. Function names defined in the template.
#------------------------------------------------------------------------------
# Author: Serg Tsybulsky
# Edited by: Andrey Starostin
# QA by:
# Copyright: videoNEXT Network Solutions LLC 2006
#-----------------------------------------------------------------------------
*/
window.Validate = window.Validate || {};
Validate.Phoenix = Validate.Phoenix || {};

Validate.Phoenix.MEDIAFORMAT = function()
{
	var value = $(Validate.getObj("MEDIA_FORMAT", this)).val();
	if (value === 'mjpg'){
		Validate.showAttribute("CAMCOMPRESSION", this);
		
		Validate.hideAttribute("RC_MODE", this);
		Validate.hideAttribute("RC_TARGETBITRATE", this);
		Validate.hideAttribute("RC_MAXBITRATE", this);
		Validate.hideAttribute("QUANTIZATION", this);

	} else
	if (value === 'mpeg4'){
		Validate.hideAttribute("CAMCOMPRESSION", this);
		
		Validate.showAttribute("QUANTIZATION", this);
		Validate.showAttribute("RC_MODE", this);
		$(Validate.getObj("RC_MODE", this)).trigger('change');
	} else
	if (value === 'h264'){
		Validate.showAttribute("CAMCOMPRESSION", this);
		Validate.showAttribute("RC_TARGETBITRATE", this);

		Validate.hideAttribute("RC_MODE", this);
		Validate.hideAttribute("RC_MAXBITRATE", this);
		Validate.hideAttribute("QUANTIZATION", this);
	}
};

Validate.Phoenix.RC_MODE = function()
{
	var value = $(Validate.getObj("RC_MODE", this)).val();
	if (value === 'VBR'){
		Validate.showAttribute("RC_TARGETBITRATE", this);
		Validate.showAttribute("RC_MAXBITRATE", this);
	} else
	if (value === 'CBR'){
		Validate.showAttribute("RC_TARGETBITRATE", this);
		Validate.hideAttribute("RC_MAXBITRATE", this);
	} else
	if (value === 'CONSTANT_Q'){
		Validate.hideAttribute("RC_TARGETBITRATE", this);
		Validate.hideAttribute("RC_MAXBITRATE", this);
	}
};
