/*
# $Id: validate.js 33127 2015-10-01 21:28:36Z astarostin $
#------------------------------------------------------------------------------
# Validation functions
# Used for validate camera attributes. Function names defined in the template.
#------------------------------------------------------------------------------
# Author: Serg Tsybulsky
# Edited by: Andrey Starostin
# QA by:
# Copyright: videoNEXT Network Solutions LLC 2006
#-----------------------------------------------------------------------------
*/
window.Validate = window.Validate || {};
Validate.PELCO = Validate.PELCO || {};

Validate.PELCO.MEDIAFORMAT = function()
{
	var value = $(Validate.getObj("MEDIA_FORMAT", this)).val();
	if (value === 'mjpg')
	{
		Validate.showAttribute("IMAGESIZE", this);
		Validate.hideAttribute("RC_TARGETBITRATE", this);

		Validate.hideAttribute("RC_MODE", this);
		Validate.hideAttribute("RC_MAXBITRATE", this);

		Validate.showAttribute("FRAMERATE", this);
		Validate.showAttribute("ARCFRAMERATE", this);
		Validate.showAttribute("CAMCOMPRESSION", this);
	} else
	if (value === 'mpeg4' || value === 'h264')
	{
		Validate.showAttribute("IMAGESIZE", this);
		Validate.showAttribute("RC_TARGETBITRATE", this);

		Validate.showAttribute("RC_MODE", this);
		$(Validate.getObj("RC_MODE", this)).trigger('change');

		Validate.hideAttribute("ARCFRAMERATE", this);
		Validate.hideAttribute("CAMCOMPRESSION", this);
	}
};

Validate.PELCO.MEDIAFORMAT_TXBN = function()
{
	var value = $(Validate.getObj("MEDIA_FORMAT", this)).val();
	if (value === 'mjpg')
	{
		Validate.showAttribute("IMAGESIZE", this);
		//Validate.hideAttribute("RC_TARGETBITRATE", this);
		Validate.hideAttribute("RC_GOP_DISTANCE", this);

		Validate.hideAttribute("RC_MODE", this);
		Validate.hideAttribute("RC_MAXBITRATE", this);

		Validate.showAttribute("FRAMERATE", this);
		Validate.showAttribute("ARCFRAMERATE", this);
		Validate.showAttribute("CAMCOMPRESSION", this);

		$(Validate.getObj("PROTO", this)).val("HTTP");
	} else
	if (value === 'mpeg4' || value === 'h264'){
		Validate.showAttribute("IMAGESIZE", this);
		Validate.showAttribute("RC_GOP_DISTANCE", this);
		Validate.showAttribute("RC_TARGETBITRATE", this);

		Validate.showAttribute("RC_MODE", this);
		$(Validate.getObj("RC_MODE", this)).trigger('change');

		Validate.hideAttribute("ARCFRAMERATE", this);
		Validate.hideAttribute("CAMCOMPRESSION", this);

		$(Validate.getObj("PROTO", this)).val("RTSP");
	}

	Validate.PELCO.correctMINMAX_TARGETBITRATE(this);
};

Validate.PELCO.MEDIAFORMAT_IXP = function()
{
	var value = $(Validate.getObj("MEDIA_FORMAT", this)).val();
	if (value === 'mjpg')
	{
		Validate.showAttribute("IMAGESIZE", this);
		//Validate.hideAttribute("RC_TARGETBITRATE", this);
		Validate.hideAttribute("RC_GOP_DISTANCE", this);

		Validate.hideAttribute("RC_MODE", this);
		Validate.hideAttribute("RC_MAXBITRATE", this);

		Validate.showAttribute("FRAMERATE", this);
		Validate.showAttribute("ARCFRAMERATE", this);
		Validate.showAttribute("CAMCOMPRESSION", this);

		$(Validate.getObj("PROTO", this)).val("RTSP");
	} else
	if (value === 'mpeg4' || value === 'h264')
	{
		Validate.showAttribute("IMAGESIZE", this);
		Validate.showAttribute("RC_GOP_DISTANCE", this);
		Validate.showAttribute("RC_TARGETBITRATE", this);

		Validate.showAttribute("RC_MODE", this);
		$(Validate.getObj("RC_MODE", this)).trigger('change');

		Validate.hideAttribute("ARCFRAMERATE", this);
		Validate.hideAttribute("CAMCOMPRESSION", this);

		$(Validate.getObj("PROTO", this)).val("RTSP");
	}

	Validate.PELCO.correctMINMAX_TARGETBITRATE(this);
};

Validate.PELCO.MEDIAFORMAT_IX = function()
{
	var value = $(Validate.getObj("MEDIA_FORMAT", this)).val();
	if (value === 'mjpg')
	{
		Validate.showAttribute("IMAGESIZE", this);
		Validate.hideAttribute("RC_TARGETBITRATE", this);

		Validate.hideAttribute("RC_MODE", this);
		Validate.hideAttribute("RC_MAXBITRATE", this);

		Validate.showAttribute("FRAMERATE", this);
		Validate.showAttribute("ARCFRAMERATE", this);
		Validate.showAttribute("CAMCOMPRESSION", this);

		$(Validate.getObj("PROTO", this)).val("HTTP");

		Validate.hideAttribute("RTP_OVER_TCP", this);
		Validate.hideAttribute("RTP_TIME", this);
		Validate.hideAttribute("RTP_FORCE_MULTICAST", this);
	} else
	if (value === 'mpeg4' || value === 'h264')
	{
		Validate.showAttribute("IMAGESIZE", this);
		Validate.showAttribute("RC_TARGETBITRATE", this);

		Validate.showAttribute("RC_MODE", this);
		$(Validate.getObj("RC_MODE", this)).trigger('change');

		Validate.hideAttribute("ARCFRAMERATE", this);
		Validate.hideAttribute("CAMCOMPRESSION", this);

		$(Validate.getObj("PROTO", this)).val("RTSP");

		Validate.showAttribute("RTP_OVER_TCP", this);
		Validate.showAttribute("RTP_TIME", this);
		Validate.showAttribute("RTP_FORCE_MULTICAST", this);
	}
};

Validate.PELCO.IMAGESIZE_IX = function()
{
	var value = $(Validate.getObj("IMAGESIZE", this)).val();
	var result = value.match(/(\d+)x(\d+)/);
	if (result != null)
	{
		var w = result[1];
		var h = result[2];
		if (h == 0)
		{
			return;
		}
		var coeff = w / h;

		var show = w < 1000 || coeff > 1.4;
		var curfps = $(Validate.getObj("FRAMERATE", this)).val();
		if (!show && parseInt(curfps) > 20)
		{
			$(Validate.getObj("FRAMERATE", this)).val(20);
		}

		var fpsval;
		$(Validate.getObj("FRAMERATE", this)).find("option").each(function () {
			fpsval = parseInt(this.text);
			if (fpsval > 20)
			{
				$(this).prop("disabled", !show);
			}
		});
	}
};

Validate.PELCO.IMAGESIZE_TXBN = function()
{
	Validate.PELCO.correctMINMAX_TARGETBITRATE(this);
};

Validate.PELCO.FRAMERATE_TXBN = function()
{
	Validate.PELCO.correctMINMAX_TARGETBITRATE(this);
};

Validate.PELCO.RC_TARGETBITRATE_TXBN = function()
{
	// to use JS code as validator for text field validate javascript must return res.data("error") on errors
	var value = $(Validate.getObj("RC_TARGETBITRATE", this)).val();
	var minvalue = parseInt($(Validate.getObj("RC_TARGETBITRATE_MIN", this)).val(), 10);
	var maxvalue = parseInt($(Validate.getObj("RC_TARGETBITRATE_MAX", this)).val(), 10);

	var regexp = new RegExp(/^\d+$/);
	if (!regexp.test(value)
	    || (value < minvalue || value > maxvalue)
	)
	{
		var error_str = Gettext.strargs(__("Target Bitrate must be integer from %1 to %2"), [minvalue, maxvalue]);
		$(this).data("error", error_str);
		return false;
	}
	$(this).removeData("error");
	return true;
};

Validate.PELCO.RC_GOP_DISTANCE_TXBN = function()
{
	// to use JS code as validator for text field validate javascript must return res.data("error") on errors
	var value = $(Validate.getObj("RC_GOP_DISTANCE", this)).val();
	var minvalue = parseInt($(Validate.getObj("RC_GOP_DISTANCE_MIN", this)).val(), 10);
	var maxvalue = parseInt($(Validate.getObj("RC_GOP_DISTANCE_MAX", this)).val(), 10);

	var regexp = new RegExp(/^\d+$/);
	if (!regexp.test(value)
	    || (value < minvalue || value > maxvalue)
	)
	{
		var error_str = Gettext.strargs(__("Iframe must be integer from %1 to %2"), ([minvalue, maxvalue]));
		$(this).data("error", error_str);
		return false;
	}
	$(this).removeData("error");
	return true;
};

Validate.PELCO.FRAMERATE = {
	"1920x1080":["1", "2",  "3",  "5",  "6"],
	"1280x960":["1", "2",  "3",  "5",  "6"],
	"1280x720":["1","2","3","5", "6",       "10" ],
	"800x448":[         "1",  "2",  "3",  "5",  "6",        "10",        "15" ],
	"800x608":[         "1",  "2",  "3",  "5",  "6",        "10",        "15" ],
	"640x512":[         "1",  "2",  "3",  "5",  "6",        "10",        "15",        "30" ],
	"640x480":[         "1",  "2",  "3",  "5",  "6",        "10",        "15",        "30" ],
	"640x352":[         "1",  "2",  "3",  "5",  "6",        "10",        "15",        "30" ],
	"480x368":[         "1",  "2",  "3",  "5",  "6",        "10",        "15",        "30" ],
	"480x272":[         "1",  "2",  "3",  "5",  "6",        "10",        "15",        "30" ],
	"320x256":[         "1",  "2",  "3",  "5",  "6",        "10",        "15",        "30" ],
	"320x240":[         "1",  "2",  "3",  "5",  "6",        "10",        "15",        "30" ],
	"320x176":[         "1",  "2",  "3",  "5",  "6",        "10",        "15",        "30" ],
	"352x240":[         "1",  "2",  "3",  "5",  "6",        "10",        "15",        "30" ],
	"704x480":[         "1",  "2",  "3",  "5",  "6",        "10",        "15",        "30" ]
};

Validate.PELCO.FRAMERATE_D5230 = {
	"1920x1080":["1", "2",  "3",  "5",  "6", "10", "15", "25", "30"],
	"1280x960":["1", "2",  "3",  "5",  "6", "10", "15", "25", "30"],
	"1280x720":["1", "2",  "3",  "5",  "6", "10", "15", "25", "30"],
	"800x448":["1", "2",  "3",  "5",  "6", "10", "15", "25", "30"],
	"800x608":["1", "2",  "3",  "5",  "6", "10", "15", "25", "30"],
	"640x512":["1", "2",  "3",  "5",  "6", "10", "15", "25", "30"],
	"640x480":["1", "2",  "3",  "5",  "6", "10", "15", "25", "30"],
	"640x352":["1", "2",  "3",  "5",  "6", "10", "15", "25", "30"],
	"480x368":["1", "2",  "3",  "5",  "6", "10", "15", "25", "30"],
	"480x272":["1", "2",  "3",  "5",  "6", "10", "15", "25", "30"],
	"384x288":["1", "2",  "3",  "5",  "6", "10", "15", "25", "30"],
	"320x256":["1", "2",  "3",  "5",  "6", "10", "15", "25", "30"],
	"320x240":["1", "2",  "3",  "5",  "6", "10", "15", "25", "30"],
	"320x176":["1", "2",  "3",  "5",  "6", "10", "15", "25", "30"],
	"352x240":["1", "2",  "3",  "5",  "6", "10", "15", "25", "30"],
	"704x480":["1", "2",  "3",  "5",  "6", "10", "15", "25", "30"]
};

Validate.PELCO.FRAMERATE_IXP = {
	"2048x1536":["1", "5",  "10", "15", "20"],
	"1920x1080":["1", "5", "10", "15", "20", "25", "30"],
	"1600x1200":["1", "5", "10", "15", "20", "25", "30"],
	"1280x960":["1", "5", "10", "15", "20", "25", "30"],
	"1280x720":["1", "5", "10", "15", "20", "25", "30"],
	"1024x576":["1", "5", "10", "15", "20", "25", "30"],
	"800x608":["1", "5", "10", "15", "20", "25", "30"],
	"800x600":["1", "5", "10", "15", "20", "25", "30"],
	"800x448":["1", "5", "10", "15", "20", "25", "30"],
	"704x480":["1", "5", "10", "15", "20", "25", "30"],
	"640x512":["1", "5", "10", "15", "20", "25", "30"],
	"640x480":["1", "5", "10", "15", "20", "25", "30"],
	"640x352":["1", "5", "10", "15", "20", "25", "30"],
	"480x368":["1", "5", "10", "15", "20", "25", "30"],
	"480x272":["1", "5", "10", "15", "20", "25", "30"],
	"352x240":["1", "5", "10", "15", "20", "25", "30"],
	"320x240":["1", "5", "10", "15", "20", "25", "30"],
	"320x256":["1", "5", "10", "15", "20", "25", "30"],
	"320x180":["1", "5", "10", "15", "20", "25", "30"],
	"320x176":["1", "5", "10", "15", "20", "25", "30"]
};

Validate.PELCO.IMAGESIZE_IM10LW10 = function ()
{
	var framerate = $(Validate.getObj("FRAMERATE", this));
	var arcframerate = $(Validate.getObj("ARCFRAMERATE", this));
	var valueIMAGESIZE = $(Validate.getObj("IMAGESIZE", this)).val();
	var valueFramerate = framerate.val();
	var valueArcFramerate = arcframerate.val();
	framerate.empty();
	arcframerate.empty();
	$.each(Validate.PELCO.FRAMERATE[valueIMAGESIZE], function (i, v) {
		var optionElement = document.createElement('option');
		var option = $(optionElement);
		option.val(v);
		option.html(v);
		framerate.append(option);
		arcframerate.append(option.clone(true));
	});
	framerate.find("option[value=" + valueFramerate + "]").attr('selected', 'selected');
	if (arcframerate.find("option[value=" + valueArcFramerate + "]").length > 0)
	{
		arcframerate.find("option[value=" + valueArcFramerate + "]").attr('selected', 'selected');
	}
};

Validate.PELCO.IMAGESIZE_D5230 = function()
{
	var framerate = $(Validate.getObj("FRAMERATE", this));
	var arcframerate = $(Validate.getObj("ARCFRAMERATE", this));
	var valueIMAGESIZE = $(Validate.getObj("IMAGESIZE", this)).val();
	var valueFramerate = framerate.val();
	var valueArcFramerate = arcframerate.val();
	framerate.empty();
	arcframerate.empty();
	var mediaFormat = $(Validate.getObj("MEDIA_FORMAT", this)).val();
	$.each(Validate.PELCO.FRAMERATE_D5230[valueIMAGESIZE], function (i, v) {
		if (mediaFormat == 'mjpg' && valueIMAGESIZE == "1920x1080"
		    && (v == "25" || v == "30")
		)
		{
			return;
		}
		var optionElement = document.createElement('option');
		var option = $(optionElement);
		option.val(v);
		option.html(v);
		framerate.append(option);
		arcframerate.append(option.clone(true));
	});
	framerate.find("option[value=" + valueFramerate + "]").attr('selected', 'selected');
	if (arcframerate.find("option[value=" + valueArcFramerate + "]").length > 0)
	{
		arcframerate.find("option[value=" + valueArcFramerate + "]").attr('selected', 'selected');
	}
};

Validate.PELCO.IMAGESIZE_IXP = function()
{
	var framerate = $(Validate.getObj("FRAMERATE", this));
	var arcframerate = $(Validate.getObj("ARCFRAMERATE", this));
	var valueIMAGESIZE = $(Validate.getObj("IMAGESIZE", this)).val();
	var valueFramerate = framerate.val();
	var valueArcFramerate = arcframerate.val();
	framerate.empty();
	arcframerate.empty();
	var mediaFormat = $(Validate.getObj("MEDIA_FORMAT", this)).val();
	$.each(Validate.PELCO.FRAMERATE_IXP[valueIMAGESIZE], function (i, v) {
		if ((mediaFormat == 'mjpg' && valueIMAGESIZE == "2048x1536" && v == "20")
		    || (
				mediaFormat == 'mjpg' && valueIMAGESIZE == "1920x1080"
		        && (v == "20" || v == "25" || v == "30")
		    )
		    || (mediaFormat == 'mjpg' && valueIMAGESIZE == "1600x1200"
		        && (v == "20" || v == "25" || v == "30")
		    )
		)
		{
			return;
		}
		var optionElement = document.createElement('option');
		var option = $(optionElement);
		option.val(v);
		option.html(v);
		framerate.append(option);
		arcframerate.append(option.clone(true));
	});
	framerate.find("option[value=" + valueFramerate + "]").attr('selected', 'selected');
	if (arcframerate.find("option[value=" + valueArcFramerate + "]").length > 0)
	{
		arcframerate.find("option[value=" + valueArcFramerate + "]").attr('selected', 'selected');
	}
};

// assoc array of max and min Bitrates and iFrames
Validate.PELCO.BITRATE = {
	mjpg: {
		1: //352x240:
			{
				1: {RC_TARGETBITRATE_MIN: 50, RC_TARGETBITRATE_MAX: 150},
				2: {RC_TARGETBITRATE_MIN: 50, RC_TARGETBITRATE_MAX: 300},
				3: {RC_TARGETBITRATE_MIN: 50, RC_TARGETBITRATE_MAX: 500},
				5: {RC_TARGETBITRATE_MIN: 56, RC_TARGETBITRATE_MAX: 800},
				6: {RC_TARGETBITRATE_MIN: 68, RC_TARGETBITRATE_MAX: 1000},
				10: {RC_TARGETBITRATE_MIN: 113, RC_TARGETBITRATE_MAX: 1650},
				15: {RC_TARGETBITRATE_MIN: 169, RC_TARGETBITRATE_MAX: 2500},
				25: {RC_TARGETBITRATE_MIN: 282, RC_TARGETBITRATE_MAX: 3500},
				30: {RC_TARGETBITRATE_MIN: 338, RC_TARGETBITRATE_MAX: 5050}
			},
		3: //704x480:
			{
				1: {RC_TARGETBITRATE_MIN: 50, RC_TARGETBITRATE_MAX: 650},
				2: {RC_TARGETBITRATE_MIN: 90, RC_TARGETBITRATE_MAX: 1350},
				3: {RC_TARGETBITRATE_MIN: 135, RC_TARGETBITRATE_MAX: 2000},
				5: {RC_TARGETBITRATE_MIN: 225, RC_TARGETBITRATE_MAX: 3350},
				6: {RC_TARGETBITRATE_MIN: 270, RC_TARGETBITRATE_MAX: 4050},
				10: {RC_TARGETBITRATE_MIN: 451, RC_TARGETBITRATE_MAX: 6750},
				15: {RC_TARGETBITRATE_MIN: 676, RC_TARGETBITRATE_MAX: 10100},
				25: {RC_TARGETBITRATE_MIN: 1126, RC_TARGETBITRATE_MAX: 11100},
				30: {RC_TARGETBITRATE_MIN: 1352, RC_TARGETBITRATE_MAX: 12000}
			}
	},
	mpeg4: {
		1: //352x240:
			{
				1: {RC_TARGETBITRATE_MIN: 50, RC_TARGETBITRATE_MAX: 150, RC_GOP_DISTANCE_MIN: 4, RC_GOP_DISTANCE_MAX: 8},
				2: {RC_TARGETBITRATE_MIN: 50, RC_TARGETBITRATE_MAX: 300, RC_GOP_DISTANCE_MIN: 4, RC_GOP_DISTANCE_MAX: 12},
				3: {RC_TARGETBITRATE_MIN: 50, RC_TARGETBITRATE_MAX: 500, RC_GOP_DISTANCE_MIN: 4, RC_GOP_DISTANCE_MAX: 16},
				5: {RC_TARGETBITRATE_MIN: 50, RC_TARGETBITRATE_MAX: 800, RC_GOP_DISTANCE_MIN: 4, RC_GOP_DISTANCE_MAX: 28},
				6: {RC_TARGETBITRATE_MIN: 50, RC_TARGETBITRATE_MAX: 1000, RC_GOP_DISTANCE_MIN: 4, RC_GOP_DISTANCE_MAX: 32},
				10: {RC_TARGETBITRATE_MIN: 50, RC_TARGETBITRATE_MAX: 1650,RC_GOP_DISTANCE_MIN:  4, RC_GOP_DISTANCE_MAX: 52},
				15: {RC_TARGETBITRATE_MIN: 50, RC_TARGETBITRATE_MAX: 2500, RC_GOP_DISTANCE_MIN: 4, RC_GOP_DISTANCE_MAX: 76},
				25: {RC_TARGETBITRATE_MIN: 50, RC_TARGETBITRATE_MAX: 2700, RC_GOP_DISTANCE_MIN: 4, RC_GOP_DISTANCE_MAX: 126},
				30: {RC_TARGETBITRATE_MIN: 81, RC_TARGETBITRATE_MAX: 3000, RC_GOP_DISTANCE_MIN: 4,RC_GOP_DISTANCE_MAX: 152}
			},
		3: //704x480:
			{
				1: {RC_TARGETBITRATE_MIN: 50, RC_TARGETBITRATE_MAX: 650, RC_GOP_DISTANCE_MIN: 4, RC_GOP_DISTANCE_MAX: 8},
				2: {RC_TARGETBITRATE_MIN: 50, RC_TARGETBITRATE_MAX: 1350, RC_GOP_DISTANCE_MIN: 4, RC_GOP_DISTANCE_MAX: 12},
				3: {RC_TARGETBITRATE_MIN: 50, RC_TARGETBITRATE_MAX: 2000, RC_GOP_DISTANCE_MIN: 4, RC_GOP_DISTANCE_MAX: 16},
				5: {RC_TARGETBITRATE_MIN: 54, RC_TARGETBITRATE_MAX: 3000, RC_GOP_DISTANCE_MIN: 4, RC_GOP_DISTANCE_MAX: 28},
				6: {RC_TARGETBITRATE_MIN: 65, RC_TARGETBITRATE_MAX: 3000, RC_GOP_DISTANCE_MIN: 4, RC_GOP_DISTANCE_MAX: 32},
				10: {RC_TARGETBITRATE_MIN: 108, RC_TARGETBITRATE_MAX: 3000, RC_GOP_DISTANCE_MIN: 4, RC_GOP_DISTANCE_MAX: 52},
				15: {RC_TARGETBITRATE_MIN: 162, RC_TARGETBITRATE_MAX: 3000, RC_GOP_DISTANCE_MIN: 4, RC_GOP_DISTANCE_MAX: 76},
				25: {RC_TARGETBITRATE_MIN: 270, RC_TARGETBITRATE_MAX: 3000, RC_GOP_DISTANCE_MIN: 4, RC_GOP_DISTANCE_MAX: 126},
				30: {RC_TARGETBITRATE_MIN: 324, RC_TARGETBITRATE_MAX: 3000, RC_GOP_DISTANCE_MIN: 4, RC_GOP_DISTANCE_MAX: 152}
		}
	}
};

// for internal purposes only, not for event handling
Validate.PELCO.correctMINMAX_TARGETBITRATE = function(thisObject)
{
	var bitrate = Validate.PELCO.BITRATE;

	var valueMEDIA_FORMAT = $(Validate.getObj("MEDIA_FORMAT", thisObject)).val() || null;
	var valueIMAGESIZE = $(Validate.getObj("IMAGESIZE", thisObject)).val();
	var valueFRAMERATE = $(Validate.getObj("FRAMERATE", thisObject)).val();
	var valueRC_TARGETBITRATE = $(Validate.getObj("RC_TARGETBITRATE", thisObject)).val();
	var valueRC_GOP_DISTANCE = $(Validate.getObj("RC_GOP_DISTANCE", thisObject)).val();

	if (valueMEDIA_FORMAT && valueIMAGESIZE && valueFRAMERATE){
		if (valueMEDIA_FORMAT == 'h264')
		{
			valueMEDIA_FORMAT = 'mpeg4';
		}

		var valueRC_TARGETBITRATE_MIN = $(Validate.getObj("RC_TARGETBITRATE_MIN", thisObject)).val();
		var valueRC_TARGETBITRATE_MAX = $(Validate.getObj("RC_TARGETBITRATE_MAX", thisObject)).val();

		var valueRC_GOP_DISTANCE_MIN = $(Validate.getObj("RC_GOP_DISTANCE_MIN", thisObject)).val();
		var valueRC_GOP_DISTANCE_MAX = $(Validate.getObj("RC_GOP_DISTANCE_MAX", thisObject)).val();

		if ( bitrate[valueMEDIA_FORMAT][valueIMAGESIZE]!==undefined &&
			((bitrate[valueMEDIA_FORMAT][valueIMAGESIZE][valueFRAMERATE].RC_TARGETBITRATE_MIN != valueRC_TARGETBITRATE_MIN)
			||
			(bitrate[valueMEDIA_FORMAT][valueIMAGESIZE][valueFRAMERATE].RC_TARGETBITRATE_MAX != valueRC_TARGETBITRATE_MAX))
		)
		{
			$(Validate.getObj("RC_TARGETBITRATE_MIN", thisObject)).val(bitrate[valueMEDIA_FORMAT][valueIMAGESIZE][valueFRAMERATE].RC_TARGETBITRATE_MIN);
			$(Validate.getObj("RC_TARGETBITRATE_MAX", thisObject)).val(bitrate[valueMEDIA_FORMAT][valueIMAGESIZE][valueFRAMERATE].RC_TARGETBITRATE_MAX);
			var newvalueRC_TARGETBITRATE = parseInt(bitrate[valueMEDIA_FORMAT][valueIMAGESIZE][valueFRAMERATE].RC_TARGETBITRATE_MIN, 10) + parseInt((bitrate[valueMEDIA_FORMAT][valueIMAGESIZE][valueFRAMERATE].RC_TARGETBITRATE_MAX - bitrate[valueMEDIA_FORMAT][valueIMAGESIZE][valueFRAMERATE].RC_TARGETBITRATE_MIN) / 7.5, 10);
			$(Validate.getObj("RC_TARGETBITRATE", thisObject)).val(newvalueRC_TARGETBITRATE);
		}

		if(valueMEDIA_FORMAT == 'mpeg4'){
			if( bitrate[valueMEDIA_FORMAT][valueIMAGESIZE]!==undefined &&
				((bitrate[valueMEDIA_FORMAT][valueIMAGESIZE][valueFRAMERATE].RC_GOP_DISTANCE_MIN != valueRC_GOP_DISTANCE_MIN)
				||
				(bitrate[valueMEDIA_FORMAT][valueIMAGESIZE][valueFRAMERATE].RC_GOP_DISTANCE_MAX != valueRC_GOP_DISTANCE_MAX))
			)
			{
				$(Validate.getObj("RC_GOP_DISTANCE_MIN", thisObject)).val(bitrate[valueMEDIA_FORMAT][valueIMAGESIZE][valueFRAMERATE].RC_GOP_DISTANCE_MIN);
				$(Validate.getObj("RC_GOP_DISTANCE_MAX", thisObject)).val(bitrate[valueMEDIA_FORMAT][valueIMAGESIZE][valueFRAMERATE].RC_GOP_DISTANCE_MAX);

				var newvalueRC_GOP_DISTANCE = Math.max(bitrate[valueMEDIA_FORMAT][valueIMAGESIZE][valueFRAMERATE].RC_GOP_DISTANCE_MIN, parseInt(bitrate[valueMEDIA_FORMAT][valueIMAGESIZE][valueFRAMERATE].RC_GOP_DISTANCE_MAX / 5, 10));
				$(Validate.getObj("RC_GOP_DISTANCE", thisObject)).val(newvalueRC_GOP_DISTANCE);
			}
		}
	}
};
