/**
 * @version $Id: validate.js 28935 2013-06-14 20:13:31Z astarostin $
 * ------------------------------------------------------------------------------
 * Validation functions
 * Used for validate camera attributes. Function names defined in the template.
 * ------------------------------------------------------------------------------
 * @author Andrey Starostin
 * @QA
 * @copyright videoNEXT Network Solutions, Inc, 2013
 * ------------------------------------------------------------------------------
 */
(function(window){
	"use strict";

	window.Validate = window.Validate || {};
	Validate.ONVIF = Validate.ONVIF || {};

	Validate.ONVIF.ONVIF_PROFILE = function()
	{
		var ONVIF_PROFILES_value = $(Validate.getObj("ONVIF_PROFILES", this)).val();
		var ONVIF_PROFILES = JSON.parse(ONVIF_PROFILES_value);

		var CAMERA = $(Validate.getObj("CAMERA", this)).val();
		var ONVIF_PROFILE = $(Validate.getObj("ONVIF_PROFILE", this)).val();		
		
		if (ONVIF_PROFILES[CAMERA][ONVIF_PROFILE])
		{
			var IMAGESIZE = ONVIF_PROFILES[CAMERA][ONVIF_PROFILE].IMAGESIZE;
			var MEDIA_FORMAT = ONVIF_PROFILES[CAMERA][ONVIF_PROFILE].MEDIA_FORMAT;
			
			$(Validate.getObj("IMAGESIZE", this)).val(IMAGESIZE);
			$(Validate.getObj("MEDIA_FORMAT", this)).val(MEDIA_FORMAT);		
		}
	};
	
	Validate.ONVIF.CAMERA = function()
	{
		var ONVIF_PROFILES_value = $(Validate.getObj("ONVIF_PROFILES", this)).val();
		var ONVIF_PROFILES = JSON.parse(ONVIF_PROFILES_value);
		
		var CAMERA = $(Validate.getObj("CAMERA", this)).val();		
		var ONVIF_PROFILE = Object.keys(ONVIF_PROFILES[CAMERA])[0];
		
		var IMAGESIZE = ONVIF_PROFILES[CAMERA][ONVIF_PROFILE].IMAGESIZE;
		var MEDIA_FORMAT = ONVIF_PROFILES[CAMERA][ONVIF_PROFILE].MEDIA_FORMAT;

		$(Validate.getObj("ONVIF_PROFILE", this)).val(ONVIF_PROFILE);
		$(Validate.getObj("IMAGESIZE", this)).val(IMAGESIZE);
		$(Validate.getObj("MEDIA_FORMAT", this)).val(MEDIA_FORMAT);
	};	

})(window);
