/**
 * @version $Id: validate.js 28549 2013-05-07 20:08:36Z teetov $
 * ------------------------------------------------------------------------------
 * Validation functions
 * Used for validate camera attributes. Function names defined in the template.
 * ------------------------------------------------------------------------------
 * @author Andrey Starostin
 * @QA
 * @copyright videoNEXT Network Solutions LLC 2010
 * ------------------------------------------------------------------------------
 */

window.Validate = window.Validate || {};
Validate.Moxa = Validate.Moxa || {};

Validate.Moxa.RC_MODE = function()
{
	var value = $(Validate.getObj("RC_MODE", this)).val();
	if (value === '1'){
		Validate.hideAttribute("RC_QUAL", this);
		Validate.showAttribute("RC_BITRATE", this);
	}else
	if (value === '2'){
		Validate.showAttribute("RC_QUAL", this);
		Validate.hideAttribute("RC_BITRATE", this);
	}
};

Validate.Moxa.POSITIONCTL_EXTPTZ = function ()
{
	Validate.hideAttribute("PTZGROUP", this);
	Validate.hideAttribute("PTZ_CAMERATYPE_ALL", this);
	Validate.hideAttribute("PTZ_TCP_PORT", this);
	Validate.hideAttribute("PTZ_TRANSPORT", this);
	Validate.hideAttribute("PTZGROUP", this);
	Validate.hideAttribute("PTZSPEED", this);
	Validate.hideAttribute("PTZ_PRESET1TIMEOUT", this);
	Validate.hideAttribute("PTZ", this);
	Validate.hideAttribute("PTZ_INVERT", this);

	var value = $(Validate.getObj("POSITIONCTL", this)).val();
	switch (value)
	{
		case 'none':
			Validate.hideAttribute("PTZID", this);
			Validate.hideAttribute("PTZ_CAMERATYPE_ALL", this);
			Validate.hideAttribute("PTZ_TCP_PORT", this);
			Validate.hideAttribute("PTZ_TRANSPORT", this);
			Validate.hideAttribute("PTZGROUP", this);
			Validate.hideAttribute("PTZ_PRESET1TIMEOUT", this);
			Validate.hideAttribute("PTZ", this);
			Validate.hideAttribute("PTZ_HFOV", this);
			Validate.hideAttribute("PTZ_HFOV_MIN", this);
			Validate.hideAttribute("PTZ_HFOV_MAX", this);
			break;
		case 'ptcr20bae':
			$(Validate.getObj("PTZ_CAMERATYPE_ALL", this)).val('ptcr20bae');
			$(Validate.getObj("PTZ_CAMERATYPE_ALL", this)).trigger("change");
			break;
		case 'ptzr20flir':
			$(Validate.getObj("PTZ_CAMERATYPE_ALL", this)).val('ptcr20flir');
			$(Validate.getObj("PTZ_CAMERATYPE_ALL", this)).trigger("change");
			break;
		case 'flir_35x_140':
			$(Validate.getObj("PTZ_CAMERATYPE_ALL", this)).val('flir');
			$(Validate.getObj("PTZ_CAMERATYPE_ALL", this)).trigger("change");
			break;
		case 'icd001':
			Validate.showAttribute("PTZGROUP", this);
			Validate.hideAttribute("PTZ_CAMERATYPE_ALL", this);
			Validate.showAttribute("PTZ_CAMERATYPE_ICD001", this);
			$(Validate.getObj("PTZ_CAMERATYPE_ICD001", this)).trigger("change");
			break;
		case 'Pelco':
			Validate.showAttribute("PTZ_INVERT", this);
			break;
		default:
			$(Validate.getObj("PTZ_CAMERATYPE_ALL", this)).trigger("change");
	}
};

Validate.Moxa.PTZ_CAMERATYPE_ICD001 = function()
{
	if ($(Validate.getObj("POSITIONCTL", this)).val() == 'icd001'){
		var PTZ_CAMERATYPE_ICD001value = $(Validate.getObj("PTZ_CAMERATYPE_ICD001", this)).val();
		$(Validate.getObj("PTZCAMERATYPE", this)).val(PTZ_CAMERATYPE_ICD001value);
	}
};

Validate.Moxa.PTZ_CAMERATYPE_ALL = function()
{
	var PTZ_CAMERATYPE_ALLvalue = $(Validate.getObj("PTZ_CAMERATYPE_ALL", this)).val();
	$(Validate.getObj("PTZ_CAMERATYPE", this)).val(PTZ_CAMERATYPE_ALLvalue);
};

Validate.Moxa.MEDIAFORMAT = function()
{
	var value = $(Validate.getObj("MEDIA_FORMAT",this)).val();
	if (value === 'mjpg'){
		Validate.hideAttribute("RC_MODE", this);

		Validate.showAttribute("ARCFRAMERATE", this);
		Validate.showAttribute("HTTP_PORT", this);
		Validate.hideAttribute("RTSP_PORT", this);

		$(Validate.getObj("PROTO",this)).val('HTTP');
		Validate.hideAttribute("RTP_OVER_TCP", this);
		Validate.hideAttribute("RTP_TIME", this);
		Validate.hideAttribute("RTP_FORCE_MULTICAST", this);
		
	} else
	if (value === 'mp4v' || value === 'h264'){
		Validate.showAttribute("RC_MODE", this);
		Validate.hideAttribute("HTTP_PORT", this);
		Validate.showAttribute("RTSP_PORT", this);
		$(Validate.getObj("RC_MODE", this)).trigger('change');

		Validate.hideAttribute("ARCFRAMERATE",this);
		Validate.hideAttribute("CAMCOMPRESSION", this);

		$(Validate.getObj("PROTO", this)).val('RTSP');
		Validate.showAttribute("RTP_OVER_TCP", this);
		Validate.showAttribute("RTP_TIME", this);
		Validate.showAttribute("RTP_FORCE_MULTICAST", this);
		
	}
};
