/*
# $Id: validate.js 33118 2015-09-29 12:57:17Z atsybulnik $
#------------------------------------------------------------------------------
# Validation functions
# Used for validate camera attributes. Function names defined in the template.
#------------------------------------------------------------------------------
# Author: Serg Tsybulsky
# Edited by: Andrey Starostin
# QA by:
# Copyright: videoNEXT Network Solutions LLC 2006
#-----------------------------------------------------------------------------
*/
window.Validate = window.Validate || {};
Validate.Hik = Validate.Hik || {};

Validate.Hik.MEDIAFORMAT = function()
{
	var format = $(Validate.getObj("MEDIA_FORMAT", this)).val();
	var format_list = $(Validate.getObj("MEDIA_FORMAT_LIST", this)).val();
	if (format === format_list) { // Single format
		$(Validate.getObj("MEDIA_FORMAT", this)).prop("disabled", true);
	} else {
		$(Validate.getObj("MEDIA_FORMAT", this)).prop("disabled", false);
	}

	var audio_list = $(Validate.getObj("AUDIO_LIST", this)).val();
	if (audio_list === "off:OFF") {
		$(Validate.getObj("AUDIO_HAS_TWO_WAY", this)).prop("disabled", true);
	} else {
		$(Validate.getObj("AUDIO_HAS_TWO_WAY", this)).prop("disabled", false);
	}

	var ptz_list = $(Validate.getObj("POSITIONCTL_LIST", this)).val();
	if (ptz_list === "none") {
		$(Validate.getObj("POSITIONCTL", this)).prop("disabled", true);
	} else {
		$(Validate.getObj("POSITIONCTL", this)).prop("disabled", false);
	}

	var rtp_list = $(Validate.getObj("RTP_OVER_TCP_LIST", this)).val();
	if (rtp_list && rtp_list.indexOf(",") == -1) {
		$(Validate.getObj("RTP_OVER_TCP", this)).prop("disabled", true);
	} else {
		$(Validate.getObj("RTP_OVER_TCP", this)).prop("disabled", false);
	}

	var ptzid_list = $(Validate.getObj("PTZID_LIST", this)).val();
	if (ptzid_list && ptzid_list.indexOf(",") == -1) {
		$(Validate.getObj("PTZID", this)).prop("disabled", true);
	} else {
		$(Validate.getObj("PTZID", this)).prop("disabled", false);
	}

	
	if (format === 'h264' || format === 'mpeg4'){
		Validate.showAttribute("AUDIO_HAS_TWO_WAY", this);
		$(Validate.getObj("AUDIO_HAS_TWO_WAY", this)).trigger('change');

		$(Validate.getObj("RC_MODE", this)).prop("disabled", false);
		$(Validate.getObj("RC_MODE", this)).trigger('change');
	} else
	if (value === 'mjpg'){

		Validate.hideAttribute("AUDIO_HAS_TWO_WAY", this);
		$(Validate.getObj("AUDIO", this)).val('off');

		$(Validate.getObj("RC_MODE", this)).trigger('change');
		$(Validate.getObj("RC_MODE", this)).prop("disabled", true);
	}
};

Validate.Hik.RC_MODE = function()
{
	var value = $(Validate.getObj("RC_MODE", this)).val();
	if (value === 'cbr'){
		Validate.hideAttribute("CAMCOMPRESSION", this);
	} else
	if (value === 'vbr'){
		Validate.showAttribute("CAMCOMPRESSION", this);
	}
};

Validate.Hik.IMAGESIZE = function()
{
	var value = $(Validate.getObj("IMAGESIZE", this)).val();
	var fr_list = $(Validate.getObj("FRAMERATE_LIST", this)).val();
	if (!fr_list) return;
	
	var frList = new Array;
	$.each(fr_list.split(/,(?=\d+x\d+:)/), function(i, val) {
		if (val.indexOf(value) < 0) return;
		var i1 = val.indexOf(":");
		if (i1 < 0) return;
		var fr = val.substring(i1+1);
		fr = fr.replace(/\\/g,"");
		frList = fr.split(",");
	});
	if (frList.length > 0) {
		var htmlFrameRate = "";
		$.each(frList, function(k, v) {
			htmlFrameRate += "<option value=\"" + k + "\">" + v + "</option>";
		});
		Validate.getObj("FRAMERATE", this).html(htmlFrameRate);
	}
};
