/*
# $Id: validate.js 28042 2013-03-01 16:19:21Z astarostin $
#------------------------------------------------------------------------------
# Validation functions
# Used for validate camera attributes. Function names defined in the template.
#------------------------------------------------------------------------------
# Author: Serg Tsybulsky
# Edited by: Andrey Starostin
# QA by:
# Copyright: videoNEXT Network Solutions LLC 2006
#-----------------------------------------------------------------------------
*/
window.Validate = window.Validate || {};
Validate.DanteSecurity = Validate.DanteSecurity || {};

Validate.DanteSecurity.MEDIAFORMAT = function()
{
	var value = $(Validate.getObj("MEDIA_FORMAT", this)).val();
	if (value === 'mjpg'){
		Validate.hideAttribute("RC_MODE", this);
		Validate.hideAttribute("RC_TARGETBITRATE", this);
		Validate.hideAttribute("RC_MAXBITRATE", this);
		Validate.hideAttribute("QVALUE", this);

		Validate.showAttribute("FRAMERATE", this);
		Validate.showAttribute("ARCFRAMERATE", this);
		Validate.showAttribute("CAMCOMPRESSION", this);
		Validate.hideAttribute("GOP", this);
		Validate.showAttribute("PROTO", this);
	} else
	if (value === 'mpeg4' || value === 'h264'){
		Validate.showAttribute("RC_MODE", this);
		$(Validate.getObj("RC_MODE", this)).trigger('change');

		Validate.showAttribute("QVALUE", this);

		Validate.showAttribute("FRAMERATE", this);
		Validate.hideAttribute("ARCFRAMERATE", this);
		Validate.hideAttribute("CAMCOMPRESSION", this);
		Validate.showAttribute("GOP", this);
		Validate.showAttribute("PROTO", this);
	}
};

Validate.DanteSecurity.RC_MODE = function()
{
	var value = $(Validate.getObj("RC_MODE", this)).val();
	if (value === 'cbr'){
		Validate.showAttribute("RC_TARGETBITRATE", this);
		Validate.hideAttribute("RC_MAXBITRATE", this);
		Validate.hideAttribute("QVALUE", this);
	} else
	if (value === 'vbr'){
		Validate.hideAttribute("RC_TARGETBITRATE", this);
		Validate.showAttribute("RC_MAXBITRATE", this);
		Validate.showAttribute("QVALUE", this);
	}
};
