/*
# $Id: validate.js 33162 2015-10-14 22:31:06Z astarostin $
#------------------------------------------------------------------------------
# Validation functions
# Used for validate camera attributes. Function names defined in the template.
#------------------------------------------------------------------------------
# Author: Serg Tsybulsky
# Edited by: Andrey Starostin
# QA by:
# Copyright: videoNEXT Network Solutions LLC 2006
#-----------------------------------------------------------------------------
*/
window.Validate = window.Validate || {};
Validate.CISCO = Validate.CISCO || {};

Validate.CISCO.IMAGESIZE_MJPG = function()
{
	if (Validate.isAttributeVisible("IMAGESIZE_MJPG", this)){
		var IMAGESIZEvalue = $(Validate.getObj("IMAGESIZE_MJPG", this)).val();
		$(Validate.getObj("IMAGESIZE", this)).val(IMAGESIZEvalue);
	}
};

Validate.CISCO.IMAGESIZE_H264 = function()
{
	if (Validate.isAttributeVisible("IMAGESIZE_H264", this)){
		var IMAGESIZEvalue = $(Validate.getObj("IMAGESIZE_H264", this)).val();
		$(Validate.getObj("IMAGESIZE", this)).val(IMAGESIZEvalue);
	}
};

Validate.CISCO.FRAMERATE_MPEG4 = function()
{
	if (Validate.isAttributeVisible("FRAMERATE_MPEG4", this)){
		var FRAMERATEvalue = $(Validate.getObj("FRAMERATE_MPEG4", this)).val();
		$(Validate.getObj("FRAMERATE", this)).val(FRAMERATEvalue);
	}
};

Validate.CISCO.FRAMERATE_MJPG = function()
{
	if (Validate.isAttributeVisible("FRAMERATE_MJPG", this)){
		var FRAMERATEvalue = $(Validate.getObj("FRAMERATE_MJPG", this)).val();
		$(Validate.getObj("FRAMERATE", this)).val(FRAMERATEvalue);
	}
};

Validate.CISCO.MEDIAFORMAT = function()
{
	var value = $(Validate.getObj("MEDIA_FORMAT", this)).val();
	if (value === 'h264'){

		Validate.showAttribute("AUDIO_HAS_TWO_WAY", this);
		$(Validate.getObj("AUDIO_HAS_TWO_WAY", this)).trigger('change');

		Validate.hideAttribute("IMAGESIZE_MJPG", this);
		Validate.showAttribute("IMAGESIZE_H264", this);

		$(Validate.getObj("RC_MODE", this)).prop("disabled", false);
		$(Validate.getObj("RC_MODE", this)).trigger('change');
	} else
	if (value === 'mjpg'){

		Validate.hideAttribute("AUDIO_HAS_TWO_WAY", this);
		$(Validate.getObj("AUDIO", this)).val('off');

		Validate.showAttribute("IMAGESIZE_MJPG", this);
		Validate.hideAttribute("IMAGESIZE_H264", this);

		$(Validate.getObj("RC_MODE", this)).val('vbr');
		$(Validate.getObj("RC_MODE", this)).trigger('change');
		$(Validate.getObj("RC_MODE", this)).prop("disabled", true);
	}
};

Validate.CISCO.MEDIAFORMAT_IPC2500 = function()
{
	var value = $(Validate.getObj("MEDIA_FORMAT", this)).val();
	if (value === 'mjpg'){

		Validate.hideAttribute("AUDIO_HAS_TWO_WAY", this);
		$(Validate.getObj("AUDIO", this)).val('off');

		Validate.hideAttribute("IMAGESIZE_MJPG", this);
		Validate.hideAttribute("IMAGESIZE_H264", this);

		Validate.hideAttribute("FRAMERATE_MPEG4", this);
		Validate.showAttribute("FRAMERATE_MJPG", this);
		$(Validate.getObj("FRAMERATE_MJPG", this)).trigger('change');

		Validate.showAttribute("CAMCOMPRESSION", this);
		Validate.hideAttribute("RC_TARGETBITRATE", this);
		Validate.hideAttribute("RC_MODE", this);

	} else
	if (value === 'mpeg4' || value === 'h264'){
		Validate.showAttribute("AUDIO_HAS_TWO_WAY", this);
		$(Validate.getObj("AUDIO_HAS_TWO_WAY", this)).trigger('change');

		Validate.hideAttribute("IMAGESIZE_MJPG", this);
		Validate.hideAttribute("IMAGESIZE_H264", this);

		Validate.hideAttribute("FRAMERATE_MJPG", this);
		Validate.showAttribute("FRAMERATE_MPEG4", this);
		$(Validate.getObj("FRAMERATE_MPEG4", this)).trigger('change');

		Validate.showAttribute("RC_MODE", this);
		$(Validate.getObj("RC_MODE", this)).trigger('change');
	}
};

Validate.CISCO.MEDIAFORMAT_IPC6020 = function()
{
	var value = $(Validate.getObj("MEDIA_FORMAT", this)).val();
	if (value === 'h264'){
		$(Validate.getObj("RC_MODE", this)).prop("disabled", false);
		$(Validate.getObj("RC_MODE", this)).trigger('change');
	} else
	if (value === 'mjpg'){
		$(Validate.getObj("RC_MODE", this)).val('vbr');
		$(Validate.getObj("RC_MODE", this)).trigger('change');
		$(Validate.getObj("RC_MODE", this)).prop("disabled", true);
	}
};

Validate.CISCO.RC_MODE = function()
{
	var value = $(Validate.getObj("RC_MODE", this)).val();
	if (value === 'cbr'){
		Validate.showAttribute("RC_TARGETBITRATE", this);
		Validate.hideAttribute("CAMCOMPRESSION", this);
	}else
	if (value === 'vbr'){
		Validate.showAttribute("CAMCOMPRESSION", this);
		Validate.hideAttribute("RC_TARGETBITRATE", this);
	}
};

Validate.CISCO.CAMERA4300 = function()
{
	var value = $(Validate.getObj("CAMERA", this)).val();
	if (value === '2'){
		$(Validate.getObj("MEDIA_FORMAT", this)).val('mjpg');
		$(Validate.getObj("MEDIA_FORMAT", this)).trigger('change');
		$(Validate.getObj("IMAGESIZE_MJPG", this)).val('CIF');
		$(Validate.getObj("IMAGESIZE_MJPG", this)).trigger('change');
		$(Validate.getObj("IMAGESIZE_MJPG", this)).prop("disabled", true);
	}else
	if (value === '1'){
		$(Validate.getObj("MEDIA_FORMAT", this)).val('h264');
		$(Validate.getObj("MEDIA_FORMAT", this)).trigger('change');
		//$(Validate.getObj("IMAGESIZE_MJPG", this)).prop("disabled", false);
	}
};
