window.Validate = window.Validate || {};
Validate.Bosch = Validate.Bosch || {};

Validate.Bosch.POSITIONCTL = function ()
{
	Validate.hideAttribute("PTZGROUP", this);
	Validate.hideAttribute("PTZ_TCP_IP", this);
	Validate.showAttribute("PTZID", this);
	Validate.showAttribute("PTZ_CAMERATYPE", this);
	Validate.showAttribute("PTZ_TCP_PORT", this);
	Validate.showAttribute("PTZ_TRANSPORT", this);
	Validate.showAttribute("PTZSPEED", this);
	Validate.showAttribute("PTZ_PRESET1TIMEOUT", this);

	Validate.hideAttribute("PTZ_CAMERATYPE_ICD001", this);

	var value = $(Validate.getObj("POSITIONCTL", this)).val();
	switch (value)
	{
		case 'none':
			// hide all ptz tab attributes
			Validate.hideAttribute("PTZID", this);
			Validate.hideAttribute("PTZ_CAMERATYPE", this);
			Validate.hideAttribute("PTZ_TCP_PORT", this);
			Validate.hideAttribute("PTZ_TRANSPORT", this);
			Validate.hideAttribute("PTZGROUP", this);
			Validate.hideAttribute("PTZSPEED", this);
			Validate.hideAttribute("PTZ_PRESET1TIMEOUT", this);
			Validate.hideAttribute("PTZ", this);
			Validate.hideAttribute("PTZ_HFOV", this);
			Validate.hideAttribute("PTZ_HFOV_MIN", this);
			Validate.hideAttribute("PTZ_HFOV_MAX", this);
			break;
		case 'pvpaeo':
			Validate.showAttribute("PTZ_TCP_IP", this);
			break;
		case 'Pelco':
			Validate.showAttribute("PTZ_TCP_IP", this);
			break;
	}
};

Validate.Bosch.MEDIAFORMAT = function(event, parameters)
{
	if (typeof parameters === "undefined" || !parameters.firstRun)
	{
		Log.warning("Please apply media format change before you proceed");
	}

	Validate.DEFAULT.MEDIAFORMAT.apply(this, arguments);
};

Validate.Bosch.MEDIAFORMAT_VIPX2 = function(event, parameters)
{
	var isShowMessage = typeof parameters === "undefined" || !parameters.firstRun;

	var value = $(Validate.getObj("MEDIA_FORMAT", this)).val();
	var proto = $(Validate.getObj("PROTO", this)).val();
	var FRAMERATE = $(Validate.getObj("FRAMERATE", this)).val();
	var ARCFRAMERATE = $(Validate.getObj("ARCFRAMERATE", this)).val();
	if (value === 'mjpg')
	{
		Validate.hideAttribute("RC_MODE", this);
		Validate.hideAttribute("RC_TARGETBITRATE", this);
		Validate.hideAttribute("RC_MAXBITRATE", this);

		Validate.showAttribute("FRAMERATE", this);
		Validate.showAttribute("ARCFRAMERATE", this);
		Validate.showAttribute("CAMCOMPRESSION", this);

		$(Validate.getObj("PROTO", this)).val('HTTP');

		Validate.showAttribute("HTTP_PORT", this);
		Validate.hideAttribute("RTSP_PORT", this);

		Validate.hideAttribute("RTP_OVER_TCP", this);
		Validate.hideAttribute("RTP_TIME", this);
		Validate.hideAttribute("RTP_FORCE_MULTICAST", this);
		Validate.hideAttribute("GOP", this);

		if (proto !== 'HTTP')
		{
			isShowMessage = isShowMessage || true;
		}

		if(ARCFRAMERATE > FRAMERATE)
		{
			Log.warning("Archive frame rate should not exceed Capture frame rate");
		}
	} else
	if (value === 'mpeg4' || value === 'h264')
	{
		Validate.showAttribute("RC_MODE", this);
		$(Validate.getObj("RC_MODE", this)).trigger('change');

		Validate.showAttribute("FRAMERATE", this);
		Validate.hideAttribute("ARCFRAMERATE", this);
		Validate.hideAttribute("CAMCOMPRESSION", this);

		$(Validate.getObj("PROTO", this)).val('RTSP');

		Validate.hideAttribute("HTTP_PORT", this);
		Validate.showAttribute("RTSP_PORT", this);

		Validate.showAttribute("RTP_OVER_TCP", this);
		Validate.showAttribute("RTP_TIME", this);
		Validate.showAttribute("RTP_FORCE_MULTICAST", this);
		Validate.showAttribute("GOP", this);

		if (proto !== 'RTSP')
		{
			$(Validate.getObj("IMAGESIZE", this)).val('0');
			isShowMessage = isShowMessage || true;
		}
	}

	if (isShowMessage)
	{
		Log.warning("Please apply media format change before you proceed");
	}
};

Validate.Bosch.getKeyValuePairs = function(str)
{
	var _str = str.replace(/([^\\]),/g, '$1 ,');
	var _array = _str.split(/[^\\],/);
	var array = {};
	$.each(_array, function(k, v){
		if (v.indexOf(":") != -1)
		{
			var _v = v.replace(/([^\\]):/g, '$1 :');
			var item = _v.split(/[^\\]:/);
			array[item[0]] = item[1];
		} else {
			array[v] = v;
		}
	});
	return array;
};

Validate.template_attr = Validate.template_attr || {};
Validate.Bosch.IMAGESIZE_NWC_0495 = function(event, parameters)
{
	Validate.Bosch.MEDIAFORMAT_VIPX2.apply(this, arguments);

	if (Validate.template_attr === undefined
		|| Validate.template_attr.IMAGESIZE_LIST === undefined
		|| Validate.template_attr.IMAGESIZE_LIST.VALUE === undefined)
	{
		return;
	}

	var _imagesizes = Validate.Bosch.getKeyValuePairs(Validate.template_attr.IMAGESIZE_LIST.VALUE);
	var imagesizes = {};
	$.each(_imagesizes, function(k,v){
		v = v.replace(/\\,/g, ',')
			.replace(/\\:/g, ':');
		imagesizes[k] = Validate.Bosch.getKeyValuePairs(v);
	});

	var MEDIA_FORMAT = Validate.getObj('MEDIA_FORMAT', this).val();
	var imagesizeList = imagesizes[MEDIA_FORMAT];
	var htmlImageSizes = "";
	$.each(imagesizeList, function(k, v){
		htmlImageSizes += "<option value=\"" + k + "\">" + v + "</option>";
	});
	Validate.getObj("IMAGESIZE", this).html(htmlImageSizes);
};
