/*
# $Id: validate.js 33162 2015-10-14 22:31:06Z astarostin $
#------------------------------------------------------------------------------
# Validation functions
# Used for validate camera attributes. Function names defined in the template.
#------------------------------------------------------------------------------
# Author: Serg Tsybulsky
# Edited by: Andrey Starostin
# QA by:
# Copyright: videoNEXT Network Solutions LLC 2006
#-----------------------------------------------------------------------------
*/
window.Validate = window.Validate || {};
Validate.Axis = Validate.Axis || {};

Validate.Axis.POSITIONCTL_EXTPTZ = function ()
{
	Validate.hideAttribute("PTZGROUP", this);
	Validate.showAttribute("PTZID", this);
	Validate.showAttribute("PTZ_CAMERATYPE_ALL", this);
	Validate.hideAttribute("PTZ_CAMERATYPE_ICD001", this);
	Validate.showAttribute("PTZ_TCP_PORT", this);
	Validate.showAttribute("PTZGROUP", this);
	Validate.hideAttribute("PTZ_CAMERATYPE_ICD001", this);
	Validate.hideAttribute("PTZ_INVERT", this);
	Validate.showAttribute("PTZ_HFOV_MIN", this);
	Validate.showAttribute("PTZ_HFOV_MAX", this);

	var value = $(Validate.getObj("POSITIONCTL", this)).val();
	switch (value)
	{
		case 'none':
			// hide all ptz tab attributes
			Validate.hideAttribute("PTZID", this);
			Validate.hideAttribute("PTZ_CAMERATYPE_ALL", this);
			Validate.hideAttribute("PTZ_TCP_PORT", this);
			Validate.hideAttribute("PTZ_TRANSPORT", this);
			Validate.hideAttribute("PTZGROUP", this);
			Validate.hideAttribute("PTZSPEED", this);
			Validate.hideAttribute("PTZ_PRESET1TIMEOUT", this);
			Validate.hideAttribute("PTZ", this);
			Validate.hideAttribute("PTZ_HFOV", this);
			Validate.hideAttribute("PTZ_HFOV_MIN", this);
			Validate.hideAttribute("PTZ_HFOV_MAX", this);
			break;
		case 'ptcr20bae':
			$(Validate.getObj("PTZ_CAMERATYPE_ALL", this)).val('ptcr20bae');
			$(Validate.getObj("PTZ_CAMERATYPE_ALL", this)).trigger("change");
			break;
		case 'ptcr20flir':
			$(Validate.getObj("PTZ_CAMERATYPE_ALL", this)).val('ptcr20flir');
			$(Validate.getObj("PTZ_CAMERATYPE_ALL", this)).trigger("change");
			break;
		case 'flir_35x_140':
			$(Validate.getObj("PTZ_CAMERATYPE_ALL", this)).val('flir');
			$(Validate.getObj("PTZ_CAMERATYPE_ALL", this)).trigger("change");
			break;
		case 'icd001':
			Validate.showAttribute("PTZGROUP", this);
			Validate.hideAttribute("PTZ_CAMERATYPE_ALL", this);
			Validate.showAttribute("PTZ_CAMERATYPE_ICD001", this);
			$(Validate.getObj("PTZ_CAMERATYPE_ICD001", this)).trigger("change");
			break;
		case 'Pelco':
			Validate.showAttribute("PTZ_INVERT", this);
			break;
		default:
			$(Validate.getObj("PTZ_CAMERATYPE_ALL", this)).trigger("change");
	}
};

Validate.Axis.PTZ_CAMERATYPE_ICD001 = function()
{
	if ($(Validate.getObj("POSITIONCTL", this)).val() == 'icd001'){
		var PTZ_CAMERATYPE_ICD001value = $(Validate.getObj("PTZ_CAMERATYPE_ICD001", this)).val();
		$(Validate.getObj("PTZ_CAMERATYPE", this)).val(PTZ_CAMERATYPE_ICD001value);
	}
};

Validate.Axis.PTZ_CAMERATYPE_ALL = function()
{
	if ($(Validate.getObj("POSITIONCTL", this)).val() !== 'icd001'){
		var PTZ_CAMERATYPE_ALLvalue = $(Validate.getObj("PTZ_CAMERATYPE_ALL", this)).val();
		$(Validate.getObj("PTZ_CAMERATYPE", this)).val(PTZ_CAMERATYPE_ALLvalue);
	}
};

Validate.Axis.MEDIAFORMAT = function()
{
	var value = $(Validate.getObj("MEDIA_FORMAT", this)).val();
	if (value === 'mjpg'){
		Validate.hideAttribute("RC_MODE", this);
		Validate.hideAttribute("RC_TARGETBITRATE", this);
		Validate.hideAttribute("RC_MAXBITRATE", this);

		Validate.showAttribute("FRAMERATE", this);
		Validate.showAttribute("ARCFRAMERATE", this);
		Validate.showAttribute("CAMCOMPRESSION", this);

		$(Validate.getObj("PROTO", this)).val('HTTP');

		Validate.showAttribute("HTTP_PORT", this);
		Validate.hideAttribute("RTSP_PORT", this);

		Validate.hideAttribute("RTP_OVER_TCP", this);
		Validate.hideAttribute("RTP_TIME", this);
		Validate.hideAttribute("RTP_FORCE_MULTICAST", this);
		if (/^207[A-Z]*/.test ($(Validate.getObj("MODELID", this)).val()))
		{
			$(Validate.getObj("AUDIO", this)).val('off');
			$(Validate.getObj("AUDIO", this)).prop("disabled", true);
		}
		if (/^(Q|M|P)\w+/.test ($(Validate.getObj("MODELID", this)).val()))
		{
			Validate.hideAttribute("GOV", this);
			Validate.hideAttribute("RC_PRIORITY", this);
		}
	} else
	if (value === 'mpeg4' || value === 'h264'){
		Validate.showAttribute("RC_MODE", this);
		$(Validate.getObj("RC_MODE", this)).trigger('change');
		//Validate.Axis.RC_MODE();

		Validate.hideAttribute("FRAMERATE", this);
		Validate.hideAttribute("ARCFRAMERATE", this);
		Validate.hideAttribute("CAMCOMPRESSION", this);

		$(Validate.getObj("PROTO", this)).val('RTSP');

		Validate.hideAttribute("HTTP_PORT", this);
		Validate.showAttribute("RTSP_PORT", this);

		Validate.showAttribute("RTP_OVER_TCP", this);
		Validate.showAttribute("RTP_TIME", this);
		Validate.showAttribute("RTP_FORCE_MULTICAST", this);

		if (/^207[A-Z]*/.test ($(Validate.getObj("MODELID", this)).val()))
		{
			$(Validate.getObj("AUDIO", this)).prop("disabled", false);
		}
		if (/^(Q|M|P)\w+/.test ($(Validate.getObj("MODELID", this)).val()))
		{
			Validate.showAttribute("GOV", this);
		}
	}
};

Validate.Axis.RC_MODE = function()
{
	var value = $(Validate.getObj("RC_MODE", this)).val();
	if (value === 'vbr'){
		Validate.hideAttribute("RC_TARGETBITRATE", this);
		Validate.hideAttribute("RC_MAXBITRATE", this);
		Validate.hideAttribute("RC_PRIORITY", this);
	} else
	if (value === 'cbr'){
		Validate.showAttribute("RC_TARGETBITRATE", this);
		Validate.hideAttribute("RC_MAXBITRATE", this);
		Validate.showAttribute("RC_PRIORITY", this);
	}
};
