/*
# $Id: validate.js 28549 2013-05-07 20:08:36Z teetov $
#------------------------------------------------------------------------------
# Validation functions
# Used for validate camera attributes. Function names defined in the template.
#------------------------------------------------------------------------------
# Author: Serg Tsybulsky
# Edited by: Andrey Starostin
# QA by:
# Copyright: videoNEXT Network Solutions LLC 2006
#-----------------------------------------------------------------------------
*/
window.Validate = window.Validate || {};
Validate.Arecont = Validate.Arecont || {};

Validate.Arecont.CAMCOMPRESSION_MJPG = function()
{
	if (Validate.isAttributeVisible("CAMCOMPRESSION_MJPG", this))
	{
		var CAMCOMPRESSIONvalue = $(Validate.getObj("CAMCOMPRESSION_MJPG", this)).val();
		$(Validate.getObj("CAMCOMPRESSION", this)).val(CAMCOMPRESSIONvalue);
	}
};

Validate.Arecont.CAMCOMPRESSION_H264 = function()
{
	if (Validate.isAttributeVisible("CAMCOMPRESSION_H264", this))
	{
		var CAMCOMPRESSIONvalue = $(Validate.getObj("CAMCOMPRESSION_H264", this)).val();
		$(Validate.getObj("CAMCOMPRESSION", this)).val(CAMCOMPRESSIONvalue);
	}
};

Validate.Arecont.MEDIAFORMAT = function()
{
	var value = $(Validate.getObj("MEDIA_FORMAT", this)).val();
	if (value === 'mjpg'){
		Validate.showAttribute("FRAMERATE", this);
		Validate.showAttribute("ARCFRAMERATE", this);
		Validate.hideAttribute("RC_TARGETBITRATE", this);
		Validate.showAttribute("CAMCOMPRESSION_MJPG", this);
		Validate.hideAttribute("CAMCOMPRESSION_H264", this);

		$(Validate.getObj("PROTO", this)).val('HTTP');
		Validate.showAttribute("HTTP_PORT", this);
		Validate.hideAttribute("RTSP_PORT", this);
		
		Validate.hideAttribute("RTP_OVER_TCP", this);
		Validate.hideAttribute("RTP_TIME", this);
		Validate.hideAttribute("RTP_FORCE_MULTICAST", this);
		
	} else
	if (value === 'h264'){
		Validate.showAttribute("RC_TARGETBITRATE", this);
		Validate.showAttribute("FRAMERATE", this);
		Validate.hideAttribute("ARCFRAMERATE", this);
		Validate.hideAttribute("CAMCOMPRESSION_MJPG", this);
		Validate.showAttribute("CAMCOMPRESSION_H264", this);

		$(Validate.getObj("PROTO", this)).val('RTSP');
		Validate.hideAttribute("HTTP_PORT", this);
		Validate.showAttribute("RTSP_PORT", this);
		
		Validate.showAttribute("RTP_OVER_TCP", this);
		Validate.showAttribute("RTP_TIME", this);
		Validate.showAttribute("RTP_FORCE_MULTICAST", this);
	}
};
