/*
# $Id: validate.js 21985 2011-02-23 18:18:15Z teetov $
#------------------------------------------------------------------------------
# Validation functions
# Used for validate camera attributes. Function names defined in the template.
#------------------------------------------------------------------------------
# Author: Serg Tsybulsky
# Edited by: Andrey Starostin
# QA by:
# Copyright: videoNEXT Network Solutions LLC 2006
#-----------------------------------------------------------------------------
*/
window.Validate = window.Validate || {};
Validate.ACTi = Validate.ACTi || {};

Validate.ACTi.MEDIAFORMAT = function()
{
	var value = $(Validate.getObj("MEDIA_FORMAT", this)).val();
	if (value === 'mjpg'){
		Validate.hideAttribute("RC_MODE", this);
		Validate.hideAttribute("RC_TARGETBITRATE", this);
		Validate.hideAttribute("RC_MAXBITRATE", this);
		Validate.hideAttribute("VIDEO_QUALITY", this);

		Validate.showAttribute("ARCFRAMERATE", this);
		Validate.showAttribute("VIDEO_MJPEG_QUALITY", this);
	} else
	if (value === 'mpeg4' || value === 'h264'){
		Validate.showAttribute("RC_MODE", this);
		$(Validate.getObj("RC_MODE", this)).trigger('change');

		Validate.hideAttribute("ARCFRAMERATE", this);
		Validate.hideAttribute("VIDEO_MJPEG_QUALITY", this);
	}
};

Validate.ACTi.RC_MODE = function()
{
	var value = $(Validate.getObj("RC_MODE", this)).val();
	if (value === 'cbr'){
		Validate.showAttribute("RC_TARGETBITRATE", this);
		Validate.showAttribute("RC_MAXBITRATE", this);
		$(Validate.getObj("RC_MAXBITRATE", this)).trigger('change');
		Validate.hideAttribute("VIDEO_QUALITY", this);
	} else
	if (value === 'vbr'){
		Validate.hideAttribute("RC_TARGETBITRATE", this);
		Validate.hideAttribute("RC_MAXBITRATE", this);
		Validate.showAttribute("VIDEO_QUALITY", this);
	}
};

Validate.ACTi.RC_MAXBITRATE = function()
{
	var value = $(Validate.getObj("RC_MAXBITRATE", this)).val();
	if(value === 'UNLIMITED'){
		Validate.showAttribute("RC_TARGETBITRATE", this);
	} else {
		Validate.hideAttribute("RC_TARGETBITRATE", this);
	}
};