#!/usr/bin/php
<?php
/**
 * @version $Id: update_objects.php 33190 2015-10-21 13:24:05Z astarostin $
 * ------------------------------------------------------------------------------
 * update objects
 * sync objects attributes in DB and in Template
 * ------------------------------------------------------------------------------
 * @author Andrey Starostin
 * @QA
 * @copyright videoNEXT Network Solutions, Inc, 2012
 * ------------------------------------------------------------------------------
 */

require_once $_SERVER["APL"] . "/api/lib/php/bootstrap.php";

// audit from admin user
$_SESSION[SESSION_USERID] = User::ADMIN;

try
{
	DB::switchToLocal();
}
catch (DBException $e)
{
	writeToLog("FATAL ERROR: " . $e->getMessage());
	exit(1);
}

$LABEL = Node::getLabel();

function writeToLog($message)
{
	global $LABEL;
	$pathToLog = $_SERVER["APL_VAR"] . "/log/update/conf/$LABEL.update_objects.log";

	if (($f = fopen($pathToLog, 'a+')) !== FALSE)
	{
		fwrite($f, "$message\n");
		fclose($f);
	}
}

$numberOk = 0;
$numberError = 0;

$list = array();

try
{
	// get list of objects
	$node = new Node();
	$list = $node->getAllObjects();
}
catch (Exception $e)
{
	$numberError++;
	writeToLog("ERROR: " . $e->getMessage());
}

foreach ($list as $row)
{
	try
	{
		$object = Factory::getByObj($row["obj"]);

		if (!isset($object))
			continue;

		$type = $object->getType($row["obj"]);
		if (!isset($type))
			continue;
		if (!method_exists($object, "getTemplateAttributes"))
			continue;

		$objectTemplate = new ObjectTemplate($type);
		$templateAttributes = $objectTemplate->getTemplateAttributes($row["obj"]);
		$templateAttributes = $templateAttributes["attributes"];

		$attributes = array();
		foreach ($templateAttributes as $attribute => $properties)
		{
			if (!in_array($properties["TYPE"], array("urllist", "urlbutton", "checkboxlist")))
			{
				$attributes[$attribute] = $properties["VALUE"];
			}
		}

		$syncLog = $object->syncAttributesWithTemplate($row["obj"], $attributes);
		foreach ($syncLog["create"] as $obj => $attributes)
		{
			foreach ($attributes as $attribute => $value)
			{
				writeToLog("Create attribute=$attribute for obj=$obj");
				$numberOk++;
			}
		}
		foreach ($syncLog["delete"] as $obj => $attributes)
		{
			foreach ($attributes as $attribute => $value)
			{
				writeToLog("Delete attribute=$attribute for obj=$obj");
				$numberOk++;
			}
		}
	}
	catch (Exception $e)
	{
		$numberError++;
		writeToLog("ERROR: " . $e->getMessage());
	}
}

// log
writeToLog("update_objects COMPLETED; updated=$numberOk errors=$numberError");
exit(0);
