#!/usr/bin/perl
#
# sctipt sets default TIME_ZONE & TIME_DST in CAMERA.cfg
# set a new value only this value is defined in "choice-list" in configuration file
#
# usage 
#     set_default_tz -5 USA-Canada
#     set_default_tz -6 USA-Canada
#     set_default_tz +1 Europe
# Conf sample:
#02.Source:::TIME_ZONE:::Time Zone Offset (from UTC)</a>:::dropmenu:::+3:::+0,+1,+2,+3,+3.5,+4,+4.5,+5,-1,-2,-3,-3.5,-4,,-9.5,-10,-11,-12::::::
#02.Source:::TIME_DST:::DST Schedule:::dropmenu:::USA-Canada:::none,USA-Canada,Europe::::::
use strict;


my @v_cfg=("$ENV{APL}/conf/etc/CAMERA.cfg","$ENV{APL}/conf/etc/AUDIO.cfg");
my $tz=shift;		# expected time zone shift : -5,+3 etc
my $lc=shift;		# expected location: USA-Canada,Europe

die "\nusage $0 -5 US-Canada\n\n" if ! (defined $tz and defined $lc);
foreach (@v_cfg) {
 `perl -pi -e '\@v=split /,/, (split /:::/)[5]; s|dropmenu:::[-+]?\\d+(\\.5)?:::|dropmenu:::${tz}:::| if /^\\d+\\.\\w+:::TIME_ZONE/ and grep /^\Q$tz\E\$/,\@v' $_`;
 `perl -pi -e '\@v=split /,/, (split /:::/)[5]; s|dropmenu:::[\\w-]+:::|dropmenu:::${lc}:::| if /^\\d+\\.\\w+:::TIME_DST/ and grep /^\Q$lc\E\$/,\@v'  $_`;  
}
