#!/usr/bin/perl

#---------------------------------------------------------
# nodestat.cgi - returns brief node statistics:
#  - uptime
#  - current CPU load
#  - storage capacity
#
# This script must reside in 'conf' module where access is
# allowed for localhost and s_master only, so do not check
# user credentials and remote address
#---------------------------------------------------------

use strict;
use Master::Conf;
use Node::Conf;

my $APL = $ENV{APL} || '/opt/sarch';
my $APL_VAR = $ENV{APL_VAR};
my $MASTER = "$APL_VAR/conf/master/s_master";
my $uptime = "0:00";
my ($cpu_user, $cpu_sys) = ("0.00", "0.00");
my ($root_cap, $storage_cap) = ("unknown", "unknown");
my $storage = "/vasm/store";

sub capacity {
    foreach(split("\n", `df -P $_[0] 2>/dev/null`)) {
	/\s\d+\s+\d+\s+\d+\s+(\d+)%/ && do { my $cap = $1; return $cap };
    }
}

sub nodestat {
    # uptime
    ($uptime) = `/usr/bin/uptime` =~ /up (.+?),\s*\d+\s+user/;

    # cpu stat (OS-specific)
    if($^O !~ /darwin/i) {
        ($cpu_user, $cpu_sys) = `/usr/bin/mpstat -P ALL 1 1` =~ /^Average:\s+all\s+(\S+)\s+\S+\s+(\S+)/msi;
    }
    else {
        ($cpu_user, $cpu_sys) = `top -F -l 1 -n 0` =~ /CPU usage: (.+?)\% user, (.+?)\% sys/si;
    }

    # disk stat
    $root_cap = capacity("/");
    if( -l $storage ) {
        $storage_cap = capacity(readlink $storage);
    }
    else {
        $storage_cap = capacity($storage);
    }
    
    # print response
    print <<END;
<?xml version="1.0"?>
<nodestat>
<uptime value="$uptime"/>
<cpu user="$cpu_user" sys="$cpu_sys"/>
<disk root="$root_cap" storage="$storage_cap"/>
</nodestat>
END

}

sub main {
    if (-f $MASTER) {
	my $uni = shift @ARGV;
	if (defined $uni and $uni ne UNI) {
	    print NodeCmd($uni, "$APL/conf/bin/nodestat.pl");
	}
	else {
	    nodestat;
	}
    }
    else {
	nodestat;
    }
}

main;
