#!/usr/bin/perl
#  $Id: cfg2po.pl 33488 2016-01-11 00:43:20Z astarostin $
# -----------------------------------------------------------------------------
#  Name: Internationalization
#  Note: create .po file from .cfg file
#  cfg2po.pl template.cfg > locale.po
# -----------------------------------------------------------------------------
#  Author: Andrey Starostin
#  Edited by:
#  QA by:
#  Copyright: videoNEXT LLC
# -----------------------------------------------------------------------------

=FORMAT
One PO file entry has the following schematic structure:
     white-space
     #  translator-comments
     #. extracted-comments
     #: reference...
     #, flag...
     #| msgid previous-untranslated-string
     msgid untranslated-string
     msgstr translated-string

It is also possible to have entries with a context specifier. They look like this:
     white-space
     #  translator-comments
     #. extracted-comments
     #: reference...
     #, flag...
     #| msgctxt previous-context
     #| msgid previous-untranslated-string
     msgctxt context
     msgid untranslated-string
     msgstr translated-string

A different kind of entries is used for translations which involve plural forms.
     white-space
     #  translator-comments
     #. extracted-comments
     #: reference...
     #, flag...
     #| msgid previous-untranslated-string-singular
     #| msgid_plural previous-untranslated-string-plural
     msgid untranslated-string-singular
     msgid_plural untranslated-string-plural
     msgstr[0] translated-string-case-0
     ...
     msgstr[N] translated-string-case-n

example:
#: lib/error.c:116
msgid "Unknown system error"
msgstr "Error desconegut del sistema"

.cfg file format:
SECTION~ATTR~TYPE~LABEL~DEFAULT-VALUE~LIST~VALIDATE-FUNCTION~ERROR MESSAGE

=cut

use strict;
#use warnings;
use CGI qw/escape unescape/;
use Data::Dumper;

main();

sub main
{
	if (scalar @ARGV < 1)
	{
		print "$0 (file.cfg|directory) > outputfile.po\n";
		exit 1;
	}
	my ($from, $to) = @ARGV;

	my %msgid = {};

	if (-d $from)
	{
		my @templates = `find $from -maxdepth 6 -type f -iname "*.cfg"`;
		foreach (@templates)
		{
			%msgid = parseCFG($_, %msgid);
		}
	} elsif (-f $from)
	{
		%msgid = parseCFG($from, %msgid);
	}

	# print "dump\n" . Dumper(\%msgid);
	# print .po file format
	# print header
	# print "msgid \"\"\n";
	# print "msgstr \"\"\n";
	# print "\"Project-Id-Version: Templates\\n\"\n";
	# print "\"MIME-Version: 1.0\"\n";
	# print "\"Content-Type: text/plain; charset=UTF-8\\n\"\n";
	# print "\"Content-Transfer-Encoding: 8bit\\n\"\n";
	# print "\"Plural-Forms: nplurals=2; plural=(n != 1);\\n\"\n";

	foreach my $key (sort keys (%msgid))
	{
		# not include numbers, empty strings, resolutions (ex: 1600x1200), sizes (ex: 2M, 256K)
		if (
			trim($key) ne ''
			&& $key !~ /^(-?|\+?|\s*)\d+((M|K)?|(\.\d+)?(M|K)?|x\d+)\s*$/
			)
		{
			print "\n";
			print "msgctxt \"template\"\n";
			print "msgid \"$key\"\n";
			print "msgstr \"\"\n";
		}
	}
}

sub parseCFG
{
	my ($file, %msgid) = @_;

	my $formatDelimiter = qr/(?<!\\)~/;
	my $commaDelimiter = qr/(?<!\\),/;
	my $colonDelimiter = qr/(?<!\\):/;

	open F, "<$file" or die "ERROR: Unable to read file $file\n";
	while (<F>)
	{
		# accept only lines with attribute definitions
		if ($_ =~ /^\w+~/)
		{
			# SECTION~ATTR~TYPE~LABEL~DEFAULT-VALUE~LIST~VALIDATE-FUNCTION~ERROR MESSAGE
			# General~LOCATION~textfield23~Location~NEWlocation~~re!^\w*[^']*$~Location should begin with a character and not contain quotes
			# General~ARCHSTATE~dropmenu~State~on~ls!on:ON,off:OFF~~
			chomp($_);
			my @elements = split($formatDelimiter, $_);
			my ($SECTION, $ATTR, $TYPE, $LABEL, $DEFAULT_VALUE, $LIST, $VALIDATE_FUNCTION, $ERROR_MESSAGE) = @elements;
			$msgid{$SECTION} = "";
			$msgid{$LABEL} = "";

			if ($TYPE =~ /^(textfield|password|urlbutton)/)
			{
				$msgid{$DEFAULT_VALUE} = "";

				$ERROR_MESSAGE =~ s/(\n+|\r+)//;
				$msgid{$ERROR_MESSAGE} = "";
			} elsif ($TYPE =~ /^dropmenu/)
			{
				my @pairs = split($commaDelimiter, $LIST);
				foreach my $pair (@pairs)
				{
					my ($key, $value) = split($colonDelimiter, $pair);
					$value =~ s/\\:/:/g;
					$value =~ s/\\,/,/g;
					$msgid{$value} = "";
				}

				$ERROR_MESSAGE =~ s/(\n+|\r+)//;
				$msgid{$ERROR_MESSAGE} = "";
			}
		}
	}

	return %msgid;
}

sub trim
{
	my $string = shift;
	$string =~ s/^\s+//;
	$string =~ s/\s+$//;
	return $string;
}
