#!/usr/bin/perl
#  $Id: config_auto_backup.pl 30437 2014-04-01 15:19:55Z atsybulnik $
# -----------------------------------------------------------------------------
#  Configure crontab for create configuration backups in some moments of time
# -----------------------------------------------------------------------------
#  Author: Starostin Andrey
#  Edited by: 
#  QA by:  
#  Copyright: videoNEXT Network Solutions Inc 2006
# -----------------------------------------------------------------------------

use strict;

use NextCAM::Init;
use NextCAM::Conf "GetDefaultCfg";

my %asrv = GetAsrv();
my $default = GetDefaultCfg 'identity';

if ($default and ref($default) eq 'HASH') {
    %asrv = (%$default, %asrv);
}
else {
    warn "Default identity template is empty!\n";
}

die "BACKUP_AUTO identity value not defined\n" if not exists $asrv{BACKUP_AUTO};
die "BACKUP_AUTO_HOUR identity value not defined\n" if not exists $asrv{BACKUP_AUTO_HOUR};

# each n days create backup
my $DAY = $asrv{BACKUP_AUTO};
$DAY = "*" if ($DAY = 1);
$DAY = "*/$DAY" if ($DAY > 1);

# time when create backup
my $HOUR = substr($asrv{BACKUP_AUTO_HOUR}, 0, 2);
my $MINUTE = substr($asrv{BACKUP_AUTO_HOUR}, 3, 2);

my $backup_command = "($ENV{APL}/conf/bin/master_backup -m auto; $ENV{APL}/conf/bin/backup_auto_clean.pl) >/dev/null 2>&1";
my $cron_work = "$MINUTE $HOUR $DAY * * root . /opt/sarch/base/etc/env.conf; su apl -c \"$backup_command\"";
my $write_conf = "sudo $ENV{APL}/conf/bin/config_auto_backup.root '$cron_work'";

system("$write_conf");
