#!/usr/bin/perl
# :set ts=4
#-----------------------------------------------------------------------------
#  Author: Ron Nau
#  QA by:  
#  Copyright: videoNEXT Network Solutions LLC
#------------------------------------------------------------------------------

#-------------------------------------------------
# validate device configuration against rules file
#-------------------------------------------------
use NextCAM::Init;
use Tie::IxHash; # be able to recover hash insertion order (unused at present)

use Log::Log4perl "get_logger";
require "$ENV{APL}/common/bin/logger.patrol";
my $logger = get_logger('NEXTCAM::CAM::CAM_PATROL');
#$logger->level($INFO);

## setup debug logger with file output
#use Log::Log4perl qw(:easy);
#Log::Log4perl->easy_init($DEBUG);
#my $logger = get_logger();
#my $appender = Log::Log4perl::Appender->new(
#					"Log::Dispatch::File",
#					filename => "/tmp/conf_validate.log",
#					mode     => "append"
#				);
#$logger->add_appender($appender);
#$logger->level($INFO);

if(open CONF_VER, "$ENV{APL}/var/conf/CONF_VERSION") {
	$_=<CONF_VER>;
	close CONF_VER;
	if (/(\d+\.\d+\.\d)-(\w+)_(\d+)$/) {
		$conf_version = $1;
	}
}
if ($conf_version == undef) { $conf_version = "2.4.0"; }
$logger->info("conf version: $conf_version");

if(open VER, "$ENV{APL}/base/etc/VERSION") {
	$_=<VER>;
	close VER;
	if (/(\d+\.\d+\.\d)-(\w+)_(\d+)$/) {
		$current_version = $1;
	}
}
$logger->info("current version: $current_version");

my $rules_file = "$ENV{APL}/conf/etc/rules-$conf_version-to-$current_version";

$logger->info("rules: $rules_file");
if (!-r $rules_file) {
	$logger->warn("no rules file available, run default update");
        default_update();
        # validation has been applied, copy code version file to configuration
        system("cp $ENV{APL}/base/etc/VERSION $ENV{APL}/var/conf/CONF_VERSION");
	exit;
}	

my $dir = "$ENV{APL}/var/conf/";
$logger->debug("looking in dir: $dir");
@files = <$dir*>;	# get all conf directories
$dir =~ s/\//\\\//g;	# make it usable in a pattern (replace / with \/)

# for each device configuration file


my %cameras=GetCfgs('DEVICETYPE'=>'CAMERA');

foreach my $devid ( keys %cameras) {
    my $point=$cameras{$devid};   
    $logger->info("0cecking... $point->{NAME}:$point->{VERSION}"); 
    next if defined $point->{VERSION} && $point->{VERSION} eq $current_version;
     $logger->info("checking... $point->{NAME}");
    if(validate($point,$rules_file)) {
        my $conf="$ENV{APL}/var/conf/conf/$devid.conf";
        $logger->info("writing conf_file: $conf --------- $point->{NAME}");
        unlink $conf if -f $conf;
        if( open UPDATED_CONF, ">$conf") {
           print UPDATED_CONF  "$_=$point->{$_}\n" foreach (sort keys %$point);
           close UPDATED_CONF;
        }else {
           $logger->error("Cannot create a file $conf");
        } 
    }
}

# validation has been applied, copy code version file to configuration
system("cp $ENV{APL}/base/etc/VERSION $ENV{APL}/var/conf/CONF_VERSION");



sub write_conf {
#---==========-------------------------------------------------
# write conf to $APL/var/conf/conf/devid.conf
#--------------------------------------------------------------
 my $ref=shift;
 my $CONFDIR="$ENV{APL}/var/conf";
 my $dev=$$ref->{DEVID};
 if($dev!~/^[anjvw]?\d+/) {
   $logger->error("ERR: write_conf unexpected device id=$dev");
   return;
 }
 unlink "$CONFDIR/conf/$dev.conf.tmp" if -f  "$CONFDIR/conf/$dev.conf.tmp";
 $logger->info("write_conf: writing $CONFDIR/conf/$dev.conf");
 if (! open CF,">$CONFDIR/conf/$dev.conf.tmp" ){
   $logger->error("cannot create >$CONFDIR/conf/$dev.conf.tmp  DEVID=$dev");
   return;
 }
 print CF "$_=$$ref->{$_}\n" foreach( sort keys %$$ref);
 close CF;
 unlink "$CONFDIR/conf/$dev.conf" if -f  "$CONFDIR/conf/$dev.conf";
 rename "$CONFDIR/conf/$dev.conf.tmp","$CONFDIR/conf/$dev.conf";
}


#------------------------------------------------------------------------
# default update runs if  validate file is not present
# dafault update simple extent configuration if found any additional default attribute
#------------------------------------------------------------------------
sub default_update {
 my %conf = GetCfgs(DEVICETYPE=>'CAMERA');

 foreach (keys %conf) {
   write_conf(\$conf{$_});
 }
}

 
#-------------------------------------------------
# validate referenced hash of configuration values
#-------------------------------------------------
sub validate(\%, $) {
	my ($confhash, $file) = @_;
	my $changed = 1; # we sure conf is changed 
	my @items;

$logger->info(" validating $confhash->{NAME}");
	open RULES, '<', $file
		or die "Can't open '$file' for reading: $!";
        $$confhash{VERSION}=$current_version;           # set version for configuration
	while (<RULES>) {
		next if ($_ =~ '^#.*' | $_ =~ '^\s*$'); # skip comments and blank lines
		if ($_ =~ 'RULES_VERSION=(\d+)$') {
			$rules_version = $1;
			$logger->info("rules version $rules_version");
			next;
		}
		chomp;
		@items = split;

		# apply rule indicated by @items - first item is condition
		my ($cond_key, $cond_value) = split /=/,$items[0],2;

		# if key exists in configuration and has value as defined by rule, 
		# then enforce other rules on this line

		if (exists($$confhash{$cond_key}) && $$confhash{$cond_key} == $cond_value) { 
			$logger->debug("rule applies to this configuration, has key: \'$cond_key\' with value \'$cond_value\'");
			foreach $item (@items[1..$#items]) { # all other items are required
				my ($rule_key, $rule_value) = split /=/,$item,2;
				# if key exists but does not have correct value
				if (exists($$confhash{$rule_key}) && ($$confhash{$rule_key} ne $rule_value)) { 
					$logger->info("need to fix $rule_key=$$confhash{$rule_key} :new value '$rule_value'");
                                        if($rule_value=~/^([\*|+|-|\/])(\d+):max\[(\d+)\]$/) {
                                            $logger->info("need to fix with complex value $1 $2 max $3");
                                            $$confhash{$rule_key} = $$confhash{$rule_key} * $2 if $1 eq '*';
                                            $$confhash{$rule_key} +=$2 if $1 eq '+';
                                            $$confhash{$rule_key}  =$3 if $$confhash{$rule_key} > $3;
                                        } else {
                                            $$confhash{$rule_key} = $rule_value;
                                        }
					$changed = 1;
				} 
			}
		} 
	}
	return $changed;
}

