#!/usr/bin/perl
use strict;
use warnings;
use XML::Simple;
use NextCAM::Init "GetAsrv";

# -------------------- standard environment -----------------------------------
my $APL = $ENV{APL};
open (ECF,"$APL/base/etc/env.conf") || die("Cannot read base/etc/env.conf");
map {$ENV{$1}=$2 if /^(\w+)=(\S+)/} grep {/^\w+=\S+/} <ECF>;
close ECF;
#------------------------------------------------------------------------------

my %Asrv = GetAsrv;
my $BCKROOT = "$APL/var/backup";
my $BACKUP_AUTO_FILES = defined $Asrv{BACKUP_AUTO_FILES} ? $Asrv{BACKUP_AUTO_FILES} : 50;
my @trash = (); # list of master backup dirs to remove

# ---------------------- Main -------------------------------------------------
# read master backup dir and find auto backups
opendir MASTER, "$BCKROOT/master" or die "Cannot open $BCKROOT: $!\n";
my @mbcks = sort {$b cmp $a} grep {/^\d{6}_\d{6}$/} readdir MASTER;
close MASTER;
my $cnt = 0;
foreach my $bck (@mbcks) {
    my $stat = eval { XMLin("$BCKROOT/master/$bck/stat.xml") };
    if($@ or not defined $stat) {
	push @trash, $bck;
	next;
    }
    if($stat->{TYPE} eq 'auto') {
	$cnt++;
	push @trash, $bck if $cnt > $BACKUP_AUTO_FILES;
    }
}

# Get available Storage Volumes
my @vols;
if (open(LIST, "$APL/sm/bin/sm_list 2>/dev/null|")) {
    @vols = grep {$_ ne '/vasm/store'} map {(split(/\s+/,$_))[1]} <LIST>;
    close LIST;
}

# Remove master backups and associated node backup files
foreach my $mbck (@trash) {
    #print "Clean: $mbck\n";
    opendir DOMAIN, "$BCKROOT/master/$mbck/domain" or next;
    foreach my $nbck (grep {/^nbck-\w{22}-\d{10}\.bck$/} readdir DOMAIN) {
	my $path = "$BCKROOT/node/$nbck";
	#print "\tassociated: node/$nbck\n";
	unlink $path if -f $path;
    }
    system("/bin/rm -rf $BCKROOT/master/$mbck");
    # Remove backups from Storage Volumes if any
    foreach my $vol (@vols) {
	my $dir = "$vol/backup/master/$mbck";
	system("/bin/rm -rf $dir") if -d $dir;
    }
}

# Now synchronize all per-volume backup location with main dir
opendir BCKROOT, "$BCKROOT/master" or die "Cannot open $BCKROOT: $!\n";
@mbcks = sort grep {/^\d{6}_\d{6}$/} readdir BCKROOT;
closedir BCKROOT;
# Wait for backup process to complete if running
my $pid = "$APL/var/backup/master_backup.pid";
my $tries = 3;
while (-f $pid and $tries) {
    $tries--;
    sleep 5;
}
foreach my $vol (@vols) {
    opendir BCKVOL, "$vol/backup/master" or next;
    my @bcks = sort grep {/^\d{6}_\d{6}$/} readdir BCKVOL;
    closedir BCKVOL;
    local $" = '|';
    my @cp = grep {!/^(@bcks)$/} @mbcks;
    my @rm = grep {!/^(@mbcks)$/} @bcks;
    system("/bin/rm -rf $vol/backup/master/$_") 
	foreach @rm;
    system("cp -pr $BCKROOT/master/$_ $vol/backup/master") 
	foreach @cp;
}
