#!/usr/bin/perl
# $Id: axis_list.pl 25817 2012-05-08 23:13:14Z teetov $
#------------------------------------------------------------------------------
# print list of all Axis cameras in network
# in next the format:
# camera_name (ip:port)
#------------------------------------------------------------------------------
# Author: Andrey Starostin
# Edited by:
# QA by:
# Copyright: videoNEXT Network Solutions LLC 2006
#-----------------------------------------------------------------------------

use Net::Bonjour;
use strict;

my $res = Net::Bonjour->new('axis-video', 'TCP', 'local');
$res->discover;

foreach my $entry ( $res->entries) 
{
	if (defined($entry->text))
	{
		printf "%s (%s:%s)\n", $entry->name, $entry->text->answerfrom, $entry->port;	
	}
}

# DEMO extention

my $DEMO_DIR='/opt/demo/data';
if (opendir(DIR,$DEMO_DIR)) {
   my %list= map {/(\d+)-(\w+)\.\d+x\d+\.\w+/} grep { /\d+-\w+\.\d+x\d+\.(mjpg|h264)/ } readdir(DIR);
   closedir DIR;
   foreach(keys %list) {
      print "DEMO $list{$_} (0.0.0.$_:80)\n";
   }
}

