package SKM::PM;

use strict;
use warnings;
use DBI;
use SKM::DB;
use Data::Dumper;

use base qw (Exporter);
our @EXPORT = qw(insertProcess updateProcess deleteProcess toggleProcess);


my $APL = $ENV{APL};
my $APL_USER = $ENV{APL_USR};
my $dbh;

my @paramDefs = (
	{ name=>'PROCNAME', isRequired=>1, column=>'procname'},
	{ name=>'DESCRIPTION', isRequired=>0, column=>'description'},
	{ name=>'STARTUP', isRequired=>1, column=>'startup'},
	{ name=>'CHECK_TIME', isRequired=>1, column=>'check_time'},
	{ name=>'START_SCRIPT', isRequired=>1, column=>'start_script'},
	{ name=>'STOP_SCRIPT', isRequired=>0, column=>'stop_script'},
	{ name=>'CHECK_MASK', isRequired=>0, column=>'check_mask'} );


sub _getConnection {
	if (!defined $dbh) {
		$dbh = DBNode({'PrintError'=>0,'RaiseError'=>1}) or die("Failed to connect to node DB: $DBI::errstr");
	}
	return $dbh;
}



sub _normalizePConf {
	my $pconf = shift;

	# key to uppercase, replace $APL placeholder
	while( my($param, $value) = each(%$pconf)) {
		my $uparam = uc($param);
		
		if ($uparam eq 'STARTUP') {
			; # TODO: STARTUP - 0 or 1
			# if(( $value =~ /^\s*[\+\-]?\d+\s*$/) and ($_[0] > 0)) {
		} elsif ($uparam eq 'CHECK_TIME') {
			; # TODO: CHECK_TIME - positive integer
		} else {
			; # TODO: check if parameter is one of the expected
		}

		$value =~ s/\$APL/$APL/g;
		$value =~ s/\$OWNER/$APL_USER/g;
		chomp $value;

		$pconf->{$uparam} = $value;
	}

	# check if 'procname' is provided
	exists($pconf->{'PROCNAME'}) || die "parameter 'PROCNAME' is misssing";
}


sub _updatePConf {
	my $pconf = shift;
	
	my ($columnIdx, $stmt) = (0, "UPDATE processes SET");
	my @bindValues = ();

	foreach my $param (@paramDefs) {
		if (exists($pconf->{$param->{'name'}}) && $param->{'name'} ne 'PROCNAME') {
			$columnIdx++;
			if ($columnIdx > 1) {
				$stmt .= ", $param->{'column'}=?";
			} else {
				$stmt .= " $param->{'column'}=?";
			}
			push @bindValues, $pconf->{$param->{'name'}};
		}
	}

	if ($columnIdx > 0) {
		$stmt .= ' WHERE procname=?';
		push @bindValues, $pconf->{'PROCNAME'};

		my $dbh = _getConnection();
		if ($dbh->do($stmt, undef, @bindValues) eq "0E0") {
			return 0;
		} else {
			return 1;
		}
	} else {
		return -1;
	}
}



sub _insertOrUpdatePConf {
	my $pconf = shift;

	my ($columnIdx, $stmt, $values) = (0, '','');
	my @bindValues = ();

	my $dbh = _getConnection();
	my $rows = $dbh->selectall_arrayref("SELECT 1 FROM processes WHERE procname='$pconf->{'PROCNAME'}'");
	if (@$rows) {
		#
		# Update
		#
		$stmt = 'UPDATE processes SET';

		foreach my $param (@paramDefs) {
			if ($param->{'name'} ne 'PROCNAME') {
				$columnIdx++;
				$stmt .= ',' if ($columnIdx > 1);
				if (exists($pconf->{$param->{'name'}})) {
					$stmt .= ' ' . $param->{'column'} . '=?';
					push @bindValues, $pconf->{$param->{'name'}};
				} elsif ($param->{'isRequired'}) {
					die "missing required parameter $param->{'name'}";
				} else {
					$stmt .= $param->{'column'} . '=null';
				}
			}
		}

		$stmt .= ' WHERE procname=?';
		push @bindValues, $pconf->{'PROCNAME'};

	} else {
		#
		# Insert
		#
		($stmt, $values) = ("INSERT INTO processes (", ") VALUES (" );

		foreach my $param (@paramDefs) {
			if (exists($pconf->{$param->{'name'}})) {
				# add column into insert statement
				$columnIdx++;
				if ($columnIdx > 1) {
					$stmt .= ',' . $param->{'column'};
					$values .= ',?';
				} else {
					$stmt .= $param->{'column'};
					$values .= '?';
				}
				push @bindValues, $pconf->{$param->{'name'}};

			} elsif ($param->{'isRequired'}) {
				die "missing required parameter $param->{'name'}";
			}
		}

		$stmt .= $values .')';
	}

	$dbh->do($stmt, undef, @bindValues);
}


#
# PUBLIC interface
#

sub insertProcess {
	my $pconf = shift;
	_normalizePConf($pconf);
	_insertOrUpdatePConf($pconf);
}


sub updateProcess {
	my $pconf = shift;
	_normalizePConf($pconf);
	return _updatePConf($pconf);
}


sub deleteProcess {
	my $procname = shift;
	my @bindValues = ($procname);

	my $dbh = _getConnection();
	if ($dbh->do("DELETE FROM processes WHERE procname=?", undef, @bindValues) eq "0E0") {
		return 0;
	} else {
		return 1;
	}
}


sub getProcessStartupAttr {
	my $procname = shift;

	my $dbh = _getConnection();
	my $rows = $dbh->selectall_arrayref("SELECT startup FROM processes WHERE procname='$procname'");
	if (@$rows) {
		return $rows->[0][0];
	} else {
		return undef;
	}

}


sub toggleProcess {
	my ($state, @procnames) = @_;

	if ($state eq 'on' || $state eq 'ON' || $state eq '1') {
		$state = 1;
	} elsif ($state eq 'off' || $state eq 'OFF' || $state eq '0') {
		$state = 0;
	} else {
		die "invalid 'state' parameter";
	}

	my $stmt = "UPDATE processes SET startup=? WHERE";
	my @bindValues = ($state);

	if ($#procnames < 0) {
		return 0;

	} elsif ($#procnames == 0) {
		$stmt .= ' procname=?';
		push @bindValues, $procnames[0];

	} else {
		$stmt .= " procname in (";
		my $flag = 0;
		foreach my $procname (@procnames) {
			if ($flag == 0) {
				$stmt .= '?';
                $flag = 1;
			} else {
				$stmt .= ',?';
			}
			push @bindValues, $procname;
		}
		$stmt .= ')';
	}

	my $dbh = _getConnection();
	my $updated = $dbh->do($stmt, undef, @bindValues);
	return ($updated eq "0E0") ? 0 : $updated;
}


1;
