package SKM::DB;

use 5.008008;
use strict;
use warnings;
use DBI;
#use Data::Dumper;

require Exporter;

our @ISA = qw(Exporter);

our %EXPORT_TAGS = ( 'all' => [ qw(
    DBMaster DBNode DBNodeConf DBMasterConf getDBLocation DBLocal
) ] );

our @EXPORT_OK = ( @{ $EXPORT_TAGS{'all'} } );

our @EXPORT = qw(
    DBMaster DBNode DBNodeConf DBMasterConf getDBLocation
);

our $VERSION = '0.01';

# Constants ----------------------------------------------------------
my $DB_CONF_PATH   = "$ENV{APL}/etc";
my $DB_MASTER_CONF = "$DB_CONF_PATH/skm_master.db.conf";
my $DB_LOCAL_CONF  = "$DB_CONF_PATH/skm_local.db.conf";
my $DB_NODE_CONF   = "$DB_CONF_PATH/skm_node.db.conf";
my %DEFAULT_ATTR   = (PrintError => 0, RaiseError => 0, FetchHashKeyName => 'NAME_lc');

# Vars ---------------------------------------------------------------
my $nodeconf   = {};
my $masterconf = {};
my $localconf  = {};

# Preloaded methods go here.



sub getDBLocation {
   my $cfg = shift;

   if ($cfg->{'type'} eq 'SQLite') {
      my $dbfile = $cfg->{'location'};
      $dbfile =~ s/\$APL/$ENV{APL}/g;
      $dbfile .= $cfg->{'name'};

      return $dbfile;

   } elsif ($cfg->{'type'} eq 'PGSQL') {
      return "/var/lib/pgsql/data";       #TBD!! replace with ENV

   } else {
      return "";

   }
}


sub getConnectionStr {
   my $cfg = shift;

   if ($cfg->{'type'} eq 'SQLite') {
      return "dbi:" . $cfg->{'dbi.driver'} . ":dbname=" . getDBLocation($cfg);

   } elsif ($cfg->{'type'} eq 'PGSQL') {
      return "dbi:".$cfg->{'dbi.driver'}.":dbname=$cfg->{name};host=$cfg->{host}";

   } else {
      die "Unknown database type " . $cfg->{'type'};
   }
}



sub DBInit {
    if (open(MASTER, $DB_MASTER_CONF)) {
		my %mcfg = map{/(^.+?)=(.*)/} grep {/^.+=.*/} <MASTER>;
		$masterconf = \%mcfg;
		close MASTER;
		$masterconf->{'dbi.connstr'} = getConnectionStr($masterconf);
    }
    if (open(LOCALDB, $DB_LOCAL_CONF)) {
		my %lcfg = map{/(^.+?)=(.*)/} grep {/^.+=.*/} <LOCALDB>;
		$localconf = \%lcfg;
		close LOCALDB;
		$localconf->{'dbi.connstr'} = getConnectionStr($localconf);
    }
    if (open(NODE, $DB_NODE_CONF)) {
		my %ncfg = map{/(^.+?)=(.*)/} grep {/^.+=.*/} <NODE>;
		$nodeconf = \%ncfg;
		close NODE;
		$nodeconf->{'dbi.connstr'} = getConnectionStr($nodeconf);
    }
}

sub DBMasterConf {
    return $masterconf;
}

sub DBLocalConf {
    return $masterconf;
}

sub DBNodeConf {
    return $nodeconf;
}

sub DBHandle {
    my $cfg = shift;
    my $arg = shift;
    my %attr = (%DEFAULT_ATTR, ref($arg) eq 'HASH' ? %$arg : ());
    my $dbh = DBI->connect($cfg->{'dbi.connstr'},$cfg->{user},$cfg->{password},\%attr);
    return $dbh;
}

sub DBMaster {
    return DBHandle($masterconf,@_);
}
sub DBLocal {
    return DBHandle($localconf,@_);
}
sub DBNode {
    return DBHandle($nodeconf,@_);
}

DBInit;

1;
__END__
# Below is stub documentation for your module. You'd better edit it!

=head1 NAME

SKM::DB - Perl extension for blah blah blah

=head1 SYNOPSIS

  use SKM::DB;
  blah blah blah

=head1 DESCRIPTION

Stub documentation for SKM::DB, created by h2xs. It looks like the
author of the extension was negligent enough to leave the stub
unedited.

Blah blah blah.


=head1 SEE ALSO

Mention other useful documentation such as the documentation of
related modules or operating system documentation (such as man pages
in UNIX), or any relevant external documentation such as RFCs or
standards.

If you have a mailing list set up for your module, mention it here.

If you have a web site set up for your module, mention it here.

=head1 AUTHOR

A. Tsibulnik, E<lt>crash@videonext.netE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2010 by videoNEXT

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself, either Perl version 5.8.8 or,
at your option, any later version of Perl 5 you may have available.


=cut
