#!/usr/bin/perl
# -----------------------------------------------------------------------------
#  Perl module to provide testing functionality
#  other NEXTcam engines
# -----------------------------------------------------------------------------
#  Author: Kosta Kanchev
#  Edited by: 
#  QA by:  Christopher C Gettings
#  Copyright: videoNEXT LLC
# -----------------------------------------------------------------------------

package NextCAM::WEBSession;

use 5.008;
use strict;
use warnings;
use Socket;
use Socket6 qw(in6addr_loopback inet_ntop);
use Master::Conf;

require Exporter;

our $VERSION = '1.00';
our @ISA = qw(Exporter);

# Symbols to be exported by default
our @EXPORT = qw(WEBSessionID WEBUserID WEBSessionAttr);

# ================================== Constants section ===============================

my $APL=$ENV{APL};					# directory structure root
my $APL_CONF=$ENV{APL_CONF} || "$APL/var/conf";		# conf-files are here - will be depreciated!!!
my $status = "authorized";
my $sid = '';
my $session;

# PLATFORM-SPECIFIC
my $SES = $^O =~ /linux/i ? '/var/lib/php/session/sess_' : '/tmp/sess_';

# ----------------------------------------------------------------- WEBSession -----

sub WEBSessionID {

my $touchSession = shift;
$touchSession = 1 if (!defined($touchSession));

if ($ENV{HTTP_COOKIE})
{
    foreach ( split /;/, $ENV{HTTP_COOKIE}) {
        next if not /PHPSESSID=(.*)/;
        $sid = $1;
    }
}
if (-f "$SES$sid" ){
		open SES,"$SES$sid";
		my $sinfo=<SES>;
		close SES;
		if (defined($sinfo)) {
			$status='notauthorized' if $sinfo!~/status\|s:8:"LoggedIn"/;
			if ($status eq "authorized") { 
				$session = $sid;

				# touch session file
				utime undef,undef,"$SES$sid" if ($touchSession);
			}
		}
}
return $session;
} # sub WEBSession #################################################################

sub WEBUserID {
    my ($sess,$mode) = @_;
    my $userID='anonim';
    if (-f "$SES$sess" ){
    		open SES,"$SES$sess";
    		my $sinfo=<SES>;
    		close SES;
    		if ($sinfo=~/status\|s:8:"LoggedIn"/)
    		{
    		    my @arg_ss=split ';' ,$sinfo ;

    		    if ($mode=~/^ID$/i)
    		    {
            		if ($arg_ss[2] =~/userid\|s\:\d+\:\"(\d+)\"$/) 
            		{ 
            		    $userID = $1;
            		}else{
            		    $userID='0';
            		}
            	}
            	elsif($mode=~/^NAME$/i)
            	{
               		if ($arg_ss[1] =~/username\|s\:\d+\:\"(.+)\"$/) 
            		{ 
            		    $userID = $1;
            		}else{
            		    $userID='none';
            		}

            	}
        	}
    }
    return $userID;
}

sub WEBSessionAttr {
    my ($sid, $touch, $allow_trusted) = @_;
    my %attrs = ();
    my $s_master = -f "$APL/var/conf/master/s_master";	# Check if we are running on master
    # extract sid from cookie if present
    if(not defined $sid and $ENV{HTTP_COOKIE} and $s_master) {
	foreach ( split /;/, $ENV{HTTP_COOKIE} ) {
    	    $sid = $1,last if /PHPSESSID=(.*)/;
    	}
    }
    # First check session ID if present
    if (defined $sid and $s_master) {
	if($sid=~/^([0-9a-zA-Z]*)$/ and -f "$SES$sid") {
	    my $ok = open SES, "$SES$sid";
	    my $sinfo = <SES> if $ok;
	    close SES;
	    if(defined $sinfo) {
		my @params = split ';' ,$sinfo;
		foreach(@params) {
		    $attrs{$1} = $2 if /^(\w+)\|s:\d+:\"(.*?)\"/;
		}
	    }
	    if($attrs{status} eq 'LoggedIn') {
		# touch session
		$attrs{touched} = utime undef, undef, "$SES$sid" if $touch;
		$attrs{sid} = $sid;
	    }
	}
    }
    elsif($allow_trusted and $ENV{REMOTE_ADDR}) { # Next check if remote address matches localhost or any of domain node IPs
	# Check for localhost (both IPv4 and IPv6)
	if ( $ENV{REMOTE_ADDR} eq inet_ntoa(INADDR_LOOPBACK)
    	      || $ENV{REMOTE_ADDR} eq inet_ntop(AF_INET6,in6addr_loopback) ) {
	    $attrs{trusted_ip} = 1;
	    $attrs{username} = 'SKM(localhost)';
	}
	elsif($ENV{REMOTE_ADDR} eq inet_ntoa(scalar(gethostbyname('s_master')))) {
	    $attrs{trusted_ip} = 1;
	    $attrs{username} = 'SKM(s_master)';
	}
	else {	# Walk through domain node IPs
	    my $nlist = NodeList;
    	    foreach my $node (keys %$nlist) {
		if($nlist->{$node}{IP} eq $ENV{REMOTE_ADDR}) {
		    $attrs{trusted_ip} = 1;
		    $attrs{username} = "SKM($nlist->{$node}{FQDN})";
		    last;
		}
	    }
	    if(not $attrs{trusted_ip} and -r "$APL/var/conf/trusted_hosts") {
		no warnings 'uninitialized';
		open(TRUSTED, "$APL/var/conf/trusted_hosts");
		while(<TRUSTED>) {
		    chomp;
		    $attrs{trusted_ip} = 1, $attrs{username} = "TRUSTED_HOST($_)", last 
			if $_ eq $ENV{REMOTE_ADDR} or $_ eq $ENV{REMOTE_HOST};
		}
		close TRUSTED;
	    }
	}
	$attrs{sid} = $attrs{userid} = -1 if $attrs{trusted_ip} == 1; # States that caller has enough permissions for the operation
    }
    undef $attrs{sid} unless defined $attrs{userid};
    return $attrs{sid} ? \%attrs : undef;
}

1;
__END__
