#!/usr/bin/perl
# -----------------------------------------------------------------------------
#  Perl module to provide testing functionality
#  other NEXTcam engines
# -----------------------------------------------------------------------------
#  Author: Serg Pososhenko
#  Edited by: 
#  QA by:  Christopher C Gettings
#  Copyright: videoNEXT LLC
# -----------------------------------------------------------------------------

package NextCAM::Test;

use 5.008;
use strict;
use warnings;

require Exporter;
#use AutoLoader qw(AUTOLOAD);
#use Log::Log4perl "get_logger";

our $VERSION = '1.01';
our @ISA = qw(Exporter);

# Symbols to be exported by default
our @EXPORT = qw(report CheckDirByRegexp CheckDirByOS );

# Export symbols in groups
#our %EXPORT_TAGS = (
#			'all' => [ qw( ) ],
#			'db'  => [ qw( ) ]
#                   );

# ================================== Constants section ===============================

my $APL=$ENV{APL};					# directory structure root
my $APL_CONF=$ENV{APL_CONF} || "$APL/var/conf";		# conf-files are here - will be depreciated!!!

# ----------------------------------------------------------------- report -----
sub report {
    my ($testName,$testPassedSuccess,$okMsg,$errMsg) = @_;
    $okMsg = 'OK' if not $okMsg;
    $errMsg = 'ERROR' if not $errMsg;
    print STDOUT ($testPassedSuccess ? $okMsg : $errMsg) . " $testName\n"; 
    print STDERR ($testPassedSuccess ? $okMsg : $errMsg) . " $testName\n" if not $testPassedSuccess; 
} # sub report #################################################################



# --------------------------------------------------------------- CheckDirByRegexp -----
# CheckDirByRegexp ("COMMENT","DirName", "Type", ["RegExp"])
#     "COMMENT"   - string to report to OUTPUT
#     "DirName"   - Start directory to create a list of files
#     "Type"      - type of file which suppose to be checked:
#                   "f" - files only
#                   "d" - subdirectoris only
#                   "" - bouth
#     "RegExp"    - Perl RegExp to run against each file in directory
#                   if here nothing  - function will return aa array.
#                  example: "/^-rw.r..r..+apl/"

sub CheckDirByRegexp {
    my ($testName,$dirName,$type,$chck_str) = @_;
    my @list=`ls -l $dirName`;
    if ($type eq 'f'){
    foreach my $fl (@list){
        if ($fl =~ /^-.+/)
        {
            chomp($fl);
            my $rr=$testName.' '.$fl;
            if ($chck_str){
              my $expr="\'$fl\' =~ $chck_str";
              report ($rr, eval($expr));
            }else{
              return @list;
            }
        }else {next}
     }
    }elsif($type eq 'd'){
    foreach my $fl (@list){
        if ($fl =~ /^d.+/)
        {
            chomp($fl);
            my $rr=$testName.' '.$fl;
            if ($chck_str){            
              my $expr="\'$fl\' =~ $chck_str";
              report ($rr, eval($expr));
            }else{
              return @list;
            }            
        }else {next}
     }
    }elsif(!$type){
       foreach my $fl (@list){
        if ($fl =~ /[^total]/)
        {        
          chomp($fl);
          my $rr=$testName.' '.$fl;
          if ($chck_str){            
            my $expr="\'$fl\' =~ $chck_str";
            report ($rr, eval($expr));
          }else{
            return @list;
          }
        }else {next}
       }
    }else{
       foreach my $fl (@list){
        if ($fl =~ /^[^total]/)
        {
        if ($fl =~ /$type/)
        {
          chomp($fl);
          my $rr=$testName.' '.$fl;
          if ($chck_str){            
            my $expr="\'$fl\' =~ $chck_str";
            report ($rr, eval($expr));
          }else{
            return @list;
          }
        }else {next}
        }else {next}
       }      
    }
} # sub CheckDirByRegexp #################################################################

# --------------------------------------------------------------- CheckDirByOS -----
# CheckDirByOS ("COMMENT","DirName", "Type", "OSCommand")
#     "COMMENT"   - string to report to OUTPUT
#     "DirName"   - Start directory to create a list of files
#     "Type"      - type of file which suppose to be checked:
#                   "f" - files only
#                   "d" - subdirectoris only
#                   "" - bouth
#     "OSCommand" - OS command string with 'FILE_NAME' - tag inside show place to put file name inside
#                   "`perl -wc FILE_NAME 2>&1` =~ /syntax\sOK/"
sub CheckDirByOS {
    my ($testName,$dirName,$type,$chck_str) = @_;
    my @ch_list = CheckDirByRegexp($testName,$dirName,$type);
    foreach my $fl (@ch_list){
     chomp($fl);
     my $rr=$testName.' '.$fl;
     $fl=$dirName.$fl;
     if ($chck_str){ 
       my $expr=$chck_str;
       $expr =~ s/FILE_NAME/$fl/;           
       $expr="\'$expr\'";
       report ($rr, eval($expr));
     }
    }
} # sub CheckDirByOS #################################################################

1;
__END__
