package NextCAM::Servicing::MBusTransport;

require 5.6.0;
use strict;
use warnings;

use Thrift;
use Thrift::Transport;
use NextCAM::Messenger;
use NextCAM::Servicing::MBusServiceHelper;

use Data::Dumper;

use base('Thrift::Transport');

sub new
{
	my $class	 = shift;
	my $messenger	 = shift;
	my $servicename	 = shift;
	my $recv_timeout = shift;

	# crete unique subscribtion so server could send us responses
        my @client_ip_id = getClientDeviceIPId;
	my $resp_msg = {
		device_IP	=> $client_ip_id[0],
		device_ID	=> $client_ip_id[1],
		ctxType		=> MSG_SERVICE_CONTEXT_TYPE,
		evtType		=> MSG_SERVICE_EVENT_TYPE,
		procLvl		=> MSG_SERVICE_PROCESS_LEVEL,
	};
	$messenger->subscribe($resp_msg);

        my @service_ip_id = getServiceDeviceIPId($servicename);

	my $req_msg = {
		device_IP	=> $service_ip_id[0],
		device_ID	=> $service_ip_id[1],
		ctxType		=> MSG_SERVICE_CONTEXT_TYPE,
		evtType		=> MSG_SERVICE_EVENT_TYPE,
		procLvl		=> MSG_SERVICE_PROCESS_LEVEL,
                message_ID      => 0,
                data            => "ReplyTo: " . $client_ip_id[0] . " " . $client_ip_id[1]
	};

	my $self = {
		messenger      => $messenger,
		servicename    => $servicename,
		recv_timeout   => $recv_timeout || 0xffffffff,
		rwBuf	       => '',
                req_msg        => $req_msg
	};

	return bless($self, $class);
};

sub open {}

#
# Read some data into the array.
#
# @param int    $len How much to read
# @return string The data that has been read
# @throws TTransportException if cannot read any more data
#
sub read
{
	my $self = shift;
	my $len  = shift;

        if (length($self->{rwBuf}) == 0)
        {
          # get new message
          my $msg = $self->{messenger}->recv($self->{recv_timeout});
          die "Connection closed!\n" unless defined $msg;
          die new Thrift::TException("Recv timeout expired") unless $msg;
          my @att_data = @{$msg->{att_data}};

          $self->{rwBuf} = $att_data[0];

        }

	if ( $len > length( $self->{rwBuf} ) )
	{
          $len = length( $self->{rwBuf} );
	}

	my $out = substr( $self->{rwBuf}, 0, $len );
        $self->{rwBuf} = substr($self->{rwBuf}, $len);

        return $out;
};

#
# Writes the given data out.
#
# @param string $buf  The data to write
# @throws TTransportException if writing fails
#
sub write
{
	my $self = shift;
	my $buf  = shift;

	$self->{rwBuf} .= $buf;
};

#
# Flushes any pending data out of a buffer
#
# @throws TTransportException if a writing error occurs
#
sub flush
{
	my $self = shift;
        $self->{req_msg}{att_description} = ["response0"];
        $self->{req_msg}{att_data}        = ["$self->{rwBuf}"];

        my $ret = $self->{messenger}->send($self->{req_msg});
	if (not defined $ret) {
            die new Thrift::TException("Could not send message");
        }

	$self->{rwBuf} = '';
        $self->{req_msg}{message_ID}++;
};

1;
